/*
 * FlinkDaoImplJDBC.java
 *
 * Created on 20061115, 9:14
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author tot
 */
public class FlinkDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(FlinkDaoImplJDBC.class);
    /** Creates a new instance of FlinkDaoImplJDBC */
    public FlinkDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){
        int returnValue=0;
        String sql=null;
        DataField df=null;/*
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql="select top 1 id from t_flink order by id desc";
            df=getFirstData(sql,"id");
        }else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql="select id from t_flink order by id desc limit 0,1";
            df=getFirstData(sql,"id");
        }else if(DBUtils.getDatabaseType()==DBUtils.DATABASE_DB2){
            sql="select id from t_flink order by id desc fetch first 1 rows only";
            df=getFirstData(sql,"id");
        }else if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
            sql="select id from t_flink where rownum=1 order by id desc";
            df=getFirstData(sql,"id");
        }else{
                           
        }*/
        sql="select id from t_flink order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df= (DataField)iter.next();
        }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"));
        }else{
            returnValue=1;
        }
        return returnValue;
    }
    /** add Flink */
    public boolean addFlink(String title,String url,String logo,int sortid,int linktype){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_flink(Title,Url,Logo,SortId,LinkType) values(?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,url);
            ps.setString(3,logo);
            ps.setInt(4,sortid);
            ps.setInt(5,linktype);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Flink error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Flink
     */
    public boolean modFlink(int id,String title,String url,String logo,int sortid,int linktype){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_flink set Title=?,Url=?,Logo=?,SortId=?,LinkType=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,url);
            ps.setString(3,logo);
            ps.setInt(4,sortid);
            ps.setInt(5,linktype);
            ps.setInt(6,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod Flink error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delFlink(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_flink where id="+id);
    }
    public Collection getFlinks(int linktype){
        String sql="select id,Title,Url,Logo,SortId,LinkType from t_flink where LinkType="+linktype+" order by SortId asc";
        return getData(sql,"id,Title,Url,Logo,SortId,LinkType");
    }
    public Collection getFlinkList_Limit(int linktype,int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title,Url,Logo,SortId,LinkType from t_flink");
            if(linktype>0) sql.append(" where LinkType="+linktype);
            sql.append(" order by SortId asc");
            return getDataList_mysqlLimit(sql.toString(),"id,Title,Url,Logo,SortId,LinkType",pagesize,(currentpage-1)*pagesize);
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title,Url,Logo,SortId,LinkType from t_flink");
            if(linktype>0) sql.append(" where LinkType="+linktype);
            sql.append(" order by SortId asc");
            return getDataList_Limit_Normal(sql.toString(),"id,Title,Url,Logo,SortId,LinkType",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField getFlink(int id){
        return getFirstData("select id,Title,Url,Logo,SortId,LinkType from t_flink where id="+id,"id,Title,Url,Logo,SortId,LinkType");
    }
    public int getTotalCount(int linktype){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_flink");
        sql.append(" where LinkType=");
        sql.append(linktype);
        return(this.getDataCount(sql.toString()));
    }
    public String getLinkList(int rowsNum,int colsNum,int linktype,String itcolor1,String itcolor2){
        StringBuffer sb=new StringBuffer(1024);
        ArrayList list=(ArrayList)getFlinks(linktype);
        Iterator iter = list.iterator();
        //begin
        sb.append("<TABLE  class=\"linklist\" cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\n");
        for(int rows=0;rows<rowsNum;rows++){
            if(rows%2==0){
                sb.append("<tr bgColor="+itcolor1+">\n");
            }else{
                sb.append("<tr bgColor="+itcolor2+">\n");
            }
            for(int cols=0;cols<colsNum;cols++){
                if(iter.hasNext()){
                    DataField df=(DataField)iter.next();
                    sb.append("<TD><DIV align=center>\n");
                    if(linktype==0){
                        sb.append("<A href=\""+df.getFieldValue("Url")+"\" title=\""+df.getFieldValue("Title")+"\" target=_blank>"+df.getFieldValue("Title")+"</A>\n");
                        
                    }else{
                        sb.append("<a href=\""+df.getFieldValue("Url")+"\" target=\"_blank\"><img src=\""+df.getFieldValue("Logo")+"\" width=\"88\" height=\"31\" border=\"0\" alt=\""+df.getFieldValue("Title")+"\"></a>\n");
                        
                    }
                    sb.append("</DIV></TD>\n");
                }else break;
            }
            sb.append("</tr>\n");
        }
        sb.append("</TABLE>\n");
        //end
        return sb.toString();
    }
}
