/*
 * FloorDaoImplJDBC.java
 *
 * Created on 2007616, 10:29
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class FloorDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(FloorDaoImplJDBC.class);
    /** Creates a new instance of FloorDaoImplJDBC */
    public FloorDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_floor order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
            Iterator iter = lists.iterator();
            if (iter.hasNext()) {
                df= (DataField)iter.next();                
            }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;       
    }
    
    /** add floor */
    public boolean addFloor(String UserName,String Title,String Photo_View,String Photo_Pos,String Photo_Map,int CityId,int AreaId,
            String Position,int Price,String WuyePrice,String HouseType,String DevCom,String CardForSale,String AddressForSale,
            String Tel_Sale,Timestamp OpenDate,Timestamp LiveinDate,String Area_Ground,String Area_Build,String FloorNum,
            String FloorHeight,String BuildDensity,String P_Virescence,String P_Cubage,String BuildStruct,String TrafficInfo,
            String AroundPart,String FitmentStatus,String IfNowHouse,String SaleStatus,Timestamp Moditime,int IsCheck,int IsVip,
            String OtherDes,int Hits,String HomePage){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_floor(UserName,Title,Photo_View,Photo_Pos,Photo_Map,CityId,AreaId,Position,Price,WuyePrice," +
                "HouseType,DevCom,CardForSale,AddressForSale,Tel_Sale,OpenDate,LiveinDate,Area_Ground,Area_Build,FloorNum," +
                "FloorHeight,BuildDensity,P_Virescence,P_Cubage,BuildStruct,TrafficInfo,AroundPart,FitmentStatus,IfNowHouse," +
                "SaleStatus,Moditime,IsCheck,IsVip,OtherDes,Hits,HomePage)" +
                " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,UserName);
            ps.setString(2,Title);
            ps.setString(3,Photo_View);
            ps.setString(4,Photo_Pos);
            ps.setString(5,Photo_Map);
            ps.setInt(6,CityId);
            ps.setInt(7,AreaId);
            ps.setString(8,Position);
            ps.setInt(9,Price);
            ps.setString(10,WuyePrice);
            ps.setString(11,HouseType);
            ps.setString(12,DevCom);
            ps.setString(13,CardForSale);
            ps.setString(14,AddressForSale);
            ps.setString(15,Tel_Sale);
            ps.setTimestamp(16,OpenDate);
            ps.setTimestamp(17,LiveinDate);
            ps.setString(18,Area_Ground);
            ps.setString(19,Area_Build);
            ps.setString(20,FloorNum);
            ps.setString(21,FloorHeight);
            ps.setString(22,BuildDensity);
            ps.setString(23,P_Virescence);
            ps.setString(24,P_Cubage);
            ps.setString(25,BuildStruct);
            ps.setString(26,TrafficInfo);
            ps.setString(27,AroundPart);
            ps.setString(28,FitmentStatus);
            ps.setString(29,IfNowHouse);
            ps.setString(30,SaleStatus);
            ps.setTimestamp(31,Moditime);
            ps.setInt(32,IsCheck);
            ps.setInt(33,IsVip);            
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(34, new StringReader(OtherDes), OtherDes.length());
            }else{
                ps.setString(34,OtherDes);
            }
            ps.setInt(35,Hits);
            ps.setString(36,HomePage);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add floor error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /** mod floor */
    public boolean modFloor(int id,String UserName,String Title,String Photo_View,String Photo_Pos,String Photo_Map,int CityId,int AreaId,
            String Position,int Price,String WuyePrice,String HouseType,String DevCom,String CardForSale,String AddressForSale,
            String Tel_Sale,Timestamp OpenDate,Timestamp LiveinDate,String Area_Ground,String Area_Build,String FloorNum,
            String FloorHeight,String BuildDensity,String P_Virescence,String P_Cubage,String BuildStruct,String TrafficInfo,
            String AroundPart,String FitmentStatus,String IfNowHouse,String SaleStatus,Timestamp Moditime,int IsCheck,int IsVip,
            String OtherDes,int Hits,String HomePage){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_floor set UserName=?,Title=?,Photo_View=?,Photo_Pos=?,Photo_Map=?,CityId=?,AreaId=?,Position=?,Price=?," +
                "WuyePrice=?,HouseType=?,DevCom=?,CardForSale=?,AddressForSale=?,Tel_Sale=?,OpenDate=?,LiveinDate=?,Area_Ground=?," +
                "Area_Build=?,FloorNum=?,FloorHeight=?,BuildDensity=?,P_Virescence=?,P_Cubage=?,BuildStruct=?,TrafficInfo=?,AroundPart=?," +
                "FitmentStatus=?,IfNowHouse=?,SaleStatus=?,Moditime=?,IsCheck=?,IsVip=?,OtherDes=?,Hits=?,HomePage=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,UserName);
            ps.setString(2,Title);
            ps.setString(3,Photo_View);
            ps.setString(4,Photo_Pos);
            ps.setString(5,Photo_Map);
            ps.setInt(6,CityId);
            ps.setInt(7,AreaId);
            ps.setString(8,Position);
            ps.setInt(9,Price);
            ps.setString(10,WuyePrice);
            ps.setString(11,HouseType);
            ps.setString(12,DevCom);
            ps.setString(13,CardForSale);
            ps.setString(14,AddressForSale);
            ps.setString(15,Tel_Sale);
            ps.setTimestamp(16,OpenDate);
            ps.setTimestamp(17,LiveinDate);
            ps.setString(18,Area_Ground);
            ps.setString(19,Area_Build);
            ps.setString(20,FloorNum);
            ps.setString(21,FloorHeight);
            ps.setString(22,BuildDensity);
            ps.setString(23,P_Virescence);
            ps.setString(24,P_Cubage);
            ps.setString(25,BuildStruct);
            ps.setString(26,TrafficInfo);
            ps.setString(27,AroundPart);
            ps.setString(28,FitmentStatus);
            ps.setString(29,IfNowHouse);
            ps.setString(30,SaleStatus);
            ps.setTimestamp(31,Moditime);
            ps.setInt(32,IsCheck);
            ps.setInt(33,IsVip);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(34, new StringReader(OtherDes), OtherDes.length());
            }else{
                ps.setString(34,OtherDes);
            }
            ps.setInt(35,Hits);
            ps.setString(36,HomePage);
            ps.setInt(37,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod floor error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /** get count
     * @param ischeck ״̬,0=δ,1=
     * @param cityid ID,0=ȫ
     * @param areaid ID,0=ȫ
     * @param isvip ǷvipԱ
     * @return int
     */
    public int getTotalCount(int ischeck,int cityid,int areaid,int isvip){
        String sql="select count(*) from t_floor where IsCheck="+ischeck;
        if(cityid!=0){
            sql+=" and CityId="+cityid;
        }
        if(areaid!=0){
            sql+=" and AreaId="+areaid;
        }
        if(isvip!=0){
            sql+=" and IsVip="+isvip;
        }
        return(this.getDataCount(sql));
    }
    /** get floor list
     * @param ischeck ״̬,0=δ,1=
     * @param cityid ID,0=ȫ
     * @param areaid ID,0=ȫ
     * @param isvip ǷvipԱ
     * @return Collection
     */
    public Collection getFloorList(int ischeck,int cityid,int areaid,int isvip,int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title,Photo_View,Position,Price,HouseType,DevCom,CardForSale,Tel_Sale,OpenDate,Hits,IsVip,ModiTime";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr).append(" from t_floor ");
            sql.append(" WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_floor where IsCheck=").append(ischeck);
            //ж
            if(cityid!=0){
                sql.append(" and CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and AreaId=").append(areaid);
            }
            if(isvip!=0){
                sql.append(" and IsVip=").append(isvip);
            }
            sql.append("ORDER BY id DESC) AS t))");
            sql.append("  and IsCheck=").append(ischeck);
            //ж
            if(cityid!=0){
                sql.append(" and CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and AreaId=").append(areaid);
            }
            if(isvip!=0){
                sql.append(" and IsVip=").append(isvip);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ").append(fieldArr).append(" from t_floor where IsCheck=").append(ischeck);
            //ж
            if(cityid!=0){
                sql.append(" and CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and AreaId=").append(areaid);
            }
            if(isvip!=0){
                sql.append(" and IsVip=").append(isvip);
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ").append(fieldArr).append(" from t_floor where IsCheck=").append(ischeck);
            //ж
            if(cityid!=0){
                sql.append(" and CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and AreaId=").append(areaid);
            }
            if(isvip!=0){
                sql.append(" and IsVip=").append(isvip);
            }
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }
    }
    //search
    /** get count
     * @param ischeck ״̬,0=δ,1=
     * @param cityid ID,0=ȫ
     * @param areaid ID,0=ȫ
     * @param isvip ǷvipԱ
     * @param price_start ʼ۸
     * @param price_end    ۸
     * @param housetype ¥
     * @param searchby  ʽ1=¥ƣ2ƣ3¥λ
     * @return int
     */
    public int getTotalCount(int ischeck,int cityid,int areaid,int isvip,int price_start,int price_end,String housetype,int searchby,String keywd){
        String sql="select count(*) from t_floor where IsCheck="+ischeck;
        if(cityid!=0){
            sql+=" and CityId="+cityid;
        }
        if(areaid!=0){
            sql+=" and AreaId="+areaid;
        }
        if(isvip!=0){
            sql+=" and IsVip="+isvip;
        }
        if(price_start!=0 && price_end!=0){
            sql+=" and Price>="+price_start+" and Price <="+price_end;
        }
        if(housetype!=null){
            sql+=" and HouseType='"+housetype+"'";
        }
        switch(searchby){
            case 1:
                sql+=" and Title like '%"+keywd+"%'";
            case 2:
                sql+=" and DevCom like '%"+keywd+"%'";
            case 3:
                sql+=" and Position like '%"+keywd+"%'";
        }
        return(this.getDataCount(sql));
    }
    /** get floor list
     * @param ischeck ״̬,0=δ,1=
     * @param cityid ID,0=ȫ
     * @param areaid ID,0=ȫ
     * @param isvip ǷvipԱ
     * @return Collection
     */
    public Collection getFloorList(int ischeck,int cityid,int areaid,int isvip,int price_start,int price_end,String housetype,int searchby,String keywd,int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title,Photo_View,Position,Price,HouseType,DevCom,CardForSale,Tel_Sale,OpenDate,Hits,IsVip,ModiTime";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr).append(" from t_floor ");
            sql.append(" WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_floor where IsCheck=").append(ischeck);
            //ж
            if(cityid!=0){
                sql.append(" and CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and AreaId=").append(areaid);
            }
            if(isvip!=0){
                sql.append(" and IsVip=").append(isvip);
            }
            if(housetype!=null){
                sql.append(" and HouseType='").append(housetype).append("'");
            }
            if(price_start!=0 && price_end!=0){
                sql.append(" and Price>=").append(price_start).append(" and Price <=").append(price_end);
            }
            switch(searchby){
                case 1:
                    sql.append(" and Title like '%").append("%'");
                case 2:
                    sql.append(" and DevCom like '%").append("%'");
                case 3:
                    sql.append(" and Position like '%").append("%'");
            }
            sql.append("ORDER BY id DESC) AS t))");
            sql.append("  and IsCheck=").append(ischeck);
            //ж
            if(cityid!=0){
                sql.append(" and CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and AreaId=").append(areaid);
            }
            if(isvip!=0){
                sql.append(" and IsVip=").append(isvip);
            }
            if(price_start!=0 && price_end!=0){
                sql.append(" and Price>=").append(price_start).append(" and Price <=").append(price_end);
            }
            if(housetype!=null){
                sql.append(" and HouseType='").append(housetype).append("'");
            }
            switch(searchby){
                case 1:
                    sql.append(" and Title like '%").append("%'");
                case 2:
                    sql.append(" and DevCom like '%").append("%'");
                case 3:
                    sql.append(" and Position like '%").append("%'");
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ").append(fieldArr).append(" from t_floor where IsCheck=").append(ischeck);
            //ж
            if(cityid!=0){
                sql.append(" and CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and AreaId=").append(areaid);
            }
            if(isvip!=0){
                sql.append(" and IsVip=").append(isvip);
            }
            if(price_start!=0 && price_end!=0){
                sql.append(" and Price>=").append(price_start).append(" and Price <=").append(price_end);
            }
            if(housetype!=null){
                sql.append(" and HouseType='").append(housetype).append("'");
            }
            switch(searchby){
                case 1:
                    sql.append(" and Title like '%").append("%'");
                case 2:
                    sql.append(" and DevCom like '%").append("%'");
                case 3:
                    sql.append(" and Position like '%").append("%'");
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }        
    }
    /* get floor by id */
    public DataField getFloor(int id){
        String fields="UserName,Title,Photo_View,Photo_Pos,Photo_Map,CityId,AreaId,Position,Price,WuyePrice," +
                "HouseType,DevCom,CardForSale,AddressForSale,Tel_Sale,OpenDate,LiveinDate,Area_Ground,Area_Build,FloorNum," +
                "FloorHeight,BuildDensity,P_Virescence,P_Cubage,BuildStruct,TrafficInfo,AroundPart,FitmentStatus,IfNowHouse," +
                "SaleStatus,Moditime,IsCheck,IsVip,OtherDes,Hits,HomePage";
        return getFirstData("select "+fields+" from t_floor where id="+id,fields);
    }
    public boolean delFloor(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_floor where id="+id);
    }
    public void updateHits(int id) throws ObjectNotFoundException,DatabaseException{
        exe("update t_floor set Hits=Hits+1 where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_floor where id=?",s);
    }
    public void batCheck(String[] s){
        this.bat("update t_floor set IsCheck=1 where id=?",s);
    }
    public void batUnCheck(String[] s){
        this.bat("update t_floor set IsCheck=0 where id=?",s);
    }
    public void batVip(String[] s){
        this.bat("update t_floor set IsVip=1 where id=?",s);
    }
    public void batUnVip(String[] s){
        this.bat("update t_floor set IsVip=0 where id=?",s);
    }
}
