/*
 * FloorNewsDaoImplJDBC.java
 *
 * Created on 200774, 10:08
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author tot cms
 */
public class FloorNewsDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(FloorNewsDaoImplJDBC.class);
    /** Creates a new instance of FloorNewsDaoImplJDBC */
    public FloorNewsDaoImplJDBC() {
    }
    public boolean addFloorNews(int floorid,String pubdate,String content,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_floornews(FloorId,PubDate,Content,ModiTime) values(?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,floorid);
            ps.setString(2,pubdate);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(3, new StringReader(content), content.length());
            }else{
                ps.setString(3,content);
            }     
            ps.setTimestamp(4,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod FloorNews
     */
    public boolean modFloorNews(int id,int floorid,String pubdate,String content,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_floornews set FloorId=?,PubDate=?,Content=?,ModiTime=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,floorid);
            ps.setString(2,pubdate);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(3, new StringReader(content), content.length());
            }else{
                ps.setString(3,content);
            }    
            ps.setTimestamp(4,moditime);
            ps.setInt(5,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }    
    public boolean delFloorNews(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_floornews where id="+id);
    }
    public Collection getFloorNewss(){
        String sql="select id,FloorId,PubDate,Content,ModiTime from t_floornews order by id asc";
        return getData(sql,"id,FloorId,PubDate,Content,ModiTime");
    }
    public Collection getFloorNewsList_Limit(int floorid,int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,FloorId,PubDate,Content,ModiTime from t_floornews");
            if(floorid>0) sql.append(" where FloorId="+floorid);
            return getDataList_mysqlLimit(sql.toString(),"id,FloorId,PubDate,Content,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,FloorId,PubDate,Content,ModiTime FROM t_floornews WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_floornews");
            if(floorid>0) sql.append(" where FloorId="+floorid);
            sql.append(" ORDER BY id DESC) AS t))");
            if(floorid>0) sql.append(" and FloorId="+floorid);
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,FloorId,PubDate,Content,ModiTime");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,FloorId,PubDate,Content,ModiTime from t_floornews");
            if(floorid>0) sql.append(" where FloorId="+floorid);
            return getDataList_Limit_Normal(sql.toString(),"id,FloorId,PubDate,Content,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField getFloorNews(int id){
        return getFirstData("select FloorId,PubDate,Content,ModiTime from t_floornews where id="+id,"FloorId,PubDate,Content,ModiTime");
    }
    public int getTotalCount(int floorid){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_floornews");
        if(floorid>0){
            sql.append(" where FloorId=");
            sql.append(floorid);
        }
        return(this.getDataCount(sql.toString()));
    }
    public void batDel(String[] s){
        this.bat("delete from t_floornews where id=?",s);
    }  
}
