/*
 * LabelDaoImplJDBC.java
 *
 * Created on 2006923, 9:29
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package tot.dao.jdbc;

import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.LabelUtil;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author totcms
 */
public class FunctionDaoImplJDBC extends AbstractDao {
    private static Log log = LogFactory.getLog(FunctionDaoImplJDBC.class);
    /** Creates a new instance of LabelDaoImplJDBC */
    public FunctionDaoImplJDBC() {
    }
    public static String getTables(String tbl){
        StringBuffer sb=new StringBuffer(1024);
        Connection conn = null;
        String[] tbltypes={"TABLE"};
        ResultSet rs=null;
        try{
            conn = DBUtils.getConnection();
            DatabaseMetaData dbm=conn.getMetaData();
            rs=dbm.getTables(null, null, null,tbltypes);
            while(rs.next()){
                sb.append("<option value=\""+rs.getString(3)+"\"");
                if(tbl!=null && tbl.equals(rs.getString(3))){
                    sb.append(" selected=\"selected\"");
                }
                sb.append(">"+rs.getString(3)+"</option>\n");
            }
        }catch(SQLException e){} finally{
            try{
                DBUtils.closeResultSet(rs);
                DBUtils.closeConnection(conn);
            } catch(Exception sqle) {}
        }
        return sb.toString();
    }
    public static String getFieldsCheckBox(String tbl){
        StringBuffer sb=new StringBuffer(1024);
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs=null;
         try{
            conn = DBUtils.getConnection();
            statement=conn.prepareStatement("select * from "+tbl+" where 1=0");
            rs=statement.executeQuery();
            ResultSetMetaData rm=rs.getMetaData();
            for(int i=1;i<=rm.getColumnCount();i++){
                sb.append("<input type=\"checkbox\" name=\"field_cb\" id=\"field_cb\" value=\""+rm.getColumnName(i)+"\" />"+rm.getColumnName(i));
                //sb.append("<option value=\""+rm.getColumnName(i)+"\">"+rm.getColumnName(i)+"</option>\n");
            }
        }catch(SQLException sqle) {
        } finally {
            try{
                DBUtils.closePrepareStatement(statement);
                DBUtils.closeResultSet(rs);
                DBUtils.closeConnection(conn);
            } catch(Exception sqle) {}
        }
        return sb.toString();
    }
    public static String getFieldsOption(String tbl){
        StringBuffer sb=new StringBuffer(1024);
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs=null;
         try{
            conn = DBUtils.getConnection();
            statement=conn.prepareStatement("select * from "+tbl+" where 1=0");
            rs=statement.executeQuery();
            ResultSetMetaData rm=rs.getMetaData();
            for(int i=1;i<=rm.getColumnCount();i++){
                //sb.append("<input type=\"checkbox\" name=\"field_cb\" id=\"field_cb\" value=\""+rm.getColumnName(i)+"\" />"+rm.getColumnName(i));
                sb.append("<option value=\""+rm.getColumnName(i)+"\">"+rm.getColumnName(i)+"</option>\n");
            }
        }catch(SQLException sqle) {
        } finally {
            try{
                DBUtils.closePrepareStatement(statement);
                DBUtils.closeResultSet(rs);
                DBUtils.closeConnection(conn);
            } catch(Exception sqle) {}
        }
        return sb.toString();
    }
    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_function order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField) iter.next();
        }
        if (df != null) {
            returnValue = Integer.parseInt(df.getFieldValue("id")) + 1;
        } else {
            returnValue = 1;
        }
        return returnValue;
    }

    public DataField get(int id) {
        String fieldArr = "id,CategoryId,Title,Demons,Content,ModiTime";
        return getFirstData("select " + fieldArr + " from t_function where id=" + id, fieldArr);
    }

    /**
     * get label count by category id,if 0 then return all
     */
    public int getTotalCount(int categoryid) {
        String sql = "select count(*) from t_function";
        if (categoryid > 0) {
            sql += " where CategoryId=" + categoryid;
        }
        return (getDataCount(sql));
    }

    public boolean add(int categoryid, String title, String demons, String content, Timestamp moditime) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_function(CategoryId,Title,Demons,Content,ModiTime) values(?,?,?,?,?)";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setInt(1, categoryid);
            ps.setString(2, title);
            ps.setString(3, demons);
            if (DBUtils.getDatabaseType() == DBUtils.DATABASE_ORACLE) {
                ps.setCharacterStream(4, new StringReader(content), content.length());
            } else {
                ps.setString(4, content);
            }
            ps.setTimestamp(5, moditime);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        } catch (SQLException e) {
            log.error("add Label error", e);
        } finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod label
     */

    public boolean mod(int id, int categoryid, String title, String dmons, String content, Timestamp moditime) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_function set CategoryId=?,Title=?,Demons=?,Content=?,ModiTime=? where id=?";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setInt(1, categoryid);
            ps.setString(2, title);
            ps.setString(3, dmons);
            if (DBUtils.getDatabaseType() == DBUtils.DATABASE_ORACLE) {
                ps.setCharacterStream(4, new StringReader(content), content.length());
            } else {
                ps.setString(4, content);
            }
            ps.setTimestamp(5, moditime);
            ps.setInt(6, id);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        } catch (SQLException e) {
            log.error("mod Label error", e);
        } finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    public boolean del(int id) throws ObjectNotFoundException, DatabaseException {
        return exe("delete from t_function where id=" + id);
    }

    public String getContent(int id) {
        DataField df = getFirstData("select Content from t_function where id=" + id, "Content");
        String returnValue = null;
        if (df != null) {
            returnValue = df.getFieldValue("Content");
        }
        return returnValue;
    }
    public String getContent(String title) {
        DataField df = getFirstData("select Content from t_function where Title='" + title+"'", "Content");
        String returnValue = null;
        if (df != null) {
            returnValue = df.getFieldValue("Content");
        }
        return returnValue;
    }

    public Collection getByCategory(int categoryid) {
        String fieldStr = "id,Title,Content";
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(fieldStr);
        sql.append(" from t_function");
        if (categoryid > 0) {
            sql.append(" where CategoryId=0 or CategoryId=" + categoryid);
        }
        return getData(sql.toString(), fieldStr);
    }

    public Collection getList_Limit(int categoryid, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_function");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" order by id desc");
            return getDataList_mysqlLimit(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id, Title,Demons,ModiTime FROM t_function WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_function");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(), "id,Title,Demons,ModiTime");
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_function");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            return getDataList_Limit_Normal(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
    }

    public Collection getSearchList_Limit(int categoryid, int sby, String key, int currentpage, int pagesize) {
        String fields = "Title";
        if (sby == 1) {
            fields = "Demons";
        }
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_function where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" order by id desc");
            return getDataList_mysqlLimit(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id, Title,Demons,ModiTime FROM t_function WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_function where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(), "id,Title,Demons,ModiTime");
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_function where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            return getDataList_Limit_Normal(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
    }

    public int getTotalCount(int categoryid, int sby, String key) {
        StringBuffer sql = new StringBuffer(512);
        String fields = "Title";
        if (sby == 1) {
            fields = "Demons";
        }
        sql.append("select count(*) from t_function where 1=1");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        if (key != null) {
            sql.append(" and " + fields + " like '%" + key + "%'");
        }
        return (this.getDataCount(sql.toString()));
    }
}
