/*
 * GatherHisDaoImplJDBC.java
 *
 * Created on 200727, 10:40
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class GatherHisDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(GatherHisDaoImplJDBC.class);
    /** Creates a new instance of GatherHisDaoImplJDBC */
    public GatherHisDaoImplJDBC() {
    }
    /** add GatherHis */
    public boolean addGatherHis(String title,String url,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_gatherhis(Title,Url,ModiTime) values(?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,url);
            ps.setTimestamp(3,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add GatherHis error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod GatherHis
     */
    public boolean modGatherHis(int id,String title,String url,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_gatherhis set Title=?,Url=?,ModiTime=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,url);
            ps.setTimestamp(3,moditime);
            ps.setInt(4,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod GatherHis error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean isGathered(String url){
        if(url==null) return true;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean returnValue=true;
        String sql=null;
        sql="select * from t_gatherhis where Url=?";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,url);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=true;
            }else{
                returnValue=false;
            }
        } catch(SQLException e){            
            log.error("get isGathered",e);  
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delGatherHis(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_gatherhis where id="+id);
    }
    public Collection getGatherHis(){
        String sql="select id,Title,Url,ModiTime from t_gatherhis order by id asc";
        return getData(sql,"id,Title,Url,ModiTime");
    }
    public Collection getGatherHisList_Limit(int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            return getDataList_mysqlLimit("select id,Title,Url,ModiTime from t_gatherhis order by id desc","id,Title,Url,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            String sql="SELECT TOP "+pagesize+" id, Title,Url, ModiTime FROM t_gatherhis WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_gatherhis ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return getData(sql,"id,Title,Url,ModiTime");
        } else{
            return getDataList_Limit_Normal("select id,Title,Url,ModiTime from t_gatherhis order by id desc","id,Title,Url,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField getGatherHis(int id){
        return getFirstData("select id,Title,Url,ModiTime from t_gatherhis where id="+id,"id,Title,Url,ModiTime");
    }
    public int getTotalCount(){
        return(this.getDataCount("select count(*) from t_gatherhis"));
    }  
    public void batDel(String[] s){
        this.bat("delete from t_gatherhis where id=?",s);
    }
}
