/*
 * GuestBookDaoImplJDBC.java
 *
 * Created on 2007119, 10:51
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class GuestbookDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(GuestbookDaoImplJDBC.class);
    /** Creates a new instance of GuestBookDaoImplJDBC */
    public GuestbookDaoImplJDBC() {
    }
    /** add GuestBook */
    public boolean addGuestBook(int objid,int typeid,String author,String content,String ip,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_gbook(ObjId,TypeId,Author,Content,Ip,ModiTime) values(?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,objid);
            ps.setInt(2,typeid);
            ps.setString(3,author);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(4, new StringReader(content), content.length());
            }else{
                ps.setString(4,content);
            }
            ps.setString(5,ip);           
            ps.setTimestamp(6,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add GuestBook error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod GuestBook
     */
    public boolean modGuestBook(int id,String author,String content){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_gbook set author=?,Content=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,author);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(2, new StringReader(content), content.length());
            }else{
                ps.setString(2,content);
            }      
            ps.setInt(3,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod GuestBook error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }    
    public DataField getGuestBook(int id){
        return getFirstData("select id,ObjId,TypeId,Author,Content,Ip,ModiTime from t_gbook where id="+id,"id,ObjId,TypeId,Author,Content,Ip,ModiTime");
    }
    public boolean delGuestBook(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_gbook where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_gbook where id=?",s);
    }    
    public Collection getGuestBookListByObj_Limit(int objid,int typeid,int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Author,Content,Ip,ModiTime from t_gbook where 1=1");
            if(objid>0) sql.append(" and ObjId="+objid);
            if(typeid>0) sql.append(" and TypeId="+typeid);
            return getDataList_mysqlLimit(sql.toString(),"id,Author,Content,Ip,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Author,Content,Ip,ModiTime FROM t_gbook WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_gbook where 1=1");
            if(objid>0) sql.append(" and ObjId="+objid);
            if(typeid>0) sql.append(" and TypeId="+typeid);
            sql.append(" ORDER BY id DESC) AS t))");
            if(objid>0) sql.append(" and ObjId="+objid);
            if(typeid>0) sql.append(" and TypeId="+typeid);
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,Author,Content,Ip,ModiTime");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Author,Content,Ip,ModiTime from t_gbook where 1=1");
            if(objid>0) sql.append(" and ObjId="+objid);
            if(typeid>0) sql.append(" and TypeId="+typeid);
            return getDataList_Limit_Normal(sql.toString(),"id,Author,Content,Ip,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }    
    public int getTotalCount(int objid,int typeid){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_gbook where 1=1");
        if(objid>0){
            sql.append(" and ObjId=");
            sql.append(objid);
        }
        if(typeid>0){
            sql.append(" and TypeId=");
            sql.append(typeid);
        }
        return(this.getDataCount(sql.toString()));
    }
}
