/*
 * HxDaoImplJDBC.java
 *
 * Created on 2007610, 11:52
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class HxDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(HxDaoImplJDBC.class);
    /** Creates a new instance of HxDaoImplJDBC */
    public HxDaoImplJDBC() {
    }
    /** add hx */
    public boolean addHx(String title,String photo,int floorid,int typeid){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_hx(Title,Photo,FloorId,Ptype) values(?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,photo);
            ps.setInt(3,floorid);
            ps.setInt(4,typeid);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add hx error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod floor level
     */
    public boolean modHx(int id,String title,String photo,int floorid,int typeid){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_hx set Title=?,Photo=?,FloorId=?,Ptype=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,photo);
            ps.setInt(3,floorid);
            ps.setInt(4,typeid);
            ps.setInt(5,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod area error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /* delete floor level by id */
    public boolean delHx(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_hx where id="+id);
    }
    /* get area by id */
    public DataField getHx(int id){
        return getFirstData("select id,Title,Photo,FloorId,Ptype from t_hx where id="+id,"id,Title,Photo,FloorId,Ptype");
    }
    /* get area count */
    public int getTotalCount(int floorid){
        String sql="select count(*) from t_hx";
        if(floorid!=0){
            sql+=" where FloorId="+floorid;
        }
        return(this.getDataCount(sql));
    }    
    /* get list */
    public Collection getHxList(int floorid,int ptype,int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title,Photo";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_hx WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_hx where 1=1");
            if(floorid!=0){
                sql.append(" and FloorId=").append(floorid);
            }
            if(ptype!=0){
                sql.append(" and Ptype=").append(ptype);
            }
            sql.append("ORDER BY id DESC) AS t))");
            if(floorid!=0){
                sql.append(" and FloorId=").append(floorid);
            }
            if(ptype!=0){
                sql.append(" and Ptype=").append(ptype);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_hx where 1=1");
            if(floorid!=0){
                sql.append(" and FloorId=").append(floorid);
            }
            if(ptype!=0){
                sql.append(" and Ptype=").append(ptype);
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_hx where 1=1");
            if(floorid!=0){
                sql.append(" and FloorId=").append(floorid);
            }
            if(ptype!=0){
                sql.append(" and Ptype=").append(ptype);
            }
            sql.append(" order by id desc");
            return this.getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }        
    }    
    public void batDel(String[] s){
        this.bat("delete from t_hx where id=?",s);
    }
}
