/*
 * InfoTypeDaoImplJDBC.java
 *
 * Created on 2007610, 11:52
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class InfoTypeDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(InfoTypeDaoImplJDBC.class);
    /** Creates a new instance of InfoTypeDaoImplJDBC */
    public InfoTypeDaoImplJDBC() {
    }
    /** add floor level */
    public boolean addInfoType(String title){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="insert into t_2infotype(Title) values(?)";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("add infotype error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod floor level
     */
    public boolean modInfoType(int id,String title){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="update t_2infotype set Title=? where id=?";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql); 
            ps.setString(1,title);
            ps.setInt(2,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("mod infotype error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /* delete floor level by id */
    public boolean delInfoType(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_2infotype where id="+id);
    }
    /* get infotype by id */
    public DataField getInfoType(int id){
        return getFirstData("select id,Title from t_2infotype where id="+id,"id,Title");
    }
    /* get infotype count */
    public int getTotalCount(){
        return(this.getDataCount("select count(*) from t_2infotype"));
    }
    /* get list */
    public Collection getInfoTypeList(int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_2infotype WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_2infotype");            
            sql.append("ORDER BY id DESC) AS t))");            
            sql.append(" ORDER BY id DESC");        
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_2infotype");            
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_2infotype");            
            sql.append(" order by id desc");
            return this.getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }        
    }
    /* get floor level select */
    public String getSelect(int currentid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;        
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_2infotype order by id asc");            
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if(currentid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }            
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);            
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    public void batDel(String[] s){
        this.bat("delete from t_2infotype where id=?",s);
    }
}
