/*
 * KeywordsDaoImplJDBC.java
 *
 * Created on 2007311, 7:56
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class KeywordsDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(KeywordsDaoImplJDBC.class);
    /** Creates a new instance of KeywordsDaoImplJDBC */
    public KeywordsDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_keywords order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
            Iterator iter = lists.iterator();
            if (iter.hasNext()) {
                df= (DataField)iter.next();                
            }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;        
    }
    /** add Keywords */
    public boolean addKeywords(String title,String url){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_keywords(Title,Url) values(?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);            
            ps.setString(1,title);
            ps.setString(2,url);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Keywords error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Keywords
     */
    public boolean modKeywords(int id,String title,String url){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_keywords set Title=?,Url=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);            
            ps.setString(1,title);
            ps.setString(2,url);            
            ps.setInt(3,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod Keywords error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }    
    public boolean delKeywords(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_keywords where id="+id);
    }    
    /** get all keywords **/
    public Collection getKeywords(){
        String sql="select id,Title,Url from t_keywords order by id asc";
        return getData(sql,"id,Title,Url");
    }
    public Collection getKeywordsList_Limit(int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title,Url from t_keywords");            
            return getDataList_mysqlLimit(sql.toString(),"id,Title,Url",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title,Url FROM t_keywords WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_keywords");            
            sql.append(" ORDER BY id DESC) AS t))");            
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,Title,Url");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title,Url from t_keywords");            
            return getDataList_Limit_Normal(sql.toString(),"id,Title,Url",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField getKeywords(int id){
        return getFirstData("select id,Title,Url from t_keywords where id="+id,"id,Title,Url");
    }
    public int getTotalCount(int categoryid){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_keywords");        
        return(this.getDataCount(sql.toString()));
    }
    public void batDel(String[] s){
        this.bat("delete from t_keywords where id=?",s);
    }
}
