/*
 * LabelDaoImplJDBC.java
 *
 * Created on 2006923, 9:29
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package tot.dao.jdbc;

import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.LabelUtil;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author totcms
 */
public class LabelDaoImplJDBC extends AbstractDao {

    private static Log log = LogFactory.getLog(LabelDaoImplJDBC.class);

    /** Creates a new instance of LabelDaoImplJDBC */
    public LabelDaoImplJDBC() {
    }

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_label order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField) iter.next();
        }
        if (df != null) {
            returnValue = Integer.parseInt(df.getFieldValue("id")) + 1;
        } else {
            returnValue = 1;
        }
        return returnValue;
    }

    public DataField getLabel(int id) {
        String fieldArr = "id,CategoryId,Title,Demons,Content,ModiTime";
        return getFirstData("select " + fieldArr + " from t_label where id=" + id, fieldArr);
    }

    /**
     * get label count by category id,if 0 then return all
     */
    public int getTotalCount(int categoryid) {
        String sql = "select count(*) from t_label";
        if (categoryid > 0) {
            sql += " where CategoryId=" + categoryid;
        }
        return (getDataCount(sql));
    }

    public boolean addLabel(int categoryid, String title, String demons, String content, Timestamp moditime) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_label(CategoryId,Title,Demons,Content,ModiTime) values(?,?,?,?,?)";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setInt(1, categoryid);
            ps.setString(2, title);
            ps.setString(3, demons);
            if (DBUtils.getDatabaseType() == DBUtils.DATABASE_ORACLE) {
                ps.setCharacterStream(4, new StringReader(content), content.length());
            } else {
                ps.setString(4, content);
            }
            ps.setTimestamp(5, moditime);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        } catch (SQLException e) {
            log.error("add Label error", e);
        } finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod label
     */

    public boolean modLabel(int id, int categoryid, String title, String dmons, String content, Timestamp moditime) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_label set CategoryId=?,Title=?,Demons=?,Content=?,ModiTime=? where id=?";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setInt(1, categoryid);
            ps.setString(2, title);
            ps.setString(3, dmons);
            if (DBUtils.getDatabaseType() == DBUtils.DATABASE_ORACLE) {
                ps.setCharacterStream(4, new StringReader(content), content.length());
            } else {
                ps.setString(4, content);
            }
            ps.setTimestamp(5, moditime);
            ps.setInt(6, id);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        } catch (SQLException e) {
            log.error("mod Label error", e);
        } finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    public boolean delLabel(int id) throws ObjectNotFoundException, DatabaseException {
        return exe("delete from t_label where id=" + id);
    }

    public String getContent(int id) {
        DataField df = getFirstData("select Content from t_label where id=" + id, "Content");
        String returnValue = null;
        if (df != null) {
            returnValue = df.getFieldValue("Content");
        }
        return returnValue;
    }

    public Collection getLabelByCategory(int categoryid) {
        String fieldStr = "id,Title,Content";
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(fieldStr);
        sql.append(" from t_label");
        if (categoryid > 0) {
            sql.append(" where CategoryId=0 or CategoryId=" + categoryid);
        }
        return getData(sql.toString(), fieldStr);
    }

    public Collection getLabelList_Limit(int categoryid, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_label");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" order by id desc");
            return getDataList_mysqlLimit(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id, Title,Demons,ModiTime FROM t_label WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_label");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(), "id,Title,Demons,ModiTime");
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_label");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            return getDataList_Limit_Normal(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
    }

    public Collection getLabelSearchList_Limit(int categoryid, int sby, String key, int currentpage, int pagesize) {
        String fields = "Title";
        if (sby == 1) {
            fields = "Demons";
        }
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_label where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" order by id desc");
            return getDataList_mysqlLimit(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id, Title,Demons,ModiTime FROM t_label WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_label where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(), "id,Title,Demons,ModiTime");
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_label where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            return getDataList_Limit_Normal(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
    }

    public int getTotalCount(int categoryid, int sby, String key) {
        StringBuffer sql = new StringBuffer(512);
        String fields = "Title";
        if (sby == 1) {
            fields = "Demons";
        }
        sql.append("select count(*) from t_label where 1=1");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        if (key != null) {
            sql.append(" and " + fields + " like '%" + key + "%'");
        }
        return (this.getDataCount(sql.toString()));
    }
}
