/*
 * RoleDaoImplJDBC.java
 *
 * Created on 2006116, 9:50
 *
 * To change this role, choose Tools | Role Manager
 * and open the role in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class RoleDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(RoleDaoImplJDBC.class);
    /** Creates a new instance of RoleDaoImplJDBC */
    public RoleDaoImplJDBC() {
    }
    /** add role */
    public boolean addRole(String rolename,String privilege,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="insert into t_role(RoleName,Privilege,ModiTime) values(?,?,?)";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,rolename);            
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(2, new StringReader(privilege), privilege.length());
            }else{
                ps.setString(2,privilege);
            }
            ps.setTimestamp(3,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("add Role error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod role
     */
    public boolean modRole(int id,String rolename,String privilege,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="update t_role set RoleName=?,Privilege=?,ModiTime=? where id=?";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);            
            ps.setString(1,rolename);       
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(2, new StringReader(privilege), privilege.length());
            }else{
                ps.setString(2,privilege);
            }         
            ps.setTimestamp(3,moditime);
            ps.setInt(4,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("mod role error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delRole(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_role where id="+id);
    }
    public Collection getRole(){
        String sql="select id,RoleName,Privilege,ModiTime from t_role order by id asc";
        return getData(sql,"id,RoleName,Privilege,ModiTime");
    }    
    public Collection getRoleList_Limit(int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            return getDataList_mysqlLimit("select id,RoleName,Privilege,ModiTime from t_role","id,RoleName,Privilege,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            String sql="SELECT TOP "+pagesize+" id,RoleName,Privilege,ModiTime FROM t_role WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_role ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return getData(sql,"id,RoleName,Privilege,ModiTime");
        } else{
            return getDataList_Limit_Normal("select id,RoleName,Privilege,ModiTime from t_role","id,RoleName,Privilege,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }
    public String getPrivilege(int id){
        DataField df=getFirstData("select Privilege from t_role where id="+id,"Privilege");
        String returnValue=null;
        if(df!=null){
            returnValue=df.getFieldValue("Privilege");
        }        
        return returnValue;
    }
    public DataField getRole(int id){
        return getFirstData("select id,RoleName,Privilege,ModiTime from t_role where id="+id,"id,RoleName,Privilege,ModiTime");
    }
    public int getTotalCount(){
        return(this.getDataCount("select count(*) from t_role"));
    }
    public String getSelect(int roleid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;        
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,RoleName from t_role order by id asc");            
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if(roleid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }            
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);            
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
}
