/*
 * SecondhandDaoImplJDBC.java
 *
 * Created on 2007628, 10:38
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class SecondhandDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(SecondhandDaoImplJDBC.class);
    /** Creates a new instance of SecondhandDaoImplJDBC */
    public SecondhandDaoImplJDBC() {
    }
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_secondhand order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
            Iterator iter = lists.iterator();
            if (iter.hasNext()) {
                df= (DataField)iter.next();                
            }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;
    }
    /** add addSecondHand */
    public boolean addSecondHand(String UserName,int CityId,int AreaId,String InfoType,int Industryid,String Title,String Content,
            String Price,String ContactMan,String ContactType,String Address,String ExpireTime,String UserIp,int SortNum,Timestamp addtime,int ischeck){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_secondhand(UserName,CityId,AreaId,InfoType,IndustryId,Title,Content,Price,ContactMan,ContactType," +
                "Address,ExpireTime,UserIp,SortNum,ModiTime,IsCheck) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,UserName);
            ps.setInt(2,CityId);
            ps.setInt(3,AreaId);            
            ps.setString(4,InfoType);
            ps.setInt(5,Industryid);
            ps.setString(6,Title);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(7, new StringReader(Content), Content.length());
            }else{
                ps.setString(7,Content);
            }
            ps.setString(8,Price);
            ps.setString(9,ContactMan);
            ps.setString(10,ContactType);
            ps.setString(11,Address);    
            ps.setString(12,ExpireTime);
            ps.setString(13,UserIp);
            ps.setInt(14,SortNum);
            ps.setTimestamp(15,addtime);
            ps.setInt(16,ischeck);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add secondhand error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /** add addSecondHand */
    public boolean modSecondHand(int id,String UserName,int CityId,int AreaId,String InfoType,int Industryid,String Title,String Content,
            String Price,String ContactMan,String ContactType,String Address,String ExpireTime,String UserIp,int SortNum,Timestamp addtime,int ischeck,int hits){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_secondhand set UserName=?,CityId=?,AreaId=?,InfoType=?,IndustryId=?,Title=?,Content=?,Price=?,ContactMan=?," +
                "ContactType=?,Address=?,ExpireTime=?,UserIp=?,SortNum=?,ModiTime=?,IsCheck=?,Hits=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,UserName);
            ps.setInt(2,CityId);
            ps.setInt(3,AreaId);            
            ps.setString(4,InfoType);
            ps.setInt(5,Industryid);
            ps.setString(6,Title);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(7, new StringReader(Content), Content.length());
            }else{
                ps.setString(7,Content);
            }
            ps.setString(8,Price);
            ps.setString(9,ContactMan);
            ps.setString(10,ContactType);
            ps.setString(11,Address);    
            ps.setString(12,ExpireTime);
            ps.setString(13,UserIp);
            ps.setInt(14,SortNum);
            ps.setTimestamp(15,addtime);
            ps.setInt(16,ischeck);
            ps.setInt(17,hits);
            ps.setInt(18,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod secondhand error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /* delete secondhand by id */
    public boolean delSecondHand(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_secondhand where id="+id);
    }
    /* update hits by id */
    public void updateHits(int id)throws ObjectNotFoundException,DatabaseException{
        exe("update t_secondhand set Hits=Hits+1 where id="+id);
    }
    /* get house by id */
    public DataField getSecondHand(int id){
        String fields="UserName,CityId,AreaId,InfoType,IndustryId,Title,Content,Price,ContactMan,ContactType," +
                "Address,ExpireTime,UserIp,SortNum,ModiTime,IsCheck,Hits";
        return getFirstData("select "+fields+" from t_secondhand where id="+id,fields);
    }
    /* get house show */
    public DataField getShowSecondHand(int id){
        StringBuffer sql=new StringBuffer("");
        sql.append("select t_industry.Title AS IndustryId,t_city.Title AS CityId,t_area.Title as AreaId,t_secondhand.UserName,t_secondhand.InfoType,t_secondhand.Title as stitle,t_secondhand.Content,t_secondhand.Price,t_secondhand.ContactMan,t_secondhand.ContactType,t_secondhand.Address,t_secondhand.ExpireTime,t_secondhand.ModiTime,t_secondhand.UserIp,t_secondhand.Hits from t_secondhand,t_industry,t_city,t_area");
        sql.append(" where t_secondhand.IndustryId=t_industry.id and t_secondhand.CityId=t_city.id and t_secondhand.AreaId=t_area.id and t_secondhand.IsCheck=1 and t_secondhand.id="+id);
        String fields="IndustryId,CityId,AreaId,UserName,InfoType,Title,Content,Price,ContactMan,ContactType," +
                "Address,ExpireTime,ModiTime,UserIp,Hits";
        return getFirstData(sql.toString(),fields);
    }
    public int getTotalCount(int ischeck,int industryid,int cityid,int areaid,String username,String infotype){
        String sql="select count(*) from t_secondhand where IsCheck="+ischeck;
        if(industryid!=0){
            sql+=" and IndustryId="+industryid;
        }
        if(cityid!=0){
            sql+=" and CityId="+cityid;
        }
        if(areaid!=0){
            sql+=" and AreaId="+areaid;
        }
        if(username!=null){
            sql+=" and UserName='"+username+"'";
        }
        if(infotype!=null){
            sql+=" and InfoType='"+infotype+"'";
        }        
        return(this.getDataCount(sql));
    }
    public Collection getSecondHandList(int ischeck,int industryid,int cityid,int areaid,String username,String infotype,int by,int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String byField="t_secondhand.id desc";
        if(by==1){
            byField="t_secondhand.Hits desc";
        }else if(by==2){
            byField="t_secondhand.SortNum asc";
        }else{
            byField="t_secondhand.id desc";
        }
        String fieldArr="id,Title,InfoType,Price,ModiTime,Hits,IndustryId,CityId";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(" t_secondhand.id AS hid,t_secondhand.Title as stitle,t_secondhand.InfoType,t_secondhand.Price,t_secondhand.ModiTime,t_secondhand.Hits,t_industry.Title AS IndustryId,t_city.Title AS CityId from t_secondhand,t_industry,t_city");
            sql.append(" WHERE t_secondhand.id not in (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_secondhand where t_secondhand.IndustryId=t_industry.id and t_secondhand.CityId=t_city.id and t_secondhand.IsCheck=").append(ischeck);
            //ж
            if(industryid!=0){
                sql.append(" and t_secondhand.IndustryId=").append(industryid);
            }
            if(cityid!=0){
                sql.append(" and t_secondhand.CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and t_secondhand.AreaId=").append(areaid);
            }
            if(username!=null){
                sql.append(" and t_secondhand.UserName='").append(username).append("'");
            }
            if(infotype!=null){
                sql.append(" and t_secondhand.InfoType='").append(infotype).append("'");
            }            
            sql.append(" ORDER BY "+byField+")");
            sql.append(" and t_secondhand.IndustryId=t_industry.id and t_secondhand.CityId=t_city.id and t_secondhand.IsCheck=").append(ischeck);
            //ж
            if(industryid!=0){
                sql.append(" and t_secondhand.IndustryId=").append(industryid);
            }
            if(cityid!=0){
                sql.append(" and t_secondhand.CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and t_secondhand.AreaId=").append(areaid);
            }
            if(username!=null){
                sql.append(" and t_secondhand.UserName='").append(username).append("'");
            }
            if(infotype!=null){
                sql.append(" and t_secondhand.InfoType='").append(infotype).append("'");
            }        
            sql.append(" ORDER BY "+byField);            
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append(" select t_secondhand.id AS hid,t_secondhand.Title as stitle,t_secondhand.InfoType,t_secondhand.Price,t_secondhand.ModiTime,t_secondhand.Hits,t_industry.Title AS IndustryId,t_city.Title AS CityId from t_secondhand,t_industry,t_city");
            sql.append(" where t_secondhand.IndustryId=t_industry.id and t_secondhand.CityId=t_city.id and t_secondhand.IsCheck=").append(ischeck);
            //ж
            if(industryid!=0){
                sql.append(" and t_secondhand.IndustryId=").append(industryid);
            }
            if(cityid!=0){
                sql.append(" and t_secondhand.CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and t_secondhand.AreaId=").append(areaid);
            }
            if(username!=null){
                sql.append(" and t_secondhand.UserName='").append(username).append("'");
            }
            if(infotype!=null){
                sql.append(" and t_secondhand.InfoType='").append(infotype).append("'");
            }        
            sql.append(" ORDER BY "+byField+" limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append(" select t_secondhand.id AS hid,t_secondhand.Title as stitle,t_secondhand.InfoType,t_secondhand.Price,t_secondhand.ModiTime,t_secondhand.Hits,t_industry.Title AS IndustryId,t_city.Title AS CityId from t_secondhand,t_industry,t_city");
            sql.append(" where t_secondhand.IndustryId=t_industry.id and t_secondhand.CityId=t_city.id and t_secondhand.IsCheck=").append(ischeck);
            //ж
            if(industryid!=0){
                sql.append(" and t_secondhand.IndustryId=").append(industryid);
            }
            if(cityid!=0){
                sql.append(" and t_secondhand.CityId=").append(cityid);
            }
            if(areaid!=0){
                sql.append(" and t_secondhand.AreaId=").append(areaid);
            }
            if(username!=null){
                sql.append(" and t_secondhand.UserName='").append(username).append("'");
            }
            if(infotype!=null){
                sql.append(" and t_secondhand.InfoType='").append(infotype).append("'");
            }        
            sql.append(" ORDER BY "+byField);
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }        
    }
    public boolean delSecondHand_Member(int id,String userid){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="delete from t_secondhand where id=? and UserName=?";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,id);
            ps.setString(2,userid);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("delete info error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean checkMemberOwn(int id,String userid){
        boolean returnValue=false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement("select * from t_secondhand where id=? and UserName=?");
            ps.setInt(1,id);
            ps.setString(2,userid);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=true;
            }else{
                returnValue=false;
            }
        }
        catch(SQLException e){
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public void batDel(String[] s){
        this.bat("delete from t_secondhand where id=?",s);
    }
    public void batCheck(String[] s){
        this.bat("update t_secondhand set IsCheck=1 where id=?",s);
    }
    public void batUnCheck(String[] s){
        this.bat("update t_secondhand set IsCheck=0 where id=?",s);
    }
}
