/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class SlideDaoImplJDBC  extends AbstractDao{
    private static Log log = LogFactory.getLog(SlideDaoImplJDBC.class);
    /** Creates a new instance of SlideDaoImplJDBC */
    public SlideDaoImplJDBC() {
    }
    /** add floor level */
    public boolean addSlide(String title,int categoryid,int itemnum,int width,int height){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_slide(Title,CategoryId,ItemNum,Width,Height) values(?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setInt(2,categoryid);
            ps.setInt(3,itemnum);
            ps.setInt(4,width);
            ps.setInt(5,height);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add slide error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod floor level
     */
    public boolean modSlide(int id,String title,int categoryid,int itemnum,int width,int height){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_slide set Title=?,CategoryId=?,ItemNum=?,Width=?,Height=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setInt(2,categoryid);
            ps.setInt(3,itemnum);
            ps.setInt(4,width);
            ps.setInt(5,height);
            ps.setInt(6,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod slide error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /* delete floor level by id */
    public boolean delSlide(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_slide where id="+id);
    }
    /* get area by id */
    public DataField getSlide(int id){
        return getFirstData("select Title,CategoryId,ItemNum,Width,Height from t_slide where id="+id,"Title,CategoryId,ItemNum,Width,Height");
    }
    /* get area count */
    public int getTotalCount(int categoryid){
        String sql="select count(*) from t_slide";
        if(categoryid!=0){
            sql+=" where CategoryId="+categoryid;
        }
        return(this.getDataCount(sql));
    }
     /* get list */
    public Collection getSlideList(int categoryid,int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title,CategoryId,ItemNum,Width,Height";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_slide WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_slide");
            if(categoryid!=0){
                sql.append(" where CategoryId=").append(categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if(categoryid!=0){
                sql.append(" and CategoryId=").append(categoryid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_slide");
            if(categoryid!=0){
                sql.append(" where CategoryId=").append(categoryid);
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_slide");
            if(categoryid!=0){
                sql.append(" where CategoryId=").append(categoryid);
            }
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }
    }
    public void batDel(String[] s){
        this.bat("delete from t_slide where id=?",s);
    }
}
