/*
 * SourDaoImplJDBC.java
 *
 * Created on 200741, 9:14
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.LabelUtil;
import tot.util.StringUtils;
import tot.global.Sysconfig;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class SourceDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(SourceDaoImplJDBC.class);
    /** Creates a new instance of SourDaoImplJDBC */
    public SourceDaoImplJDBC() {
    }
    public boolean addSource(String title,String stype){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_source(Title,Stype) values(?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,stype);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Source error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean modSource(int id,String title,String stype){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_source set Title=?,Stype=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,stype);    
            ps.setInt(3,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("modify Source error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delSource(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_source where id="+id);
    } 
    public DataField getSource(int id){
        String fieldArr="id,Title";
        return getFirstData("select "+fieldArr+" from t_source where id="+id,fieldArr); 
    }
    /*
     * get sources
     */
    public Collection getSources(String stype){
        String fieldArr="id,Title";
        String sql="select "+fieldArr+" from t_source where Stype='"+stype+"'";
        return getData(sql,fieldArr);
    }
    public String getSelect(String stype,int currentid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_source where Stype='"+stype+"' order by id asc");
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getString(2));
                sb.append("\"");
                if(currentid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    public String getSelectInt(String stype,int currentid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_source where Stype='"+stype+"' order by id asc");
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getString(1));
                sb.append("\"");
                if(currentid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    public int getTotalCount(String stype){
        String sql="select count(*) from t_source";
        if(stype!=null)
            sql+=" where Stype='"+stype+"'";
        return(getDataCount(sql));
    }
    public Collection getSourceList_Limit(String stype,int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer();
            sql.append("select id,Title from t_source");
            if(stype!=null){
                sql.append(" where Stype='");
                sql.append(stype).append("'");
            }
            return getDataList_mysqlLimit(sql.toString(),"id,Title",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_source WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_source");
            if(stype!=null){
                sql.append(" where Stype='");
                sql.append(stype).append("'");
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if(stype!=null){
                sql.append(" and Stype='");
                sql.append(stype).append("'");
            }
            sql.append(" ORDER BY id DESC");     
            //System.out.print(sql.toString());
            return getData(sql.toString(),"id,Title");
        } else{
            StringBuffer sql=new StringBuffer();
            sql.append("select id,Title from t_source");
            if(stype!=null){
                sql.append(" where Stype='");
                sql.append(stype).append("'");
            }
            return getDataList_Limit_Normal(sql.toString(),"id,Title",pagesize,(currentpage-1)*pagesize);
        }
    }
    public void batDel(String[] s){
        this.bat("delete from t_source where id=?",s);
    }
}
