/*
 * SpecialDaoImplJDBC.java
 *
 * Created on 2006921, 9:33
 *
 * To change this Special, choose Tools | Special Manager
 * and open the Special in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.global.Sysconfig;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class SpecialDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(SpecialDaoImplJDBC.class);
    /** Creates a new instance of SpecialDaoImplJDBC */
    public SpecialDaoImplJDBC() {
    }
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_special order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
            Iterator iter = lists.iterator();
            if (iter.hasNext()) {
                df= (DataField)iter.next();                
            }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;        
    }
    /** add Special */
    public boolean addSpecial(String title,String template,String savepath,String content,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_special(Title,Template,SavePath,Content,ModiTime) values(?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,template);
            ps.setString(3,savepath);
            ps.setString(4,content);
            ps.setTimestamp(5,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Special error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Special
     */
    public boolean modSpecial(int id,String title,String template,String savepath,String content,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_special set Title=?,Template=?,SavePath=?,Content=?,ModiTime=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,template);
            ps.setString(3,savepath);
            ps.setString(4,content);
            ps.setTimestamp(5,moditime);
            ps.setInt(6,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod Special error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delSpecial(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_special where id="+id);
    }
    public Collection getSpecial(){
        String sql="select id,Title,Template,SavePath,ModiTime from t_special order by id asc";
        return getData(sql,"id,Title,Template,SavePath,ModiTime");
    }
    public Collection getSpecialList_Limit(int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            return getDataList_mysqlLimit("select id,Title,ModiTime from t_special","id,Title,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            String sql="SELECT TOP "+pagesize+" id, title, moditime FROM t_special WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_special ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return getData(sql,"id,Title,ModiTime");
        } else{
            return getDataList_Limit_Normal("select id,Title,ModiTime from t_special","id,Title,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField getSpecial(int id){
        return getFirstData("select id,Title,Template,SavePath,Content,ModiTime from t_special where id="+id,"id,Title,Template,SavePath,Content,ModiTime");
    }
    public int getTotalCount(){
        return(this.getDataCount("select count(*) from t_special"));
    }
    public String getSelect(int currentid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_special order by id asc");
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if(currentid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    /*
     * get specials
     */
    public String getSpecials(String ulStyle,int getNum,int charMax,String titlePre){
        //int parentId=getParentId(categoryId);
        String contextPath=Sysconfig.getSiteUrl()+Sysconfig.getContextPath();
        StringBuffer sb=new StringBuffer(512);
        ArrayList list=(ArrayList)getSpecial();
        sb.append("<ul class=\"");
        sb.append(ulStyle);
        sb.append("\">");
        int i=0;
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            sb.append("<li>");
            sb.append(titlePre);
            sb.append("<a href=\"");            
            sb.append(contextPath);
            sb.append(df.getFieldValue("SavePath"));
            sb.append("/index_1.htm");
            sb.append("\">");
            sb.append(StringUtils.getTopic(df.getFieldValue("Title"),charMax));
            sb.append("</a></li>\n");
            if(getNum>0 && getNum>list.size())
                break;
        }
        sb.append("</ul>");
        return sb.toString();
    }
}
