/*
 * StudentDaoImplJDBC.java
 *
 * Created on 2008310, 2:44
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class StudentDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(StudentDaoImplJDBC.class);
    /** Creates a new instance of StudentDaoImplJDBC */
    public StudentDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_student order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df= (DataField)iter.next();
        }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;
    }
    /** add student */
    public boolean add(String title,String userid,String province,String city,String area,String sexlimit,String salary,String travelsubsidize,
            String qualitacations,String studentstatus,String tutortype,String tutordate,String needpeople,String travelline,int gradeid,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_student(UserId,Province,City,Area,SexLimit,Salary,TravelSubsidize,Qualitacations,StudentStatus,TutorType,TutorDate,NeedPeople,TravelLine,PubDate,Title,GradeId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,userid);
            ps.setString(2,province);
            ps.setString(3,city);
            ps.setString(4,area);
            ps.setString(5,sexlimit);
            ps.setString(6,salary);
            ps.setString(7,travelsubsidize);
            ps.setString(8,qualitacations);
            ps.setString(9,studentstatus);
            ps.setString(10,tutortype);
            ps.setString(11,tutordate);
            ps.setString(12,needpeople);
            ps.setString(13,travelline);
            ps.setTimestamp(14,moditime);
            ps.setString(15,title);
            ps.setInt(16,gradeid);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add edu download error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /** add student */
    public boolean mod(int id,String title,String userid,String province,String city,String area,String sexlimit,String salary,String travelsubsidize,
            String qualitacations,String studentstatus,String tutortype,String tutordate,String needpeople,String travelline,Timestamp moditime,int gradeid){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_student set UserId=?,Province=?,City=?,Area=?,SexLimit=?,Salary=?,TravelSubsidize=?,Qualitacations=?,StudentStatus=?,TutorType=?,TutorDate=?,NeedPeople=?,TravelLine=?,PubDate=?,Title=?,GradeId=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,userid);
            ps.setString(2,province);
            ps.setString(3,city);
            ps.setString(4,area);
            ps.setString(5,sexlimit);
            ps.setString(6,salary);
            ps.setString(7,travelsubsidize);
            ps.setString(8,qualitacations);
            ps.setString(9,studentstatus);
            ps.setString(10,tutortype);
            ps.setString(11,tutordate);
            ps.setString(12,needpeople);
            ps.setString(13,travelline);
            ps.setTimestamp(14,moditime);
            ps.setString(15,title);
            ps.setInt(16,gradeid);
            ps.setInt(17,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add edu download error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean del(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_student where id="+id);
    }
    public void upHits(int id) throws ObjectNotFoundException,DatabaseException{
        exe("update t_student set Hits=Hits+1 where id="+id);
    }
    public void upCredit(int id,int val) throws ObjectNotFoundException,DatabaseException{
        exe("update t_student set Credit="+val+" where id="+id);
    }
    public Collection getList_Limit(int gradeid,String province,String city,int ischecked,int isrecommend,String key,int orderby,int currentpage,int pagesize){
        String ord="id";
        if(orderby==1) ord="Hits";
        if(orderby==2) ord="Credit";
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT id,UserId,Title,Area,PubDate,StudentStatus,Qualitacations,IsChecked,Credit from t_student where 1=1");
            if(gradeid>0) sql.append(" and GradeId="+gradeid);
            if(province!=null) sql.append(" and Province='"+province+"'");
            if(city!=null) sql.append(" and City='"+city+"'");
            if(ischecked>=0) sql.append(" and IsChecked="+ischecked);
            if(isrecommend>=0) sql.append(" and IsRecommend="+isrecommend);
            if(key!=null) sql.append(" and NeedPeople like '%"+key+"%'");
            sql.append(" order by t_student."+ord+" desc");
            //System.out.println(sql.toString());
            return getDataList_mysqlLimit(sql.toString(),"id,UserId,Title,Area,PubDate,StudentStatus,Qualitacations,IsChecked,Credit",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_student WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_student");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,Title");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title from t_student");
            return getDataList_Limit_Normal(sql.toString(),"id,Title",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField get(int id){
        String fields="UserId,Province,City,Area,SexLimit,Salary,TravelSubsidize,Qualitacations,StudentStatus,TutorType,TutorDate,NeedPeople,TravelLine,PubDate,Title,Hits,IsChecked,IsRecommend,GradeId,Credit";
        return getFirstData("select "+fields+" from t_student where id="+id,fields);
    }
    public int getTotalCount(int gradeid,String province,String city,int ischecked,int isrecommend,String key){
        StringBuffer sql=new StringBuffer(512);
        sql.append("SELECT  count(*) FROM t_student where 1=1 ");
        if(gradeid>0) sql.append(" and GradeId="+gradeid);
        if(province!=null) sql.append(" and Province='"+province+"'");
        if(city!=null) sql.append(" and City='"+city+"'");
        if(ischecked>=0) sql.append(" and IsChecked="+ischecked);
        if(isrecommend>=0) sql.append(" and IsRecommend="+isrecommend);
        if(key!=null) sql.append(" and NeedPeople like '%"+key+"%'");
        return(this.getDataCount(sql.toString()));
    }
    public void batDel(String[] s){
        this.bat("delete from t_student where id=?",s);
    }
    public void batRecommend(String[] s,int val){
        this.bat("update t_student set IsRecommend="+val+" where id=?",s);
    }
    public void batCheck(String[] s,int val){
        this.bat("update t_student set IsChecked="+val+" where id=?",s);
    }
}
