/*
 * TemplateDaoImplJDBC.java
 *
 * Created on 2006920, 8:56
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class TemplateDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(TemplateDaoImplJDBC.class);
    /** Creates a new instance of TemplateDaoImplJDBC */
    public TemplateDaoImplJDBC() {
    }
    /** add template */
    public boolean addTemplate(String title,String content,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="insert into t_template(Title,Content,ModiTime) values(?,?,?)";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(2, new StringReader(content), content.length());
            }else{
                ps.setString(2,content);
            }           
            ps.setTimestamp(3,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("add Template error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod template
     */
    public boolean modTemplate(int id,String title,String content,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="update t_template set Title=?,Content=?,ModiTime=? where id=?";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);            
            ps.setString(1,title);       
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(2, new StringReader(content), content.length());
            }else{
                ps.setString(2,content);
            }       
            ps.setTimestamp(3,moditime);
            ps.setInt(4,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("mod template error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delTemplate(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_template where id="+id);
    }
    public Collection getTemplate(){
        String sql="select id,Title,ModiTime from t_template order by id asc";
        return getData(sql,"id,Title,ModiTime");
    }    
    public Collection getTemplateList_Limit(int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            return getDataList_mysqlLimit("select id,Title,ModiTime from t_template","id,Title,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            String sql="SELECT TOP "+pagesize+" id, title, moditime FROM t_template WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_template ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return getData(sql,"id,Title,ModiTime");
        } else{
            return getDataList_Limit_Normal("select id,Title,ModiTime from t_template","id,Title,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }
    public String getContent(int id){
        DataField df=getFirstData("select Content from t_template where id="+id,"Content");
        String returnValue=null;
        if(df!=null){
            returnValue=df.getFieldValue("Content");
        }        
        return returnValue;
    }
    public DataField getTemplate(int id){
        return getFirstData("select id,Title,Content,ModiTime from t_template where id="+id,"id,Title,Content,ModiTime");
    }
    public int getTotalCount(){
        return(this.getDataCount("select count(*) from t_template"));
    }
    public String getSelect(int currentid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;        
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_template order by id asc");            
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if(currentid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }            
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);            
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
}
