/*
 * TotgbDaoImplJDBC.java
 *
 * Created on 2007919, 9:31
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms.com
 */
public class TotgbDaoImplJDBC  extends AbstractDao{
    private static Log log = LogFactory.getLog(TotgbDaoImplJDBC.class);
    /** Creates a new instance of TotgbDaoImplJDBC */
    public TotgbDaoImplJDBC() {
    }
    public boolean add(String username,String title,String content,String emot,
            String homepage,String email,String im,String ip,
            Timestamp postDate,int hidden,int ischeck){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_post(f_user,f_title,f_content,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_hidden,f_ischeck,f_replytime) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, username);
            ps.setString(2, title);
            ps.setString(3, content);
            ps.setString(4, emot);
            ps.setString(5, homepage);
            ps.setString(6, email);
            ps.setString(7, im);
            ps.setString(8, ip);
            ps.setTimestamp(9, postDate);
            ps.setInt(10,hidden);
            ps.setInt(11,ischeck);
            ps.setTimestamp(12, postDate);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.info("catch exception when call add method: \n"+sql);
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean reply(String content,int postid,Timestamp replydate){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement("update t_post set f_reply=?,f_replytime=? where id=?");
            ps.setString(1,content);
            ps.setTimestamp(2, replydate);
            ps.setInt(3,postid);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public Collection getPostList(int ischeck,int pageSize,int currentPage){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,f_user,f_title,f_content,f_reply,f_replytime,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_hidden";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pageSize);
            sql.append(fieldArr);
            sql.append(" from t_post where id <=(select min(id) from (select top ");
            sql.append((currentPage-1)*pageSize+1);
            sql.append(" id from t_post where f_ischeck=");
            sql.append(ischeck);
            sql.append(" order by id desc) as t)");
            sql.append(" and f_ischeck=");
            sql.append(ischeck);
            sql.append(" order by id desc");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_post");
            sql.append(" where f_ischeck=");
            sql.append(ischeck);
            sql.append(" order by id desc limit ");
            sql.append((currentPage-1)*pageSize);
            sql.append(",");
            sql.append(pageSize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_post");
            sql.append(" where f_ischeck=");
            sql.append(ischeck);
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pageSize,(currentPage-1)*pageSize);
        }
    }
    public int getTotalCount(int ischeck){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_post");
        sql.append(" where f_ischeck=");
        sql.append(ischeck);
        return(this.getDataCount(sql.toString()));
    }
    public DataField get(int id){
        String fields="f_user,f_title,f_content,f_reply,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_hidden,f_ischeck,f_replytime";
        return getFirstData("select "+fields+" from t_post where id="+id,fields);
    }
    public boolean mod(int id,String content){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_post set f_content=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(1, new StringReader(content), content.length());
            }else{
                ps.setString(1,content);
            }            
            ps.setInt(2,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod guestbook error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delPost(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_post where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_post where id=?",s);
    }
    public void batCheck(String[] s){
        this.bat("update t_post set f_ischeck=1 where id=?",s);
    }    
}
