/*
 * TransactionDaoImplJDBC.java
 *
 * Created on 2008224, 3:54
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.global.Sysconfig;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
/**
 *
 * @author Administrator
 */
public class TransactionDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(TransactionDaoImplJDBC.class);
    /** Creates a new instance of TransactionDaoImplJDBC */
    public TransactionDaoImplJDBC() {
    }
    /** add transation history
     * @param transtype ,0=ֵ߳,1=˹¼,2=Ա֧
     * @param money ֵֵλԪ
     * @param fromuser 
     * @param touser ȥ
     * @param moditime 
     * @param status ״̬
     * @param fname Ʒ
     * @param furl Ʒַ
     * @param fdesc ע
     * @param transid ˮ
     * @return boolean ֵ,bool(/)
     */
    public boolean addTransaction(int transtype,Float money,String fromuser,String touser,Timestamp moditime,int status,String fname,String furl,String fdesc,String transid){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_transaction(TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,Fdesc,TransId) values(?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            conn.setAutoCommit(false);
            ps=conn.prepareStatement(sql);
            ps.setInt(1,transtype);
            ps.setFloat(2,money);
            ps.setString(3,fromuser);
            ps.setString(4,touser);
            ps.setTimestamp(5,moditime);
            ps.setInt(6,status);
            ps.setString(7,fname);
            ps.setString(8,furl);
            ps.setString(9,fdesc);
            ps.setString(10,transid);
            if(ps.executeUpdate()!=1) returnValue=false;
            conn.commit();
        } catch(SQLException e){
            if(conn!=null){
                try {
                    conn.rollback();
                } catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            log.error("add Transaction error",e);
        } finally{
            if(conn!=null){
                try {
                    conn.rollback();
                } catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delTransaction(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_transaction where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_transaction where id=?",s);
    }
    public Collection getTransactionList_Limit(int currentpage,int pagesize,String uid){
        String fields="id,TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,Fdesc,TransId";
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            return getDataList_mysqlLimit("select "+fields+" from t_transaction where ToUser='"+uid+"' or FromUser='"+uid+"' order by id desc",fields,pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            String sql="SELECT TOP "+pagesize+" "+fields+" FROM t_transaction WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_transaction where ToUser='"+uid+"' or FromUser='"+uid+"' ORDER BY id DESC) AS t)) and (ToUser='"+uid+"' or FromUser='"+uid+"')  ORDER BY id DESC";
            return getData(sql,fields);
        } else{
            return getDataList_Limit_Normal("select "+fields+" from t_transaction",fields,pagesize,(currentpage-1)*pagesize);
        }
    }
    public Collection getTransactionList_Limit(int tanstype,int status,String userid,String dateStart,String dateEnd,int currentpage,int pagesize){
        String fields="id,TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,TransId";
        StringBuffer sql=new StringBuffer(512);
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select "+fields+" from t_transaction where 1=1");
            if(tanstype>=0){
                sql.append(" and TransType="+tanstype);
            }
            if(status>=0){
                sql.append(" and Fstatus="+status);
            }
            if(userid!=null){
                sql.append(" and (ToUser='"+userid+"' or FromUser='"+userid+"')");
            }
            if(dateStart!=null && dateEnd!=null){
                sql.append(" and to_days(TransDate)>=to_days('").append(dateStart).append("') and to_days(TransDate)<=to_days('").append(dateEnd).append("')");
            }
            //System.out.print(sql.toString());
            sql.append(" order by id desc");
            return getDataList_mysqlLimit(sql.toString(),fields,pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            //String sql="SELECT TOP "+pagesize+" "+fields+" FROM t_transaction WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_transaction ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return getData(sql.toString(),fields);
        } else{
            return getDataList_Limit_Normal("select "+fields+" from t_transaction",fields,pagesize,(currentpage-1)*pagesize);
        }
    }
    public int getTotalCount(int tanstype,int status,String userid,String dateStart,String dateEnd){
        int totalNum=0;
        //ݿ
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_transaction where 1=1");
        if(tanstype>=0){
                sql.append(" and TransType="+tanstype);
            }
        if(status>=0){
            sql.append(" and Fstatus="+status);
        }
        if(userid!=null){
            sql.append(" and (ToUser='"+userid+"' or FromUser='"+userid+"')");
        }
        if(dateStart!=null && dateEnd!=null){
                sql.append(" and to_days(TransDate)>=to_days('").append(dateStart).append("') and to_days(TransDate)<=to_days('").append(dateEnd).append("')");
        }
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql.toString());            
            rs=ps.executeQuery();
            if(rs.next()){
                totalNum=rs.getInt(1);
            }
        }catch(SQLException e){
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return totalNum;
    }
    public DataField getTransaction(int id){
        String fields="TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,Fdesc,TransId";
        return getFirstData("select "+fields+" from t_transaction where id="+id,fields);
    }
}
