/*
 * EduVersionDaoImplJDBC.java
 *
 * Created on 200835, 2:43
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.dao.DaoFactory;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import tot.global.Sysconfig;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class VideoDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(VideoDaoImplJDBC.class);
    /**
     * Creates a new instance of EduVersionDaoImplJDBC
     */
    public VideoDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_video order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df= (DataField)iter.next();
        }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;
    }
    /** add Keywords */
    public boolean add(String title,String viewimg,int categoryid,float money,String fdesc,String vurl,Timestamp moditime,int isfree,String author,String videolen,String fcontent,int pubserverid,int ischeck,String userid,int isguestpub){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        int ParentId=DaoFactory.getCategoryDAO().getParentId(categoryid);
        String sql="insert into t_video(Title,ViewImg,CategoryId,NeedMoney,Fdesc,Vurl,ModiTime,IsFree,Author,VideoLen,ParentId,Fcontent,PubServerId,IsCheck,UserId,IsGuestPub) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,viewimg);
            ps.setInt(3,categoryid);
            ps.setFloat(4,money);
            ps.setString(5,fdesc);
            ps.setString(6,vurl);
            ps.setTimestamp(7,moditime);
            ps.setInt(8,isfree);
            ps.setString(9,author);
            ps.setString(10,videolen);
            ps.setInt(11,ParentId);
            ps.setString(12,fcontent);
            ps.setInt(13,pubserverid);
            ps.setInt(14,ischeck);
            ps.setString(15,userid);
            ps.setInt(16,isguestpub);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add video error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Keywords
     */
    public boolean mod(int id,String title,String viewimg,int categoryid,float money,String fdesc,String vurl,Timestamp moditime,int isfree,String author,String videolen,String fcontent,int pubserverid,int ischeck){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        int ParentId=DaoFactory.getCategoryDAO().getParentId(categoryid);
        String sql="update t_video set Title=?,ViewImg=?,CategoryId=?,NeedMoney=?,Fdesc=?,Vurl=?,ModiTime=?,IsFree=?,Author=?,VideoLen=?,Fcontent=?,PubServerId=?,IsCheck=?,ParentId=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,viewimg);
            ps.setInt(3,categoryid);
            ps.setFloat(4,money);
            ps.setString(5,fdesc);
            ps.setString(6,vurl);
            ps.setTimestamp(7,moditime);
            ps.setInt(8,isfree);
            ps.setString(9,author);
            ps.setString(10,videolen);
            ps.setString(11,fcontent);
            ps.setInt(12,pubserverid);
            ps.setInt(13,ischeck);
            ps.setInt(14,ParentId);
            ps.setInt(15,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod video error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean del(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_video where id="+id);
    }
    public void upHits(int id) throws ObjectNotFoundException,DatabaseException{
        exe("update t_video set Hits=Hits+1 where id="+id);
    }

    public Collection getList(int categoryid,int isfree,int isrecommend,int ischeck,String key,int orderby,String userid,int isguestpub,int currentpage,int pagesize){
        String ord="id";
        if(orderby==1) ord="Hits";
        if(orderby==2) ord="JoinNum";
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT t_video.id as eid,t_video.Title as etitle,t_video.Hits,ViewImg,Author,VideoLen,IsRecommend,JoinNum,t_video.ModiTime as emodtime," +
                    "t_category.Title as ctitle FROM t_video,t_category where t_video.IsCheck=1 and t_video.CategoryId=t_category.id ");
            if(categoryid>0) {
                sql.append(" and t_video.CategoryId="+categoryid);
            }            
            if(isfree>=0) sql.append(" and t_video.IsFree="+isfree);
            if(ischeck>=0) sql.append(" and t_video.IsCheck="+ischeck);
            if(isrecommend>0) sql.append(" and t_video.IsRecommend="+isrecommend);
            if(key!=null) sql.append(" and t_video.Title like '%"+key+"%'");
            sql.append(" order by t_video."+ord+" desc");
            //System.out.println(sql.toString());
            return getDataList_mysqlLimit(sql.toString(),"id,Title,Hits,ViewImg,Author,VideoLen,IsRecommend,JoinNum,ModiTime,CategoryTitle",pagesize,(currentpage-1)*pagesize);
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT t_video.id as eid,t_video.Title as etitle,t_video.Hits,ViewImg,Author,VideoLen,IsRecommend,JoinNum,t_video.ModiTime as emodtime," +
                    "t_category.Title as ctitle FROM t_video,t_category where t_video.IsCheck=1 and t_video.CategoryId=t_category.id ");
            if(categoryid>0) {
                sql.append(" and t_video.CategoryId="+categoryid);
            }            
            if(isfree>=0) sql.append(" and t_video.IsFree="+isfree);
            if(isrecommend>0) sql.append(" and t_video.IsRecommend="+isrecommend);
            if(key!=null) sql.append(" and t_video.Title like '%"+key+"%'");
            sql.append(" order by t_video."+ord+" desc");
            return getDataList_Limit_Normal(sql.toString(),"id,Title,Hits,ViewImg,Author,VideoLen,IsRecommend,JoinNum,ModiTime,CategoryTitle",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField get(int id){
        String fields="Title,ViewImg,CategoryId,NeedMoney,Fdesc,Vurl,ModiTime,IsFree,Author,VideoLen,IsRecommend,JoinNum,Hits,ParentId,Fcontent,PubServerId,IsCheck,UserId,IsGuestPub";
        return getFirstData("select "+fields+" from t_video where id="+id,fields);
    }
    
    public int getTotalCount(int categoryid,int isfree,int isrecommend,int ischeck,String key,String userid,int isguestpub){
        StringBuffer sql=new StringBuffer(512);        
        sql.append("SELECT  count(*) FROM t_video,t_category where t_video.CategoryId=t_category.id");
        if(categoryid>0) sql.append(" and t_video.CategoryId="+categoryid);
        if(isfree>=0) sql.append(" and t_video.IsFree="+isfree);
        if(isrecommend>0) sql.append(" and t_video.IsRecommend="+isrecommend);
        if(key!=null) sql.append(" and t_video.Title like '%"+key+"%'");
        if(ischeck>=0) sql.append(" and t_video.IsCheck="+ischeck);
        if(userid!=null) sql.append(" and t_video.UserId like '%"+userid+"%'");
        if(isguestpub>=0) sql.append(" and t_video.IsGuestPub="+isguestpub);
        return(this.getDataCount(sql.toString()));
    }
    public void batDel(String[] s){
        this.bat("delete from t_video where id=?",s);
    }
    public void batRecommend(String[] s,int val){
        this.bat("update t_video set IsRecommend="+val+" where id=?",s);
    }
    public void batCheck(String[] s,int val){
        this.bat("update t_video set IsCheck="+val+" where id=?",s);
    }
    public void remove(String[] s,int categoryid){
        int ParentId=DaoFactory.getCategoryDAO().getParentId(categoryid);
        this.bat("update t_video set CategoryId="+categoryid+",ParentId="+ParentId+" where id=?",s);
    }
    public String getLabelList(int rowsNum,int charMax,String titlePrefix,int categoryid,int isfree,int isrecommend,int sort,int showtime){
        StringBuffer sb=new StringBuffer(512);
        String lurl=Sysconfig.getSiteUrl();
        ArrayList list=(ArrayList)getList(categoryid,isfree,isrecommend,1,null,sort,null,0,1,rowsNum);
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            sb.append("<li>");
            if (showtime == 1) {
                sb.append("<span class=\"col_right\">");
                sb.append(df.getFieldValue("ModiTime").substring(5, 10));
                sb.append("</span>");
            }
            sb.append(titlePrefix);
            sb.append("<a href=\""+lurl+"/video/show.jsp?id=");
            sb.append(df.getFieldValue("id"));
            sb.append("\">");
            sb.append(StringUtils.getTopic(df.getFieldValue("Title"),charMax));
            sb.append("</a>");
            sb.append("</li>\n");
        }
        return sb.toString();
    }
    public String getImgLabelList(int imgw,int imgh,int showtitle,int rowsNum,int charMax,String titlePrefix,int categoryid,int isfree,int isrecommend){
        StringBuffer sb=new StringBuffer(512);
        String lurl=Sysconfig.getSiteUrl();
        ArrayList list=(ArrayList)getList(categoryid,isfree,isrecommend,1,null,0,null,0,1,rowsNum);
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            sb.append("<li>");
            sb.append("<a href=\""+lurl+"/video/show.jsp?id=");
            sb.append(df.getFieldValue("id"));
            sb.append("\">");
            sb.append("<img src=\"").append(df.getFieldValue("ViewImg")).append("\"");
            sb.append(" width=\""+imgw+"\"");
            sb.append(" height=\""+imgh+"\" border=\"0\" /></a>");
            if(showtitle==1){
                sb.append("<h6>");
                sb.append(titlePrefix);
                sb.append("<a href=\""+lurl+"/video/show.jsp?id=");
                sb.append(df.getFieldValue("id"));
                sb.append("\">");
                sb.append(StringUtils.getTopic(df.getFieldValue("Title"),charMax));
                sb.append("</a>");
                sb.append("</h6>");
            }
            sb.append("</li>\n");
        }
        return sb.toString();
    }    
}
