/*
 * DbImport.java
 *
 * Created on 20071213, 8:39
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.gather;
import java.sql.*;
/**
 *
 * @author totcms.com
 */
public class DbImport {
    private static Connection conn=null;
    /** Creates a new instance of DbImport */
    public DbImport() {
    }
    /** get connection */
    public static Connection getConnection(){
        if(conn!=null)
            return conn;
        else
            return null;
    }
    public static Connection getNewConnection(int databaseType,String driverClass,String address,String port,String database,String username,String password,String encode){
        String url="";
        switch (databaseType) {
            case 1://sqlserver
                url="jdbc:jtds:sqlserver://"+address+":"+port+";DatabaseName="+database+";User="+username+";Password="+password;
                break;
            case 2://oracle(oracle.jdbc.driver.OracleDriver)
                url="jdbc:oracle:thin:@"+address+":"+port+":"+database;
                break;
            case 3://db2(com.ibm.db2.jcc.DB2Driver)
                url="jdbc:db2://"+address+":"+port+"/"+database;
                break;
            case 4://sybase(com.sybase.jdbc2.jdbc.SybDriver)
                url="jdbc:sybase:Tds:"+address+":"+port+"/"+database;
                break;
            case 5://imformix(com.informix.jdbc.IfxDriver)
                url="jdbc:informix-sqli://"+address+":"+port+"/"+database+":informixserver=myserver;";
                break;
            case 6://mysql(com.mysql.jdbc.Driver)
                url="jdbc:mysql://"+address+":"+port+"/"+database+"?useUnicode=true&characterEncoding="+encode;
                //url="jdbc:mysql://"+address+":"+port+"/"+database;
                break;
            case 7://postgresql(org.postgresql.Driver)
                url="jdbc:postgresql://"+address+":"+port+"/"+database;
                break;
            case 8://hsqldb(org.hsqldb.jdbcDriver )
                url="jdbc:hsqldb:hsql://"+address+":"+port+"/"+database;
                break;
            case 9://access
                url="jdbc:odbc:driver={Microsoft Access Driver (*.mdb)};DBQ="+database;
                break;
            case 10://sapdb(com.sap.dbtech.jdbc.DriverSapDB)
                url="jdbc:sapdb://"+address+"/"+database;
                break;
            case 11://interbase(interbase.interclient.Driver)
                url="jdbc:interbase:"+address+"/"+port+" "+database;
                break;
            case 12://firebird(org.firebirdsql.jdbc.FBDriver)
                url="jdbc:firebirdsql:"+address+"/"+port+" "+database;
                break;
        }
        try{
            try{
                Class.forName(driverClass).newInstance();
            }catch(ClassNotFoundException e){}
            if(username!=null &&databaseType!=1){
                conn= DriverManager.getConnection( url,username, password);
            }else{
                conn= DriverManager.getConnection( url );
            }
        } catch(Exception ex){
            System.out.println(ex);
        }
        return conn;
    }
    public static void closeResultSet(ResultSet rs)
    throws SQLException {
        if(rs != null) {
            try {
                rs.close();
                rs = null;
            } catch(SQLException sqlexception) { }
        }
    }
    public static void closePreStmt(PreparedStatement psmt)
    throws SQLException {
        if(psmt != null) {
            try {
                psmt.clearParameters();
                psmt.close();
                psmt = null;
            } catch(SQLException sqlexception) { }
        }
    }
    public static void closeStmt(Statement stmt)
    throws SQLException {
        if(stmt != null) {
            try {
                stmt.clearBatch();
                stmt.close();
                stmt = null;
            } catch(SQLException sqlexception) { }
        }
    }
    public static String getTables(String tbl){
        StringBuffer sb=new StringBuffer(1024);
        if(conn!=null){
            String[] tbltypes={"TABLE"};
            ResultSet rs=null;
            try{
                DatabaseMetaData dbm=conn.getMetaData();
                rs=dbm.getTables(null, null, null,tbltypes);
                while(rs.next()){
                    sb.append("<option value=\""+rs.getString(3)+"\"");
                    if(tbl!=null && tbl.equals(rs.getString(3))){
                        sb.append(" selected=\"selected\"");
                    }
                    sb.append(">"+rs.getString(3)+"</option>\n");
                }
            }catch(SQLException e){} finally{
                try{
                    closeResultSet(rs);
                }catch(Exception e){}
            }
        }else{
            return "";
        }
        return sb.toString();
    }
    public static String getFields(String tbl){
        StringBuffer sb=new StringBuffer(1024);
        if(conn!=null && tbl!=null){
            PreparedStatement statement = null;
            ResultSet rs=null;
            try{
                statement=conn.prepareStatement("select * from "+tbl+" where 1=0");
                rs=statement.executeQuery();
                ResultSetMetaData rm=rs.getMetaData();
                for(int i=1;i<=rm.getColumnCount();i++){
                    sb.append("<option value=\""+rm.getColumnName(i)+"\">"+rm.getColumnName(i)+"</option>\n");
                }
            }catch(SQLException sqle) {
            } finally {
                try{
                    closeResultSet(rs);
                    closePreStmt(statement);
                } catch(Exception sqle) {}
            }
        }
        return sb.toString();
    }
    public static String getFieldsCheckBox(String tbl){
        StringBuffer sb=new StringBuffer(1024);
        if(conn!=null && tbl!=null){
            PreparedStatement statement = null;
            ResultSet rs=null;
            try{
                statement=conn.prepareStatement("select * from "+tbl+" where 1=0");
                rs=statement.executeQuery();
                ResultSetMetaData rm=rs.getMetaData();
                for(int i=1;i<=rm.getColumnCount();i++){
                    sb.append("<input type=\"checkbox\" name=\"field_cb\" id=\"field_cb\" value=\""+rm.getColumnName(i)+"\" />"+rm.getColumnName(i));
                    //sb.append("<option value=\""+rm.getColumnName(i)+"\">"+rm.getColumnName(i)+"</option>\n");
                }
            }catch(SQLException sqle) {
            } finally {
                try{
                    closeResultSet(rs);
                    closePreStmt(statement);
                } catch(Exception sqle) {}
            }
        }
        return sb.toString();
    }
    public static void close(){
        try {
            if(conn != null) {
                try {
                    conn.close();
                    conn = null;
                } catch(SQLException e) {
                    conn.close();
                    conn = null;
                }
            }
        } catch(SQLException e) {
            e.printStackTrace();
        } finally {
        }
    }
}
