/*
 * GatherTask.java
 *
 * Created on 2007131, 9:26
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.gather;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import tot.bean.DataField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class GatherTask {
    private static Log log = LogFactory.getLog(GatherTask.class);
    ExecutorService executor = Executors.newFixedThreadPool(10);
    String[] urls=null;
    DataField params=null;
    /** Creates a new instance of GatherTask */
    public GatherTask(String[] u,DataField df) {
        this.urls=u;
        this.params=df;
    }
    public void start() throws IOException {
        log.info("start gather task with urls num:"+urls.length);
        for(int i=0;i<urls.length;i++)
            executor.execute(new GatherThread(urls[i],params));
    }    
    public void shutdown() throws InterruptedException {
        executor.shutdown();
        executor.awaitTermination(2, TimeUnit.SECONDS);
        if(executor.isTerminated()){
            executor.shutdownNow();
            log.info("shutdown task");
        }else{
            log.debug("call shut down after 2 seconds");
            shutdown();
        }
    }    
    
}