/*
 * ScheduledGatherTask.java
 *
 * Created on 2007131, 9:27
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.gather;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.HashMap;
import tot.bean.DataField;
import tot.gather.GatherTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class ScheduledGatherTask {
    private static Log log = LogFactory.getLog(ScheduledGatherTask.class);
    ScheduledExecutorService  executor = Executors.newScheduledThreadPool(1);
    public static HashMap taskList=new HashMap();
    int taskId=0;
    long timeafter=0;
    long septime=0;
    /** Creates a new instance of GatherTask */
    public ScheduledGatherTask(int taskid,long time1,long time2) {
        this.taskId=taskid;
        this.timeafter=time1;
        this.septime=time2;
    }
    public void start() throws IOException {    
        taskList.put(taskId, this);
        log.info("start timer gather taskID:"+taskId+" by timeafter:"+timeafter+"septime:"+septime);
        executor.scheduleAtFixedRate(new ScheduledGatherThread(taskId),timeafter,septime, TimeUnit.SECONDS);
    }    
    public static ScheduledGatherTask get(int taskid){
        return (ScheduledGatherTask)taskList.get(taskid);
    }
    public void shutdown() throws InterruptedException {
        log.info("shut down gather task"+executor);
        executor.shutdown();
        executor.awaitTermination(2, TimeUnit.SECONDS);
        if(executor.isTerminated()){
            executor.shutdownNow();
        }  
    }    
}
