/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tot.gather;

import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.util.UrlUtil;
import tot.util.StringUtils;
import tot.util.HtmlParse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author Administrator
 */
public class ScheduledGatherThread implements Runnable {

    private static Log log = LogFactory.getLog(ScheduledGatherThread.class);
    private int taskId = 0;
    private int count = 0;

    /** Creates a new instance of GatherThread */
    public ScheduledGatherThread(int taskid) {
        this.taskId = taskid;
    }

    public void run() {
        count++;
        log.debug("start scheduled gather task:" + taskId + " for " + count + " times");
        if (taskId > 0) {
            DataField df = DaoFactory.getGatherDAO().getGather(taskId);
            if (df != null) {
                int ReplaceUrl = Integer.parseInt(df.getFieldValue("ReplaceUrl"));
                String UrlFrom = df.getFieldValue("UrlFrom");
                String UrlTo = df.getFieldValue("UrlTo");
                String ReplaceStr = df.getFieldValue("ReplaceStr");
                String ListLabelStart = df.getFieldValue("ListLabelStart");
                String ListLabelEnd = df.getFieldValue("ListLabelEnd");
                String content = UrlUtil.getHtml(df.getFieldValue("Url"), df.getFieldValue("Encode"));
                if (content != null) {
                    String links = StringUtils.subStr(content, ListLabelStart, ListLabelEnd);
                    if (ReplaceUrl == 1) {
                        links = StringUtils.replaceString(links, UrlFrom, UrlTo);
                    }
                    if (ReplaceStr != null && ReplaceStr.length() > 0) {
                        links = StringUtils.replaceString(links, ReplaceStr, "");
                    }
                    String[] linkArr = HtmlParse.getUrls(links);
                    GatherTask task = new GatherTask(linkArr, df);
                    try {
                        task.start();
                    } catch (IOException e) {
                        log.debug(e);
                    } finally {
                        try{
                            task.shutdown();
                        }catch (Exception e) {
                            
                        }
                    }
                }
            }
        }
    }
}
