/*
 * Sysconfig.java
 *
 * Created on 2006725, 11:25
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.global;
import java.io.File;
import tot.xml.DOM4JConfiguration;
import tot.util.FileUtil;
import java.net.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sysconfig {

    private static Log log = LogFactory.getLog(Sysconfig.class);

    final static String OPTION_FILE_NAME = "totcms.xml";
    /*<global_options> */
    private static String totcms_version="Tot Cms 1.1";
    public static String getTotCmsVersion() {
        return totcms_version;
    }
    /* <Database Options> */
    private static boolean useDataSource = false;
    public static boolean isUseDataSource() {
        return useDataSource;
    }

    private static String dataSourceName = "";
    public static String getDataSourceName() {
        return dataSourceName;
    }

    // MUST NOT refer to DBUtils, or we will get an infinite recurse ???
    private static int databaseType = 0;//DATABASE_UNKNOWN
    public static int getDatabaseType() {
        return databaseType;
    }

    private static String driverClassName = "org.gjt.mm.mysql.Driver";
    public static String getDriverClassName() {
        return driverClassName;
    }

    private static String databaseURL = "jdbc:mysql://127.0.0.1/totcms?useUnicode=true&characterEncoding=utf-8";
    public static String getDatabaseURL() {
        return databaseURL;
    }

    private static String databaseUser = "root";
    public static String getDatabaseUser() {
        return databaseUser;
    }

    private static String databasePassword = "";
    public static String getDatabasePassword() {
        return databasePassword;
    }

    private static int maxConnection = 20;
    public static int getMaxConnection() {
        return maxConnection;
    }

    /* by default, the unit of time is milisecond */
    private static int maxTimeToWait = 2000;// 2 seconds
    public static int getMaxTimeToWait() {
        return maxTimeToWait;
    }

    private static int minutesBetweenRefresh = 30;// 30 minutes
    public static int getMinutesBetweenRefresh() {
        return minutesBetweenRefresh;
    }
    /* </Database Options> */
    /* <Mail Options> */
    private static boolean useMailSource = false;
    public static boolean isUseMailSource() {
        return useMailSource;
    }

    private static String mailSourceName = "";
    public static String getMailSourceName() {
        return mailSourceName;
    }

    private static String mailServer = "mail.yourdomain";
    public static String getMailServer() {
        return mailServer;
    }

    private static int mailServerPort = 25;
    public static int getMailServerPort() {
        return mailServerPort;
    }

    private static String defaultMailFrom = "youruser@yourdomain";
    public static String getDefaultMailFrom() {
        return defaultMailFrom;
    }

    private static String mailUserName = "";// allow empty username
    public static String getMailUserName() {
        return mailUserName;
    }

    private static String mailPassword = "";
    public static String getMailPassword() {
        return mailPassword;
    }
    /* </Mail Options> */
   /* <Param Options> */
    private static String contextPath = "";// allow ROOT context
    public static String getContextPath() {
        return contextPath;
    }

    private static String site_url = "";
    public static String getSiteUrl() {
        return site_url;
    }
    private static String site_name="totcms";
    public static String getSiteName() {
        return site_name;
    }
    private static String cookie_domain="totcms.com";
    public static String getCookieDomain(){
        return cookie_domain;
    }
    private static int article_num_per_page=50;
    public static int getArticleNumPerPage(){
        return article_num_per_page;
    }
    private static String file_ext=".htm";
    public static String getFileExt(){
        return file_ext;
    }
    private static int rss_new_num=50;
    public static int getRssNewNum(){
        return rss_new_num;
    }
    private static int page_send_maxnum=50;
    public static int getPageSendMaxNum(){
        return page_send_maxnum;
    }
    private static int upload_photo_maxsize=200;
    public static int getUploadPhotoMaxsize(){
        return upload_photo_maxsize;
    }
    private static String upload_permit_ext="gif,jpeg,png,bmp,rar,doc,txt,zip,wmv,rm,rmvb,mov,mp3,avi";
    public static String getUploadPermitExt(){
        return upload_permit_ext;
    }
    private static boolean wartermark=false;
    public static boolean isWarterMark() {
        return wartermark;
    }
     /* warter mark parameters */
    
    private static int wartermark_type=1;
    public static int getWarterMarkType() {
        return wartermark_type;
    }     
    private static String wartermark_text="";
    public static String getWarterMarkText(){
        return wartermark_text;
    }
    private static String wartermark_color="";
    public static String getWarterMarkColor(){
        return wartermark_color;
    }
    private static int wartermark_size=1;
    public static int getWarterMarkSize() {
        return wartermark_size;
    }
    private static int wartermark_position=1;
    public static int getWarterMarkPosition() {
        return wartermark_position;
    }
    private static boolean save_admin_log=false;
    public static boolean isSaveAdminLog() {
        return save_admin_log;
    }
    private static int minfetchmoney=1;
    public static int getMinFetchMoney() {
        return minfetchmoney;
    }
    private static boolean mail_verify=false;
    public static boolean isMailVerify(){
        return mail_verify;
    }
     /* search index options */
    private static String indexdir="";
    public static String getIndexDir(){
        return indexdir;
    }
    private static String luceneAnalyzerClassName    = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    public static String getLuceneAnalyzerClassName(){
        return luceneAnalyzerClassName;
    }
    /* the unit of the server offset is hour*/
    private static int serverHourOffset = 0; /* GMT timezone */
    public static int getServerHourOffset() {
        return serverHourOffset;
    }    
    /* <IP Options>*/
    private static String blockedIPs = "";
    public static String getBlockedIPs() {
        return blockedIPs;
    }
    /* </IP Options>*/
    /* Destribute Ip */
    private static String distribute_ip = "";
    public static String getDistributeIp() {
        return distribute_ip;
    }
    private static String distribute_key="";
    public static String getDistributeKey() {
        return distribute_key;
    }
    private static boolean distribute_active = false;
    public static boolean isDistributeActive() {
        return distribute_active;
    }
    /* <tutor Options>*/
    private static float tutor_money_per_pub =0.0F;
    public static float getTutorMoneyPerPub() {
        return tutor_money_per_pub;
    }
    /* </tutor Options>*/
    /* pay api */
    //cai fu tong
    private static String paycomid="";
    public static String getPayComId(){
        return paycomid;
    }
    private static String paykey="";
    public static String getPayKey(){
        return paykey;
    }
    //99bill
    private static String ninebill_paycomid="";
    public static String getNineBillPayComId(){
        return ninebill_paycomid;
    }
    private static String ninebill_paykey="";
    public static String getNineBillPayKey(){
        return ninebill_paykey;
    }
    //alipay
    private static String alipay_paycomid="";
    public static String getAlipayPayComId(){
        return alipay_paycomid;
    }
    private static String alipay_paykey="";
    public static String getAlipayPayKey(){
        return alipay_paykey;
    }
    static {
        load();
    }

    public static void load() {
        reload();
    }   
    public static void reload() {
        String classPath = FileUtil.getServletClassesPath();        
        String configFilename = classPath + OPTION_FILE_NAME;        
        try {
            DOM4JConfiguration conf = new DOM4JConfiguration(new File(configFilename));
            totcms_version=conf.getString("global_options.totcms_version");
            /* <Database Options> */
            useDataSource = conf.getBoolean("dboptions.use_datasource", false);
            databaseType = conf.getInt("dboptions.database_type", 0);           
            if (useDataSource) {
                dataSourceName = conf.getString("dboptions.datasource_name");
            } else {
                driverClassName = conf.getString("dboptions.driver_class_name", driverClassName);
                databaseURL = conf.getString("dboptions.database_url", databaseURL);
                databaseUser = conf.getString("dboptions.database_user", databaseUser);
                databasePassword = conf.getString("dboptions.database_password",databasePassword);

                maxConnection = conf.getInt("dboptions.max_connection", maxConnection);
                maxTimeToWait = conf.getInt("dboptions.max_time_to_wait", maxTimeToWait);

                minutesBetweenRefresh = conf.getInt("dboptions.minutes_between_refresh", minutesBetweenRefresh);
                if (minutesBetweenRefresh < 1) {
                    minutesBetweenRefresh = 1; //min is 1 minute
                }
                
            }
            /* <Database Options> */            
            /* <Mail Options> */
            useMailSource = conf.getBoolean("mailoptions.use_mailsource", false);

            if (useMailSource) {
                mailSourceName = conf.getString("mailoptions.mailsource_name");
            } else {
                mailServer = conf.getString("mailoptions.mail_server", mailServer);
                defaultMailFrom = conf.getString("mailoptions.default_mail_from", defaultMailFrom);
                mailUserName = conf.getString("mailoptions.username", mailUserName);
                mailPassword = conf.getString("mailoptions.password", mailPassword);
                mailServerPort = conf.getInt("mailoptions.port", mailServerPort);
            }
            /* </Mail Options> */
            /* <Parameter Options> */
            contextPath = conf.getString("paramoptions.context_path", contextPath);
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            site_url = conf.getString("paramoptions.site_url", site_url);
            if (site_url.endsWith("/")) {
                site_url = site_url.substring(0, site_url.length() - 1);
            }
            site_name=conf.getString("paramoptions.site_name", site_name);
            if(site_name!=null){
		site_name=URLDecoder.decode(new String(site_name.getBytes("iso-8859-1"),"utf-8"),"utf-8");
            }
            cookie_domain=conf.getString("paramoptions.cookie_domain", cookie_domain);
            article_num_per_page= conf.getInt("paramoptions.article_num_per_page", article_num_per_page);
            file_ext=conf.getString("paramoptions.file_ext", file_ext);
            rss_new_num=conf.getInt("paramoptions.rss_new_num", rss_new_num);
            page_send_maxnum=conf.getInt("paramoptions.page_send_maxnum", page_send_maxnum);
            upload_photo_maxsize=conf.getInt("paramoptions.upload_photo_maxsize", upload_photo_maxsize);
            upload_permit_ext=conf.getString("paramoptions.upload_permit_ext", upload_permit_ext);
            wartermark=conf.getBoolean("paramoptions.wartermark",wartermark);
            /* warter mark parameters */
            wartermark_type=conf.getInt("paramoptions.wartermark_type", wartermark_type);
            wartermark_text=conf.getString("paramoptions.wartermark_text", wartermark_text);
            if(wartermark_text!=null){
		wartermark_text=URLDecoder.decode(new String(wartermark_text.getBytes("iso-8859-1"),"utf-8"),"utf-8");
            }
            wartermark_color=conf.getString("paramoptions.wartermark_color", wartermark_color);
            wartermark_size=conf.getInt("paramoptions.wartermark_size", wartermark_size);
            wartermark_position=conf.getInt("paramoptions.wartermark_position", wartermark_position);
            save_admin_log=conf.getBoolean("paramoptions.save_admin_log",save_admin_log);
            minfetchmoney = conf.getInt("paramoptions.minfetchmoney", minfetchmoney);
            mail_verify=conf.getBoolean("paramoptions.mail_verify", mail_verify);
            /* </Parameter Options> */
            /* search index*/
            indexdir=conf.getString("searchindex.indexdir", indexdir);
            luceneAnalyzerClassName    = conf.getString("searchindex.lucene_analyzer_implementation", luceneAnalyzerClassName);
            /* <Date Time Options> */
            serverHourOffset = conf.getInt("dateoptions.server_hour_offset", serverHourOffset);
            if ((serverHourOffset < -13) || (serverHourOffset > 13)) {
                serverHourOffset = 0;
            }
            /* </Date Time Options> */           
            /* <IP Options>*/
            blockedIPs = conf.getString("ipoptions.blocked_ip", blockedIPs);
            /* </IP Options>*/
            /* Destribute Ips */
            distribute_ip=conf.getString("distribute.distribute_ip", distribute_ip);
            distribute_active=conf.getBoolean("distribute.distribute_active", distribute_active);
            distribute_key=conf.getString("distribute.distribute_key", distribute_key);
            /* tutor */
            tutor_money_per_pub=conf.getFloat("tutor.tutor_money_per_pub", tutor_money_per_pub);
            /* pay api */
            paycomid = conf.getString("payapi.tenpay_paycomid", paycomid);
            paykey = conf.getString("payapi.tenpay_paykey", paykey);
            //99bill pay
            ninebill_paycomid=conf.getString("payapi.ninebill_paycomid", ninebill_paycomid);
            ninebill_paykey=conf.getString("payapi.ninebill_paykey", ninebill_paykey);
            //alipay
            alipay_paycomid=conf.getString("payapi.alipay_paycomid", alipay_paycomid);
            alipay_paykey=conf.getString("payapi.alipay_paykey", alipay_paykey);
        } catch (Exception e) {
            String message = "global.Sysconfig: Can't read the configuration file: '" + configFilename + "'. Make sure the file is in your CLASSPATH";
            log.error(message, e);
        }
    }
}