/*
 * ArticleSearch.java
 *
 * Created on 2006127, 5:07
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.search;
import tot.util.*;
import tot.exception.BadInputException;
import java.io.*;
import java.sql.Timestamp;
import java.util.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
/**
 *
 * @author Administrator
 */
public class ArticleSearch {
    
    /** Creates a new instance of ArticleSearch */
    public ArticleSearch() {
    }
    public void processSearch(HttpServletRequest request, HttpServletResponse response,String key,int scopein,int date,
            int offset,int rows,int beforafter,int sorttype,int catalogid)
    throws BadInputException, IOException {        
        if (rows == 0) {
            rows = 20;// fix NullPointerException when rows = 0
        }        
        // offset should be even when divide with rowsToReturn
        offset = (offset / rows) * rows;
        
        SearchQueryNoSql query = new SearchQueryNoSql();
        
        if (key!=null && key.length() > 0) {            
            query.setSearchString(key);            
            query.setScopeInArticle(scopein);
        }        
        //if (username!=null && username.length() > 0) {
            //query.setUserName(username);
        //}
        
        //if (hitsLimit > 0) {
            //query.setArticleHitsLimit(hitsLimit);
        //}
        if ((date !=SearchQuery.SEARCH_ANY_DATE) && (date < 365 * 10)) { // 10 years
            long deltaTime = DateUtil.DAY * date;            
            Timestamp now = DateUtil.getCurrentGMTTimestamp();
            Timestamp from = null;
            Timestamp to = null;
            
            long currentTime = now.getTime();
            
            if (beforafter == SearchQuery.SEARCH_NEWER) {
                from = new Timestamp(currentTime - deltaTime);
            } else {// older
                to = new Timestamp(currentTime - deltaTime);
            }
            
            query.setFromDate(from);
            query.setToDate(to);
        }        
        if (catalogid > 0) {
            query.setCatalogId(catalogid);
        }
        query.setSortType(sorttype);
        query.searchDocuments(offset, rows);
        int hitCount = query.getHitCount();
        Collection result = query.getArticleResult();       
        if (offset > hitCount) {
            throw new BadInputException("Cannot search with offset("+offset+") > total("+hitCount+") posts");
        }        
        request.setAttribute("rows", new Integer(rows));
        request.setAttribute("TotalArticles", new Integer(hitCount));
        request.setAttribute("ArticleBeans", result);
        request.setAttribute("SearchQuery", query);        
    }
}
