/*
 * IndexWebHander.java
 *
 * Created on 2007110, 9:30
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package tot.search;

import tot.util.*;
import tot.db.DBUtils;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.exception.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 *
 * @author Administrator
 */
public class IndexWebHander {

    /** Creates a new instance of IndexWebHander */
    public IndexWebHander() {
    }

    public static int addIndexByDate(HttpServletRequest request) {
        String fromdate = RequestUtil.getString(request, "FromDate");
        String todate = RequestUtil.getString(request, "ToDate");
        Timestamp FromDate = null;
        if (fromdate != null && !fromdate.equals("")) {
            FromDate = new Timestamp(DateUtil.strToBirthday(fromdate).getTime());
        }
        Timestamp ToDate = null;
        if (todate != null && !todate.equals("")) {
            ToDate = new Timestamp(DateUtil.strToBirthday(todate).getTime());
        }
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked,CategoryId";
        String sql = null;
        sql = "select " + fieldArr + " from t_article where ModiTime>? and ModiTime<?";
        Collection articles = new ArrayList();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setTimestamp(1, FromDate);
            ps.setTimestamp(2, ToDate);
            rs=ps.executeQuery();
            DataField df;
            String[] splitStr=null;
            splitStr=fieldArr.split(",");
            while(rs.next()) {
                df=new DataField();
                for(int i=0;i<splitStr.length;i++){
                    df.setField(splitStr[i], rs.getString(i+1),0);
                }
                articles.add(df);
            }
        } catch(SQLException e){
            
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        int startN = 0;
        for (Iterator iter = articles.iterator(); iter.hasNext();) {
            DataField df = (DataField) iter.next();
            ArticleIndex.scheduleAddTask(df);
            startN++;
        }
        return startN;
    }

    public static int addIndexById(HttpServletRequest request) {
        int fromid = RequestUtil.getInt(request, "FromId");
        int ToId = RequestUtil.getInt(request, "ToId");
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked,CategoryId";
        String sql = null;
        sql = "select " + fieldArr + " from t_article where IsOutLink=0 and id>=" + fromid + " and id<=" + ToId;
        Collection articles = DaoFactory.getArticleDAO().getData(sql, fieldArr);
        int startN = 0;
        for (Iterator iter = articles.iterator(); iter.hasNext();) {
            DataField df = (DataField) iter.next();
            ArticleIndex.scheduleAddTask(df);
            startN++;
        }
        return startN;
    }
    public static void addIndexById(int id) {
        DataField df=DaoFactory.getArticleDAO().getArticle(id);        
        if (df!=null) {            
            ArticleIndex.scheduleAddTask(df);            
        }        
    }

    public static int runIndexByBat(HttpServletRequest request, String runtype) {
        String[] articleid = request.getParameterValues("articleid");
        int num = articleid.length;
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked,CategoryId";
        String sql = null;
        sql = "select " + fieldArr + " from t_article where IsOutLink=0";
        if (runtype != null && runtype.equals("delete")) {
            for (int i = 0; i < num; i++) {
                ArticleIndex.scheduleDeleteTask(Integer.parseInt(articleid[i]));
            }
        } else {
            for (int i = 0; i < num; i++) {
                DataField df = DaoFactory.getArticleDAO().getFirstData(sql + " and id=" + articleid[i], fieldArr);
                if (runtype != null && runtype.equals("add")) {
                    ArticleIndex.scheduleAddTask(df);
                } else if (runtype != null && runtype.equals("update")) {
                    ArticleIndex.scheduleUpdateTask(df);
                }
            }
        }
        return num;
    }
}
