/*
 * RebuildArticleIndexTask.java
 *
 * Created on 2006127, 12:06
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */
package tot.search;

import java.io.IOException;
import java.util.*;

import tot.dao.DaoFactory;
import tot.bean.DataField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

/**
 *
 * @author Administrator
 */
public class RebuildIndexTask extends TimerTask {

    /** Creates a new instance of RebuildArticleIndexTask */
    private static Log log = LogFactory.getLog(RebuildIndexTask.class);
    public static final int Articles_PER_FETCH = 200;
    public static final int MERGE_FACTOR = 20;
    private int maxArticleID = 0;
    private static boolean isRebuilding = false;

    public static boolean isRebuilding() {
        return isRebuilding;
    }

    /*
     * Contructor with default access, prevent new an instance from outside package
     */
    RebuildIndexTask(int maxArticleID) {
        this.maxArticleID = maxArticleID;
    }

    /**
     * Create new index. If anything exist already - delete it
     */
    public void run() {
        isRebuilding = true;
        long start = System.currentTimeMillis();
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = ArticleIndex.getIndexWriter(directory, true);
            writer.setMergeFactor(MERGE_FACTOR);
            // note that the articleTotal is get at the begining of the method
            // so that it will index only these articles. Later while indexing,
            // if new articles are added, then other task will take care it
            int articleTotal = DaoFactory.getArticleDAO().getTotalCount(0);
            int pagenum = (articleTotal - 1 + Articles_PER_FETCH) / Articles_PER_FETCH;
            int index = 1;
            int indexNum = 0;
            while (index <= pagenum) {
                // Please note that is method sorted by ArticleCreationDate ASC
                Collection articles = DaoFactory.getArticleDAO().getArticleIndex_Limit(0, index, Articles_PER_FETCH);
                for (Iterator iter = articles.iterator(); iter.hasNext();) {
                    DataField df = (DataField) iter.next();
                    ArticleIndex.doIndex(df, writer);
                    indexNum++;
                }
                index++;
            } //end while
            writer.optimize();
            log.info("Rebuilt index finished successfully! " + indexNum + " article(s) indexed.");
        } catch (Exception e) {
            log.error("Error while rebuilding index", e);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (directory != null) {
                    directory.close();
                    log.debug("Cannot close directory.");
                }
            } catch (IOException e) {
                log.debug("Close directory case exception:",e);
            }
        }
        log.info("RebuildIndexTask took " + (System.currentTimeMillis() - start) + " ms");
        isRebuilding = false;
    }
}
