/*
 * SendSpecial.java
 *
 * Created on 200739, 11:13
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.send;
import tot.util.*;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.exception.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class SendSpecial {
    private static Log log = LogFactory.getLog(SendCategory.class);
    /** Creates a new instance of SendSpecial */
    public SendSpecial() {
    }
    /**
     * create special list file
     */
    public void createSpecialList(Locale locale,int specialId,int pagesizes,String savePath,String template,String distributePath){
        int totalnum=0;
        int pagenum=0;
        int maxPageNum=Sysconfig.getPageSendMaxNum();
        totalnum=DaoFactory.getArticleDAO().getTotalCount_Special(specialId);
        String templateContent="";
        String contextPath=Sysconfig.getContextPath();
        String url=Sysconfig.getSiteUrl();
        //ļ
        try{
            FileUtil.createDir(savePath,true);
        } catch(IOException e){
            log.error("Can't create Dir:"+savePath);
        }
        //ȡģ
        try{
            templateContent=FileUtil.readFile(template,"UTF-8");
        } catch(Exception e){
            log.error("Can't find template file:"+template);
        }
        String diagonal=FileUtil.getSeparator();
        if(totalnum!=0){
            pagenum=(totalnum+pagesizes-1)/pagesizes;//ҳ
            if(pagenum<1){
                pagenum=1;
            }
            if(pagenum>maxPageNum){
                pagenum=maxPageNum;
            }
            
            //ʼҳļ-------------------------------------------
            for(int i=1;i<=pagenum;i++){
                StringBuffer newsliststr=new StringBuffer(512);
                String showpagestr="";
                showpagestr=showPage(locale,i,totalnum,pagenum);
                ArrayList list=(ArrayList)DaoFactory.getArticleDAO().getArticleSpecialList_Limit(specialId,i,pagesizes);
                newsliststr.append("<table>\n");
                for (Iterator iter = list.iterator(); iter.hasNext(); ) {
                    String tlinkurl="";
                    DataField df=(DataField)iter.next();
                    if(Integer.parseInt(df.getFieldValue("IsOutLink"))==0)
                        tlinkurl=url+contextPath+df.getFieldValue("SavePath");
                    else
                        tlinkurl=df.getFieldValue("OutLinkUrl");
                    newsliststr.append("<tr><td>");
                    newsliststr.append("<a href=\"");
                    newsliststr.append(tlinkurl);
                    newsliststr.append("\" target=\"_blank\">");
                    newsliststr.append(df.getFieldValue("Title"));
                    newsliststr.append("</a>");
                    newsliststr.append("</td></tr>");
                }
                newsliststr.append("</table>");
                //滻ģ
                String Temptemplatecontent=templateContent;
                Temptemplatecontent=StringUtils.replaceString(Temptemplatecontent,"$ArticleList$",newsliststr.toString());
                if(i==maxPageNum){
                    Temptemplatecontent=StringUtils.replaceString(Temptemplatecontent,"$ShowPage$","[<a href=\"index_"+(i-1)+".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"/special/more.jsp?id="+specialId+"\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;");
                } else{
                    Temptemplatecontent=StringUtils.replaceString(Temptemplatecontent,"$ShowPage$",showpagestr);
                }
                Temptemplatecontent=LabelUtil.replaceAllLabel(Temptemplatecontent,specialId);
                //дݵļ
                FileUtil.createFile(Temptemplatecontent,savePath+diagonal+"index_"+i+".htm","UTF-8");
                log.info("create file:"+savePath+diagonal+"index_"+i+".htm"+" success ");
                /*try{
                   DistributeUtil.send(distributePath+"/"+"index_"+i+".htm", Temptemplatecontent);
                }catch(IOException e){

                }*/
            }
            //бҳ-------------------------------------------------
        }else{
            //滻ģ
                String Temptemplatecontent=templateContent;
                Temptemplatecontent=StringUtils.replaceString(Temptemplatecontent,"$ArticleList$","");
                Temptemplatecontent=StringUtils.replaceString(Temptemplatecontent,"$ShowPage$","");
                Temptemplatecontent=LabelUtil.replaceAllLabel(Temptemplatecontent,specialId);
                //дݵļ
                //logger.debug("write template file:"+Temptemplatecontent+" "+logger.getName());
                FileUtil.createFile(Temptemplatecontent,savePath+diagonal+"index_1.htm","UTF-8");
                log.info("create file:"+savePath+diagonal+"index_1.htm"+" success ");
                /*try{
                    DistributeUtil.send(distributePath+"/"+"index_1.htm", Temptemplatecontent);
                }catch(IOException e){

                }*/
        }
    }
    public String showPage(Locale locale,int currentpage,int totalnum,int pagenum){
        int prepage=0,nextpage=0;
        String returnStr="";
        prepage=currentpage-1;
        nextpage=currentpage+1;
        if (currentpage>1){
            returnStr=returnStr+"["+"<a href='index_"+prepage+".htm'>"+ResourceBundleUtil.getString(locale,"totcms.common.previous")+"</a>]&nbsp;&nbsp;&nbsp;";
        } else{
            returnStr=returnStr+"["+ResourceBundleUtil.getString(locale,"totcms.common.previous")+"]&nbsp;&nbsp;&nbsp;";
        }
        if (currentpage>=pagenum){
            returnStr=returnStr+"["+ResourceBundleUtil.getString(locale,"totcms.common.next")+"]";
        } else{
            returnStr=returnStr+"["+"<a href='index_"+nextpage+".htm'>"+ResourceBundleUtil.getString(locale,"totcms.common.next")+"</a>]&nbsp;&nbsp;&nbsp;";
        }
        returnStr=returnStr+"&nbsp;"+ResourceBundleUtil.getString(locale,"totcms.common.total")+":"+totalnum;
        returnStr=returnStr+"&nbsp;"+pagenum+"/";
        returnStr=returnStr+"&nbsp;"+currentpage;
        return returnStr;
    }
}
