/*
 * ArticleAdd.java
 *
 * Created on 2006921, 10:12
 */

package tot.servlet;
import tot.util.*;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.exception.*;
import tot.bean.DataField;
import tot.search.IndexWebHander;
import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 *
 * @author totcms
 * @version 2.0
 */
public class ArticleAdd extends HttpServlet {
    ServletContext sc;
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        sc=config.getServletContext();
    }
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        request.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        HttpSession session=request.getSession();
        String admin=null;
        String haspriv=null;
        int adminid=0;
        int lastid=0;
        int CategoryId=RequestUtil.getInt(request,"CategoryId");
        int Copy2Category=RequestUtil.getInt(request,"Copy2Category");
        int ParentId=DaoFactory.getCategoryDAO().getParentId(CategoryId);
        if(session.getAttribute("admin")!=null){
            admin=(String)session.getAttribute("admin");
        }
        if(session.getAttribute("role")!=null){
            haspriv=(String)session.getAttribute("role");
        }
        if(session.getAttribute("adminid")!=null){
            adminid=Integer.parseInt((String)session.getAttribute("adminid"));
        }
        if(admin==null || haspriv==null){
            response.sendRedirect("login.jsp");
        }
        if(adminid!=1){
            if(!DaoFactory.getAdminDAO().ifHasPrivilege(haspriv,"p03"+CategoryId))
                throw new ServletException("you don't have privilege");
        }
        if(DateUtil.isExpire())
            throw new ServletException("System get error");
        //ϵͳ
        String currentPath=sc.getRealPath("/");
        Random r=new Random(System.currentTimeMillis());
        int rand=r.nextInt();
        if(rand<0){
            rand=0-rand;
        }
        String separator=FileUtil.getSeparator();//ļзָ
        String todayStr=DateUtil.getStringDateShort();//
        String todayFolder=currentPath+"html"+separator+todayStr+separator;//ļ
        //ļ
        FileUtil.createDir(todayFolder,true);
        String fileExt=Sysconfig.getFileExt();//ļչ
        String fileName=rand+fileExt;
        String fileSavePath=todayFolder+fileName;//ļɵַ
        String SavePath="/html/"+todayStr+"/"+fileName;//Ҫ浽ݿеWEBַ
        //ȡWEB
        String Title=RequestUtil.getString(request,"Title");
        String SubHeading=RequestUtil.getString(request,"SubHeading");
        if(SubHeading==null){
            SubHeading="";
        }
        String TitleColor=RequestUtil.getString(request,"TitleColor");
        String KeyWords=RequestUtil.getString(request,"KeyWords");
        if(KeyWords==null) KeyWords="";
        String RelateKey=RequestUtil.getString(request,"RelateKey");
        if(RelateKey==null)
            RelateKey="";
        //String[] RelateArr=RelateKey.split(",");
        int RelateNum=RequestUtil.getInt(request,"RelateNum");
        int SaveRemoteImg=RequestUtil.getInt(request,"SaveRemoteImg");
        String Content=RequestUtil.getString(request,"Content");        
        //ؼʶ
        if(Content!=null){
            ArrayList list=(ArrayList)DaoFactory.getKeywordsDAO().getKeywords();
            for (Iterator iter = list.iterator(); iter.hasNext(); ) {
                DataField df=(DataField)iter.next();
                String urls="<a href=\""+df.getFieldValue("Url")+"\" target=\"_blank\">"+df.getFieldValue("Title")+"</a>";
                Content=StringUtils.replaceString(Content,df.getFieldValue("Title"),urls);
            }
        }
        int IsOutLink=RequestUtil.getInt(request,"IsOutLink");
        String OutLinkUrl=RequestUtil.getString(request,"OutLinkUrl");
        int TemplateId=RequestUtil.getInt(request,"TemplateId");
        int SpecialId=RequestUtil.getInt(request,"SpecialId");
        int Top1=RequestUtil.getInt(request,"Top1");
        int ToTop=RequestUtil.getInt(request,"ToTop");
        int ToHot=RequestUtil.getInt(request,"ToHot");
        int Recommend=RequestUtil.getInt(request,"Recommend");
        int Images=RequestUtil.getInt(request,"Images");
        int IsSlide=RequestUtil.getInt(request,"IsSlide");
        int Checked=RequestUtil.getInt(request,"Checked");
        String Author=RequestUtil.getString(request,"Author");
        String SourceFrom=RequestUtil.getString(request,"SourceFrom");
        String Editor=RequestUtil.getString(request,"Editor");
        String UserName=(String)session.getAttribute("admin");
        String Photo=RequestUtil.getString(request,"Photo");
        int Hits=RequestUtil.getInt(request,"Hits");
        Timestamp addtime=DateUtil.getCurrentGMTTimestamp();
        int gb2big=RequestUtil.getInt(request,"gb2big5");
        if(gb2big==1){
          Title=BigGbkUtil.toBig(Title);
          Content=BigGbkUtil.toBig(Content);
        }
        String Summary=RequestUtil.getString(request,"Summary");
        if(Summary==null || Summary.equals("")){
            Summary=StringUtils.removeHtml(Content);
        }
        if(Summary.length()>250){
            Summary=Summary.substring(0,250);
        }
        if(IsOutLink==1){
            SavePath="";
        }
        if(IsOutLink==0){
            if(SaveRemoteImg==1){
                String rmtimg_urlf=RequestUtil.getString(request,"rmtimg_urlf");
                String rmtimg_urlt=RequestUtil.getString(request,"rmtimg_urlt");
                if(rmtimg_urlf!=null && rmtimg_urlt!=null && !rmtimg_urlf.equals("") && rmtimg_urlt.equals("")){
                    Content=StringUtils.replaceString(Content,rmtimg_urlf,rmtimg_urlt);
                }
                String uploadpath=currentPath+"upload"+separator+todayStr;
                FileUtil.createDir(uploadpath,true);
                String imgurls[]=HtmlParse.getImgs(Content);
                if(imgurls!=null){
                    for(int j=0;j<imgurls.length;j++){
                        int dotpos=imgurls[j].lastIndexOf(".");
                        if(dotpos!=-1){
                            String ext=imgurls[j].substring(dotpos);
                            String imgurl=Sysconfig.getContextPath()+"/upload/"+todayStr+"/"+rand+"_"+j+ext;
                            Content=StringUtils.replaceString(Content,imgurls[j],imgurl);
                            UrlUtil.getRemoteFile(imgurls[j],uploadpath+separator+rand+"_"+j+ext);
                        }
                    }
                }
            }
            lastid=DaoFactory.getArticleDAO().getLastId();
            //ȡģ
            String template=DaoFactory.getTemplateDAO().getContent(TemplateId);
            if(template==null) throw new ServletException("template is null(id:"+TemplateId+")");
            //ȡ
            String RelateLink=DaoFactory.getArticleDAO().getRelate(RelateKey,RelateNum,true);
            //滻ģ
            template=StringUtils.replaceString(template,"$Title$",Title);
            template=StringUtils.replaceString(template,"$SubHeading$",SubHeading);
            template=StringUtils.replaceString(template,"$Summary$",Summary);
            template=StringUtils.replaceString(template,"$KeyWords$",KeyWords);
            template=StringUtils.replaceString(template,"$id$",lastid+"");
            template=StringUtils.replaceString(template,"$Author$",Author);
            template=StringUtils.replaceString(template,"$Editor$",Editor);
            template=StringUtils.replaceString(template,"$SourceFrom$",SourceFrom);
            template=StringUtils.replaceString(template,"$ModiTime$",DateUtil.getStringDate());
            template=StringUtils.replaceString(template,"$RelateLink$",RelateLink);
            template=LabelUtil.replaceAllLabel(template,CategoryId);
            //out.print(template);
            //滻ҳǩ
            String[] contentArr=Content.split("\\$PageSplit\\$");
            //ʼҳ
            int pageNums=contentArr.length;
            //ɷҳļ
            for(int i=0;i<pageNums;i++){
                String newstemp=template;
                //滻ҳǩ
                StringBuffer PageSplitLists=new StringBuffer(512);
                //ʼҳ
                for(int j=0;j<pageNums;j++){
                    if(j==0){
                        PageSplitLists.append("<a href=\""+rand+fileExt+"\">["+(j+1)+"]</a>\n");
                    }else{
                        PageSplitLists.append("<a href=\""+rand+"_"+j+fileExt+"\"");
                        if(j==i){
                            PageSplitLists.append(" class=\"currentpage\"");
                        }
                        PageSplitLists.append(">["+(j+1)+"]</a>\n");
                    }
                }
                String homelink=" <a href=\""+rand+fileExt+"\">ҳ</a> ";
                String taillink=" <a href=\""+rand+"_"+(pageNums-1)+fileExt+"\">βҳ</a> ";
                try{
                    if(pageNums==1){
                        newstemp=StringUtils.replaceString(newstemp,"$Content$",Content);
                        newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","");
                        FileUtil.createFile(newstemp,fileSavePath,"UTF-8");
                        DistributeUtil.send(SavePath, newstemp);
                    } else{
                        int prePage=i-1;
                        int nextPage=i+1;
                        if(i==0){
                            newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                            newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" һҳ "+PageSplitLists.toString()+" <a href=\""+rand+"_"+nextPage+fileExt+"\">һҳ</a> "+taillink+"</div>");
                        }
                        if(i==1){
                            if(pageNums==2){
                                newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                                newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" һҳ "+taillink+"</div>");
                            } else{
                                newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                                newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" <a href=\""+rand+"_"+nextPage+fileExt+"\">һҳ</a> "+taillink+"</div>");
                            }
                            
                        }
                        if(i==pageNums-1){
                            newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                            newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+"_"+prePage+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" һҳ "+taillink+"</div>");
                        } else{
                            newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                            newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+"_"+prePage+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" <a href=\""+rand+"_"+nextPage+fileExt+"\">һҳ</a> "+taillink+"</div>");
                        }
                        if(i==0){
                            FileUtil.createFile(newstemp,todayFolder+rand+fileExt,"UTF-8");
                            DistributeUtil.send("/html/"+todayStr+"/"+rand+fileExt, newstemp);
                        } else{
                            FileUtil.createFile(newstemp,todayFolder+rand+"_"+i+fileExt,"UTF-8");
                            DistributeUtil.send("/html/"+todayStr+"/"+rand+"_"+i+fileExt, newstemp);
                        }
                    }
                } catch(Exception e){
                    System.out.print("file write error "+e.getMessage());
                }
            }
        }
        //ӵ
        boolean bl=DaoFactory.getArticleDAO().addArticle(Title,SubHeading,TitleColor,KeyWords,RelateKey,RelateNum,Content,IsOutLink,OutLinkUrl,
                ParentId,CategoryId,TemplateId,SpecialId,Top1,ToTop,ToHot,Recommend,Images,Checked,Author,SourceFrom,Editor,
                UserName,Photo,Hits,SavePath,addtime,IsSlide,Summary);
        if(Copy2Category>0){
            DaoFactory.getArticleDAO().addArticle(Title,SubHeading,TitleColor,KeyWords,RelateKey,RelateNum,Content,1,Sysconfig.getSiteUrl()+SavePath,
                ParentId,Copy2Category,TemplateId,SpecialId,Top1,ToTop,ToHot,Recommend,Images,Checked,Author,SourceFrom,Editor,
                UserName,Photo,Hits,SavePath,addtime,IsSlide,Summary);
        }
        if(!bl) throw new ServletException("error on add article");
        //ӵ
        IndexWebHander.addIndexById(lastid);
        //
        Locale locale=request.getLocale();
        out.println("<fieldset>");
        out.println("<legend>"+ResourceBundleUtil.getString(locale,"totcms.admin.article.add.msg.ifsend")+":</legend><br />");
        out.println("<div align=\"center\">");
        out.println("<input type=\"button\" name=\"button1\" value=\" "+ResourceBundleUtil.getString(locale,"totcms.common.yes")+" \" onClick=\"javascript:location.href='send.jsp?categoryid="+ParentId+"&currentid="+CategoryId+"'\">&nbsp;");
        out.println("<input type=\"button\" name=\"button2\" value=\" "+ResourceBundleUtil.getString(locale,"totcms.common.no")+" \" onClick=\"javascript:location.href='article_manage.jsp'\">");
        out.println("</div>");
        out.println("</fieldset><br>");
        out.println("<fieldset>");
        out.println("<legend>"+ResourceBundleUtil.getString(locale,"totcms.common.nextstep")+"</legend>");
        out.println("<div align=\"center\">");
        out.println("<input type=button value=' "+ResourceBundleUtil.getString(locale,"totcms.common.back")+" ' onclick='history.back()'> &nbsp;");
        out.println("<input type=\"button\" name=\"Submit2\" value=\""+ResourceBundleUtil.getString(locale,"totcms.admin.article.add.msg.goonadd")+"\" style=\"font-size:12px\" onClick=\"location.href='article_add.jsp?CategoryId="+CategoryId+"'\"><br>");
        out.println("</div>");
        out.println("</fieldset><br />");
        out.println("<fieldset>");
        out.println("<legend>"+ResourceBundleUtil.getString(locale,"totcms.admin.article.add.msg.editcontent")+"</legend>");
        out.println(Content);
        out.println("</fieldset>");
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
