/*
 * ArticleAdd.java
 *
 * Created on 2006921, 10:12
 */

package tot.servlet;
import tot.util.*;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.bean.DataField;
import tot.exception.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 *
 * @author totcms
 * @version 1.0
 */
public class ArticleReset extends HttpServlet {
    ServletContext sc;
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        sc=config.getServletContext();
    }
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        request.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        HttpSession session=request.getSession();
        String admin=null;
        String haspriv=null;
        int id=RequestUtil.getInt(request,"id");
        DataField df=DaoFactory.getArticleDAO().getArticle(id);
        
        if(session.getAttribute("admin")!=null){
            admin=(String)session.getAttribute("admin");
        }
        if(session.getAttribute("role")!=null){
            haspriv=(String)session.getAttribute("role");
        }
        if(admin==null || haspriv==null){
            response.sendRedirect("login.jsp");
        }
        if(DateUtil.isExpire())
            throw new ServletException("System get error");
        //²
        if(df!=null){
            int CategoryId=Integer.parseInt(df.getFieldValue("CategoryId"));
            int ParentId=DaoFactory.getCategoryDAO().getParentId(CategoryId);
            if(!DaoFactory.getAdminDAO().ifHasPrivilege(haspriv,"p03"+CategoryId))
                throw new ServletException("you don't have privilege");
            String currentPath=sc.getRealPath("/");
            String SavePath=df.getFieldValue("SavePath");
            String[] tempArr=SavePath.split("/");
            String fileName=tempArr[tempArr.length-1];
            String todayStr=tempArr[tempArr.length-2];
            String rand=fileName.substring(0,fileName.indexOf("."));
            String separator=FileUtil.getSeparator();//ļзָ
            String todayFolder=currentPath+"html"+separator+todayStr+separator;//ļ
            //ļ
            FileUtil.createDir(todayFolder,true);
            String fileExt=Sysconfig.getFileExt();//ļչ
            String fileSavePath=todayFolder+fileName;//ļɵַ
            //ȡWEB
            String Title=df.getFieldValue("Title");
            String SubHeading=df.getFieldValue("SubHeading");
            String TitleColor=df.getFieldValue("TitleColor");
            String KeyWords=df.getFieldValue("KeyWords");
            if(KeyWords==null) KeyWords="";
            String RelateKey=df.getFieldValue("RelateKey");
            if(RelateKey==null)
                RelateKey="";
            //String[] RelateArr=RelateKey.split(",");
            int RelateNum=Integer.parseInt(df.getFieldValue("RelateNum"));
            String Content=df.getFieldValue("Content");
            String Summary=df.getFieldValue("Summary");
            int IsOutLink=Integer.parseInt(df.getFieldValue("IsOutLink"));
            String OutLinkUrl=df.getFieldValue("OutLinkUrl");
            int TemplateId=Integer.parseInt(df.getFieldValue("TemplateId"));
            int SpecialId=Integer.parseInt(df.getFieldValue("SpecialId"));
            int Top1=Integer.parseInt(df.getFieldValue("Top1"));
            int ToTop=Integer.parseInt(df.getFieldValue("ToTop"));
            int ToHot=Integer.parseInt(df.getFieldValue("ToHot"));
            int Recommend=Integer.parseInt(df.getFieldValue("Recommend"));
            int Images=Integer.parseInt(df.getFieldValue("Images"));
            int Checked=Integer.parseInt(df.getFieldValue("Checked"));
            String Author=df.getFieldValue("Author");
            String SourceFrom=df.getFieldValue("SourceFrom");
            String Editor=df.getFieldValue("Editor");
            String UserName=(String)session.getAttribute("admin");
            String Photo=df.getFieldValue("Photo");
            int Hits=Integer.parseInt(df.getFieldValue("Hits"));
            String ModDate=df.getFieldValue("ModDate");
            Timestamp addtime=DateUtil.getCurrentGMTTimestamp();
            int lastid=id;
            //ȡģ
            String template=DaoFactory.getTemplateDAO().getContent(TemplateId);
            if(template==null) throw new ServletException("template is null(id:"+TemplateId+")");
            //out.print(template);
            //ȡ
            String RelateLink=DaoFactory.getArticleDAO().getRelate(RelateKey,RelateNum,true);
            //滻ģ
            template=StringUtils.replaceString(template,"$Title$",Title);
            template=StringUtils.replaceString(template,"$SubHeading$",SubHeading);
            template=StringUtils.replaceString(template,"$Summary$",Summary);
            template=StringUtils.replaceString(template,"$KeyWords$",KeyWords);
            template=StringUtils.replaceString(template,"$id$",lastid+"");
            template=StringUtils.replaceString(template,"$Author$",Author);
            template=StringUtils.replaceString(template,"$Editor$",Editor);
            template=StringUtils.replaceString(template,"$SourceFrom$",SourceFrom);
            //template=StringUtils.replaceString("$ModiTime$",addtime.toString());
            template=StringUtils.replaceString(template,"$ModiTime$",ModDate);
            template=StringUtils.replaceString(template,"$RelateLink$",RelateLink);
            template=LabelUtil.replaceAllLabel(template,CategoryId);
            //out.print(template);
            //滻ҳǩ
            String[] contentArr=Content.split("\\$PageSplit\\$");            
            //ʼҳ
            int pageNums=contentArr.length;            
            for(int i=0;i<pageNums;i++){
                String newstemp=template;
                //滻ҳǩ
                StringBuffer PageSplitLists=new StringBuffer(512);
                //ʼҳ
                for(int j=0;j<pageNums;j++){
                    if(j==0){
                        PageSplitLists.append("<a href=\""+rand+fileExt+"\">["+(j+1)+"]</a>\n");
                    }else{
                        PageSplitLists.append("<a href=\""+rand+"_"+j+fileExt+"\"");
                        if(j==i){
                            PageSplitLists.append(" class=\"currentpage\"");
                        }
                        PageSplitLists.append(">["+(j+1)+"]</a>\n");
                    }
                }
                String homelink=" <a href=\""+rand+fileExt+"\">ҳ</a> ";
                String taillink=" <a href=\""+rand+"_"+(pageNums-1)+fileExt+"\">βҳ</a> ";
                try{
                    if(pageNums==1){
                        newstemp=StringUtils.replaceString(newstemp,"$Content$",Content);
                        newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","");
                        FileUtil.createFile(newstemp,fileSavePath,"UTF-8");
                        out.print("<br>Create a file "+fileSavePath);
                        DistributeUtil.send(SavePath, newstemp);
                    } else{
                        int prePage=i-1;
                        int nextPage=i+1;
                        if(i==0){
                            newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                            newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" һҳ "+PageSplitLists.toString()+" <a href=\""+rand+"_"+nextPage+fileExt+"\">һҳ</a> "+taillink+"</div>");
                        }
                        if(i==1){
                            if(pageNums==2){
                                newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                                newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" һҳ "+taillink+"</div>");
                            } else{
                                newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                                newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" <a href=\""+rand+"_"+nextPage+fileExt+"\">һҳ</a> "+taillink+"</div>");
                            }
                            
                        }
                        if(i==pageNums-1){
                            newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                            newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+"_"+prePage+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" һҳ "+taillink+"</div>");
                        } else{
                            newstemp=StringUtils.replaceString(newstemp,"$Content$",contentArr[i]);
                            newstemp=StringUtils.replaceString(newstemp,"$PageSplitList$","<div class=\"PageSplits\">"+homelink+" <a href=\""+rand+"_"+prePage+fileExt+"\">һҳ</a> "+PageSplitLists.toString()+" <a href=\""+rand+"_"+nextPage+fileExt+"\">һҳ</a> "+taillink+"</div>");
                        }
                        if(i==0){
                            FileUtil.createFile(newstemp,todayFolder+rand+fileExt,"UTF-8");
                            out.print("<br>Create first file "+todayFolder+rand+fileExt);
                            DistributeUtil.send("/html/"+todayStr+"/"+rand+fileExt, newstemp);
                        } else{
                            FileUtil.createFile(newstemp,todayFolder+rand+"_"+i+fileExt,"UTF-8");
                            out.print("<br>Create files "+todayFolder+rand+"_"+i+fileExt);
                            DistributeUtil.send("/html/"+todayStr+"/"+rand+"_"+i+fileExt, newstemp);
                        }
                    }
                } catch(Exception e){
                    System.out.print("file write error "+e.getMessage());
                }
            }
            //
            out.println("<br>Send article by id:"+id+"<br>\n");
            out.close();
        }
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
