/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tot.servlet;

import java.io.*;
import java.net.*;
import java.sql.Timestamp;

import javax.servlet.*;
import javax.servlet.http.*;

import tot.util.*;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.exception.*;
import tot.bean.DataField;

/**
 *
 * @author Administrator
 */
public class DownFile extends HttpServlet {

    /** 
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        //PrintWriter out = response.getWriter();
        ServletOutputStream out =response.getOutputStream();
        HttpSession session = request.getSession();
        try {
            /* TODO output your page here            
             */
            String userid = CookieUtil.getCookieValue(request.getCookies(), "totjcms_userid", null);
            if (userid == null) {
                userid = (String) session.getAttribute("totjcms_userid");
            }
            int id = RequestUtil.getInt(request, "id");
            int chapter = RequestUtil.getInt(request, "chapter");
            DataField video = DaoFactory.getEduDownloadDAO().get(id);
            if (video != null && userid != null) {
                int info = Integer.parseInt(video.getFieldValue("InfoType"));
                float money = Float.parseFloat(video.getFieldValue("NeedMoney"));
                float usermoney = DaoFactory.getMemberDAO().getMoney(userid);
                int isfree = Integer.parseInt(video.getFieldValue("IsFree"));
                int isdownload = Integer.parseInt(video.getFieldValue("IsDownload"));
                int pubserverid = Integer.parseInt(video.getFieldValue("PubServerId"));
                DataField pubserver = DaoFactory.getPubServerDAO().get(pubserverid);
                String downurl = pubserver.getFieldValue("DownUrl");
                //out.print(info+":"+money+"free:"+isfree+"usermoney:"+usermoney);
                String filetype = video.getFieldValue("Vtype");
                String furls[] = video.getFieldValue("Vurl").split(",");
                String fileurl = "";
                if (chapter > 0 && furls.length > chapter) {
                    fileurl = furls[chapter];
                } else {
                    fileurl = furls[0];
                }
                fileurl = downurl + fileurl;
                String filename = fileurl.substring(fileurl.lastIndexOf("/") + 1);
                boolean chstatus = false;
                if (isdownload == 1)//Ƶ
                {
                    String cookiestr = CookieUtil.getCookieValue(request.getCookies(), "totjcms_edudown_" + id + "_" + chapter, null);
                    if (isfree == 1 && cookiestr == null) {//۷
                        if (furls.length != 1 && chapter == 0) {//һ
                            chstatus = true;
                        } else {//ʼۿ
                            if (usermoney < money) {
                                out.print("<script>alert('!Ҫ[" + money + "]\\n뾡ʻֵ.');window.close();</script>");
                                chstatus = false;
                            } else {
                                //
                                Timestamp addtime = DateUtil.getCurrentGMTTimestamp();
                                String sp_billno = DateUtil.getStringDateNum() + StringUtils.getRandomNumber(2, 99);
                                DaoFactory.getTransactionDAO().addTransaction(2, money, userid, "system", addtime, 0, video.getFieldValue("Title"), request.getHeader("Referer"), "VOD㲥", sp_billno);
                                try {
                                    DaoFactory.getMemberDAO().updateMoney(userid, (0 - money));//֧
                                } catch (Exception e) {
                                }
                                chstatus = true;
                            }
                        }//ۿ

                    } else {
                        chstatus = true;
                    }
                    if (chstatus) {
                        
                        URL url = null;
                        InputStream is = null;
                        int content_length=0;
                        try {
                            url = new URL(fileurl);
                            URLConnection connection = url.openConnection();
                            connection.connect();
                            content_length=connection.getContentLength();
                        } catch (MalformedURLException e) {

                        }
                        try {
                            is = url.openStream();
                        } catch (IOException e) {

                        }
                        if (is != null) {
                            //---------------------------------------------------------------
                            // Set the output data's mime type
                            //---------------------------------------------------------------
                            response.setContentType("application/octet-stream");
                            response.setHeader("Content-disposition", "attachment; filename=" + new String(filename.getBytes(), "iso8859-1"));
                            response.setContentLength(content_length);
                            BufferedInputStream inputStream = null;
                            BufferedOutputStream outputStream = null;
                            byte[] block = new byte[1024];
                            try {
                                inputStream = new BufferedInputStream(is);
                                outputStream = new BufferedOutputStream(out);
                                while (true) {
                                    int readLength = inputStream.read(block);
                                    if (readLength == -1) {
                                        break;
                                    }// end of file
                                    outputStream.write(block, 0, readLength);
                                }
                                out.flush();
                            } catch (IOException e) {

                            } finally {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    } catch (IOException ex) {
                                    // just ignore
                                    }
                                }
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    } catch (IOException ex) {
                                    // just ignore
                                    }
                                }
                            }
                        }
                        CookieUtil.setCookie(response, "totjcms_edudown_" + id + "_" + chapter, userid, 3600*24);
                    }
                }//
                video = null;
            } else if (userid == null) {
                out.print("<div align=\"center\">ûе¼ʱ!</div>");
            } else {
                out.print("error!Not find.");
            }
        } finally {
            out.close();
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet  + Ա༩롣">
    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
