/*
 * SendArticle.java
 *
 * Created on 2006115, 9:16
 */

package tot.servlet;

import tot.util.*;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.exception.*;
import tot.db.DBUtils;
import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author Administrator
 * @version 1.0
 */
public class SendArticle extends HttpServlet {
    private static Log log = LogFactory.getLog(SendArticle.class);
    ServletContext sc;
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        sc=config.getServletContext();
    }
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        request.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        //ݿ
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        //Ȩж
        HttpSession session=request.getSession();
        String admin=null;
        String haspriv=null;
        Locale locale=request.getLocale();
        if(session.getAttribute("admin")!=null){
            admin=(String)session.getAttribute("admin");
        }
        if(session.getAttribute("role")!=null){
            haspriv=(String)session.getAttribute("role");
        }
        if(admin==null || haspriv==null){
            response.sendRedirect("login.jsp");
        }
        if(!DaoFactory.getAdminDAO().ifHasPrivilege(haspriv,"p06"))
            throw new ServletException("you don't have privilege");
        //ȡ
        String by=RequestUtil.getString(request,"by");
        int interval=RequestUtil.getInt(request,"interval");
        int start=RequestUtil.getInt(request,"start");
        int id=RequestUtil.getInt(request,"id");
        if(id==0)
            id=DaoFactory.getArticleDAO().getLastId();
        //洦
        if(sc.getAttribute("totcms_reset_robot")==null)
            sc.setAttribute("totcms_reset_robot",0);
        if(sc.getAttribute("totcms_reset_total")==null)
            sc.setAttribute("totcms_reset_total",0);
        if(start==1)
            sc.setAttribute("totcms_reset_robot",0);
        String paraStr="by="+by+"&interval="+interval;
        //
        String sqlQuery="";
        int databaseType=DBUtils.getDatabaseType();
        int startId=0;
        int endId=0;
        
        //date
        Timestamp dateStart=null;
        Timestamp dateEnd=null;
        if(by.equalsIgnoreCase("all")){
            if (databaseType == DBUtils.DATABASE_SQLSERVER) {
                sqlQuery="select top 1 id from t_article where IsOutLink=0 and id<? order by id desc";
            }else if(databaseType == DBUtils.DATABASE_MYSQL){
                sqlQuery="select id from t_article where IsOutLink=0 and id<? order by id desc limit 0,1";
            }else if(databaseType==DBUtils.DATABASE_IMFORMIX){//imformix
                sqlQuery="select FIRST 1 id from t_article where IsOutLink=0 and id<? order by id desc";
            }else if(databaseType==DBUtils.DATABASE_ORACLE){//oracle
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and ROWNUM=1 order by id desc";
            }else if(databaseType==DBUtils.DATABASE_POSTGRESQL){//pgsql
                sqlQuery="select id from t_article where IsOutLink=0 and id<? order by id desc limit 1";
            }else if(databaseType==DBUtils.DATABASE_DB2){//db2
                sqlQuery="select id from t_article where IsOutLink=0 and id<? order by id desc fetch first 1 rows only";
            }
        }else if(by.equalsIgnoreCase("date")){
            String dateStartStr=RequestUtil.getString(request,"DateStart");
            String dateEndStr=RequestUtil.getString(request,"DateEnd");
            dateStart=new Timestamp(DateUtil.strToBirthday(dateStartStr).getTime());
            dateEnd=new Timestamp(DateUtil.strToBirthday(dateEndStr).getTime());
            paraStr=paraStr+"&DateStart="+dateStartStr+"&DateEnd="+dateEndStr;
            if (databaseType == DBUtils.DATABASE_SQLSERVER) {
                sqlQuery="select top 1 id from t_article where IsOutLink=0 and id<? and ModiTime>? and ModiTime<? order by id desc";
            }else if(databaseType == DBUtils.DATABASE_MYSQL){
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and ModiTime>? and ModiTime<? order by id desc limit 0,1";
            }else if(databaseType==DBUtils.DATABASE_IMFORMIX){//imformix
                sqlQuery="select FIRST 1 id from t_article where IsOutLink=0 and id<? and ModiTime>? and ModiTime<? order by id desc";
            }else if(databaseType==DBUtils.DATABASE_ORACLE){//oracle
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and ModiTime>? and ModiTime<? and ROWNUM=1 order by id desc";
            }else if(databaseType==DBUtils.DATABASE_POSTGRESQL){//pgsql
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and ModiTime>? and ModiTime<? order by id desc limit 1";
            }else if(databaseType==DBUtils.DATABASE_DB2){//db2
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and ModiTime>? and ModiTime<? order by id desc fetch first 1 rows only";
            }
        }else if(by.equalsIgnoreCase("id")){
            startId=RequestUtil.getInt(request,"StartId");
            endId=RequestUtil.getInt(request,"EndId");
            if(endId>id) endId=id;
            if(start==1){
                id=endId;
            }else{
                //id=id-1;
            }
            paraStr=paraStr+"&StartId="+startId+"&EndId="+endId;
            if (databaseType == DBUtils.DATABASE_SQLSERVER) {
                sqlQuery="select top 1 id from t_article where IsOutLink=0 and id<? and id>? order by id desc";
            }else if(databaseType == DBUtils.DATABASE_MYSQL){
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and id>? order by id desc limit 0,1";
            }else if(databaseType==DBUtils.DATABASE_IMFORMIX){//imformix
                sqlQuery="select FIRST 1 id from t_article where IsOutLink=0 and id<? and id>? order by id desc";
            }else if(databaseType==DBUtils.DATABASE_ORACLE){//oracle
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and id>? and ROWNUM=1 order by id desc";
            }else if(databaseType==DBUtils.DATABASE_POSTGRESQL){//pgsql
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and id>? order by id desc limit 1";
            }else if(databaseType==DBUtils.DATABASE_DB2){//db2
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and id>? order by id desc fetch first 1 rows only";
            }
        }else if(by.equalsIgnoreCase("template")){
            int templateid=RequestUtil.getInt(request,"TemplateId");            
            paraStr=paraStr+"&TemplateId="+templateid;
            if (databaseType == DBUtils.DATABASE_SQLSERVER) {
                sqlQuery="select top 1 id from t_article where IsOutLink=0 and id<? and TemplateId="+templateid+" order by id desc";
            }else if(databaseType == DBUtils.DATABASE_MYSQL){
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and TemplateId="+templateid+" order by id desc limit 0,1";
            }else if(databaseType==DBUtils.DATABASE_IMFORMIX){//imformix
                sqlQuery="select FIRST 1 id from t_article where IsOutLink=0 and id<? and TemplateId="+templateid+" order by id desc";
            }else if(databaseType==DBUtils.DATABASE_ORACLE){//oracle
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and TemplateId="+templateid+" and ROWNUM=1 order by id desc";
            }else if(databaseType==DBUtils.DATABASE_POSTGRESQL){//pgsql
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and TemplateId="+templateid+" order by id desc limit 1";
            }else if(databaseType==DBUtils.DATABASE_DB2){//db2
                sqlQuery="select id from t_article where IsOutLink=0 and id<? and TemplateId="+templateid+" order by id desc fetch first 1 rows only";
            }
        }
        String sqlCount="select count(*) from t_article where IsOutLink=0";
        if(by!=null && start==1){
            if(by.equalsIgnoreCase("all")){
                int totalNum=DaoFactory.getArticleDAO().getTotalCount(0);
                if(totalNum==0)
                    totalNum=1;
                sc.setAttribute("totcms_reset_total",totalNum);
            } else if(by.equalsIgnoreCase("date")){
                int totalNum=0;
                if (databaseType == DBUtils.DATABASE_SQLSERVER) {
                    sqlCount="select count(*) from t_article where IsOutLink=0 and ModiTime>? and ModiTime<?";
                }else if(databaseType == DBUtils.DATABASE_MYSQL){
                    sqlCount="select count(*) from t_article where IsOutLink=0 and ModiTime>? and ModiTime<?";
                }else if(databaseType==DBUtils.DATABASE_IMFORMIX){//imformix
                    sqlCount="select count(*) from t_article where IsOutLink=0 and ModiTime>? and ModiTime<?";
                }else if(databaseType==DBUtils.DATABASE_ORACLE){//oracle
                    sqlCount="select count(*) from t_article where IsOutLink=0 and ModiTime>? and ModiTime<?";
                }else if(databaseType==DBUtils.DATABASE_POSTGRESQL){//pgsql
                    sqlCount="select count(*) from t_article where IsOutLink=0 and ModiTime>? and ModiTime<?";
                }else if(databaseType==DBUtils.DATABASE_DB2){//db2
                    sqlCount="select count(*) from t_article where IsOutLink=0 and ModiTime>? and ModiTime<?";
                }
                try{
                    conn = DBUtils.getConnection();
                    ps=conn.prepareStatement(sqlCount);
                    ps.setTimestamp(1,dateStart);
                    ps.setTimestamp(2,dateEnd);
                    rs=ps.executeQuery();
                    if(rs.next()){
                        totalNum=rs.getInt(1);
                    }
                }catch(SQLException e){                    
                } finally{
                    DBUtils.closeResultSet(rs);
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                }
                if(totalNum==0)
                    totalNum=1;
                sc.setAttribute("totcms_reset_total",totalNum);
            }else if(by.equalsIgnoreCase("id")){                
                sqlCount="select count(*) from t_article where IsOutLink=0 and id>"+startId+" and id<"+endId;
                int totalNum=DaoFactory.getArticleDAO().getDataCount(sqlCount);
                if(totalNum==0)
                    totalNum=1;
                sc.setAttribute("totcms_reset_total",totalNum);
            }else if(by.equalsIgnoreCase("template")){     
                int templateid=RequestUtil.getInt(request,"TemplateId");
                sqlCount="select count(*) from t_article where IsOutLink=0 and TemplateId="+templateid;
                int totalNum=DaoFactory.getArticleDAO().getDataCount(sqlCount);
                if(totalNum==0)
                    totalNum=1;
                sc.setAttribute("totcms_reset_total",totalNum);
            }
        }
        //ȡݿ
        boolean hasNext=false;
        //log.info(sqlQuery);
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sqlQuery);
            ps.setInt(1,id);
            if(by.equalsIgnoreCase("date")){
                ps.setTimestamp(2,dateStart);
                ps.setTimestamp(3,dateEnd);
            }else if(by.equalsIgnoreCase("id")){
                ps.setInt(2,startId);
            }
            rs=ps.executeQuery();
            if(rs.next()){
                id=rs.getInt(1);
                hasNext=true;
                sc.setAttribute("totcms_reset_robot",(Integer)sc.getAttribute("totcms_reset_robot")+1);
            }else{
                hasNext=false;
            }
        } catch(SQLException e){
            log.error("get last id",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        //
        int sendPercent=((Integer)sc.getAttribute("totcms_reset_robot")*100)/(Integer)sc.getAttribute("totcms_reset_total");
        out.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
        out.print("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        out.print("<head>\n");
        out.print("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
        if(hasNext){
            out.print("<meta http-equiv=\"refresh\" content=\""+interval+";URL=?"+paraStr+"&id="+id+"\">\n");
        }
        out.print("<title>send article</title>\n");
        out.print("</head>\n");
        out.print("<body>\n");
        if(hasNext){
            out.print("<table width=\"400\" height=\"20\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#D4D0C8\" bgcolor=\"#FFFFFF\">\n");
            out.print("<tr>\n");
            out.print("<td>\n");
            out.print("<table id=\"stat_w\" style=\"width:1%;\" border=\"0\" align=\"left\" cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#003399\">\n");
            out.print("<tr>\n");
            out.print("<td>&nbsp;</td>\n");
            out.print("</tr>\n");
            out.print("</table>\n");
            out.print("<span class=\"style1\" id=\"P_num\"></span></td>\n");
            out.print("</tr>\n");
            out.print("</table>\n");
            out.print("<br>"+ResourceBundleUtil.getString(locale,"totcms.admin.send.msg.nowstatus")+":"+sc.getAttribute("totcms_reset_total")+"/"+sc.getAttribute("totcms_reset_robot")+"\n");
            out.print("<script src=\"js/xmlhttp_utf8.js\" type=\"text/javascript\"></script>\n");
            // ajax vbs
            out.print("<script type=\"text/javascript\" language=\"javascript\">\n");
            out.print("var HTTP;\n");
            out.print("function CallServer(Url)\n");
            out.print("{\n");
            out.print("	HTTP=getXMLRequester();\n");
            out.print("	HTTP.onreadystatechange = doAction;\n");
            out.print("	var ReturnValue=HTTP.open(\"POST\",Url,true);\n");
            out.print("	HTTP.send(\"\");\n");
            out.print("	return HTTP.responseText;\n");
            out.print("}\n");
            out.print("function doAction() {\n");
            out.print("        if (HTTP.readyState == 4)\n");
            out.print("		{\n");
            out.print("			if (HTTP.status == 500) {\n");
            out.print("				//alert(\"Get error on publish aritlce by id:"+id+"!\");		\n");
            out.print("\n");
            out.print("            }\n");
            out.print("            else if (HTTP.status == 200) {\n");
            out.print("				//document.write(HTTP.responseText);\n");
            //out.print("				document.write(\"id:\"+"+id+"+\"<br>\");\n");
            out.print("				document.getElementById('stat_w').style.width =\""+sendPercent+"%\";\n");
            out.print("				document.getElementById('P_num').innerHTML =\""+sendPercent+"%\";\n");
            out.print("            } \n");
            out.print("			else {\n");
            out.print("                alert(HTTP.status);\n");
            out.print("            }\n");
            out.print("        }\n");
            out.print("}\n");
            out.print("function resetHtml()\n");
            out.print("{\n");
            out.print("	var ReturnValue;	\n");
            out.print("	ReturnValue=CallServer('ArticleReset?id="+id+"');\n");
            out.print("	document.write(ReturnValue);\n");
            out.print("}\n");
            out.print("resetHtml();\n");
            out.print("</script>\n");
        } else{
            out.print(ResourceBundleUtil.getString(locale,"totcms.admin.send.msg.sucsend")+":"+sc.getAttribute("totcms_reset_robot"));
        }
        out.print("</body>\n");
        out.print("</html>\n");
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
