/*
 * SendCategory.java
 *
 * Created on 20061022, 9:08
 */

package tot.servlet;
import tot.util.*;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.exception.*;
import tot.bean.DataField;
import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 * @version 1.0
 */
public class SendCategory extends HttpServlet {
    private static Log log = LogFactory.getLog(SendCategory.class);
    ServletContext sc;
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        sc=config.getServletContext();
    }
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        HttpSession session=request.getSession();
        String admin=null;
        String haspriv=null;
        int isChannel=0;
        int parentId=0;
        String savePath="";
        String template="";
        Locale locale=request.getLocale();
        int CategoryId=RequestUtil.getInt(request,"CategoryId");
        int NumPerPage=RequestUtil.getInt(request,"NumPerPage");
        if(session.getAttribute("admin")!=null){
            admin=(String)session.getAttribute("admin");
        }
        if(session.getAttribute("role")!=null){
            haspriv=(String)session.getAttribute("role");
        }
        if(admin==null || haspriv==null){
            response.sendRedirect("login.jsp");
        }
        if(!DaoFactory.getAdminDAO().ifHasPrivilege(haspriv,"p06"))
            throw new ServletException("you don't have privilege");
        if(CategoryId<0 || NumPerPage<0)
            throw new ServletException("CategoryId and NumPerPage must not less than zero");
        DataField df=DaoFactory.getCategoryDAO().getCategory(CategoryId);
        if(df!=null){
            isChannel=Integer.parseInt(df.getFieldValue("IsChannel"));
            parentId=Integer.parseInt(df.getFieldValue("ParentId"));
            savePath=df.getFieldValue("SavePath");
            template=df.getFieldValue("Template");
        }
        //ϵͳ
        String currentPath=sc.getRealPath("/");
        savePath=currentPath+savePath;
        template=currentPath+template;
        //ļ
        FileUtil.createDir(savePath,true);
        if(isChannel==0){
            createCategoryList(locale,CategoryId,NumPerPage,savePath,template);
        }
        else{
            
        }
        out.close();
    }
    /**
     * create category list file
     */
    public void createCategoryList(Locale locale,int categoryId,int pagesizes,String savePath,String template){
        int totalnum=0;
        int pagenum=0;
        int maxPageNum=Sysconfig.getPageSendMaxNum();
        totalnum=DaoFactory.getArticleDAO().getTotalCount(categoryId);
        String templateContent="";
        if(totalnum!=0){
            pagenum=(totalnum+pagesizes-1)/pagesizes;//ҳ
            if(pagenum<1){
                pagenum=1;
            }
            if(pagenum>maxPageNum){
                pagenum=maxPageNum;
            }
            //ȡģ
            try{
                templateContent=FileUtil.readFile(template,"UTF-8");
            } catch(Exception e){
                log.error("Can't find template file:"+template);
            }
            String diagonal=FileUtil.getSeparator();
            //ʼҳļ-------------------------------------------
            for(int i=1;i<=pagenum;i++){
                StringBuffer newsliststr=new StringBuffer(512);
                String showpagestr="";
                showpagestr=showPage(locale,i,totalnum,pagenum);
                ArrayList list=(ArrayList)DaoFactory.getArticleDAO().getArticleList_Limit(categoryId,i,pagesizes);
                newsliststr.append("<table>\n");
                for (Iterator iter = list.iterator(); iter.hasNext(); ) {
                    DataField df=(DataField)iter.next();
                    newsliststr.append("<tr><td>");
                    newsliststr.append(df.getFieldValue("Title"));
                    newsliststr.append("</td></tr>");
                }
                newsliststr.append("</table>");
                //滻ģ
                String Temptemplatecontent=templateContent;                
                Temptemplatecontent=Temptemplatecontent.replaceAll("\\$ArticleList\\$",newsliststr.toString());
                if(i==maxPageNum){
                    Temptemplatecontent=Temptemplatecontent.replaceAll("\\$ShowPage\\$","[<a href=\"index_"+(i-1)+".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\""+Sysconfig.getContextPath()+"more.jsp?catalogid="+categoryId+"\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;");
                } else{
                    Temptemplatecontent=Temptemplatecontent.replaceAll("\\$ShowPage\\$",showpagestr);
                }
                Temptemplatecontent=LabelUtil.replaceAllLabel(Temptemplatecontent,categoryId);
                //дݵļ
                //logger.debug("write template file:"+Temptemplatecontent+" "+logger.getName());
                FileUtil.createFile(Temptemplatecontent,savePath+diagonal+"index_"+i+".htm","UTF-8"); 
                log.info("create file:"+savePath+diagonal+"index_"+i+".htm"+"success ");
            }
            //бҳ-------------------------------------------------
        }         
    }
    public String showPage(Locale locale,int currentpage,int totalnum,int pagenum){
        int prepage=0,nextpage=0;
        String returnStr="";
        prepage=currentpage-1;
        nextpage=currentpage+1;
        if (currentpage>1){
            returnStr=returnStr+"["+"<a href='index_"+prepage+".htm'>"+ResourceBundleUtil.getString(locale,"totcms.common.previous")+"</a>]&nbsp;&nbsp;&nbsp;";
        } else{
            returnStr=returnStr+"["+ResourceBundleUtil.getString(locale,"totcms.common.previous")+"]&nbsp;&nbsp;&nbsp;";
        }
        if (currentpage>=pagenum){
            returnStr=returnStr+"["+ResourceBundleUtil.getString(locale,"totcms.common.next")+"]";
        } else{
            returnStr=returnStr+"["+"<a href='index_"+nextpage+".htm'>"+ResourceBundleUtil.getString(locale,"totcms.common.next")+"</a>]&nbsp;&nbsp;&nbsp;";
        }
        returnStr=returnStr+"&nbsp;"+ResourceBundleUtil.getString(locale,"totcms.common.total")+":"+totalnum;
        returnStr=returnStr+"&nbsp;"+pagenum+"/";
        returnStr=returnStr+"&nbsp;"+currentpage;
        return returnStr;
    }
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
