/*
 * VoteChart.java
 *
 * Created on 200637, 5:14
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.util;
import java.awt.Insets;
import java.awt.Font;
import java.awt.Color;
import java.io.PrintWriter;
import javax.servlet.http.HttpSession;
import org.jfree.data.general.*;
import org.jfree.data.category.*;
import org.jfree.chart.*;
import org.jfree.chart.title.*;
import org.jfree.chart.plot.*;
import org.jfree.chart.entity.*;
import org.jfree.chart.urls.*;
import org.jfree.chart.axis.*;
import org.jfree.chart.servlet.*;
import org.jfree.chart.labels.*;
import org.jfree.chart.renderer.category.BarRenderer;

/**
 * @author tot
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ChartUtil {
    private DefaultPieDataset piedata = new DefaultPieDataset();
    private DefaultCategoryDataset bardata=new DefaultCategoryDataset();
    public void setPieValue(String key,double value){
        piedata.setValue(key,value);
    }
    public void setBarValue(double value,String row,String col){
        bardata.addValue(value,row,col);
    }
    /** ɱ״ͼ */
    public String generatePieChart(String title,HttpSession session,PrintWriter pw,String url) {
        String filename = null;
        try {
            //chart
            PiePlot plot = new PiePlot(piedata);
            //ͳͼƬϽ
            //plot.setURLGenerator(new StandardPieURLGenerator(url,"category"));
            plot.setToolTipGenerator(new StandardPieToolTipGenerator());
            plot.setNoDataMessage("No data available");
            plot.setExplodePercent(1, 0.5D);
            plot.setLabelGenerator(new StandardPieSectionLabelGenerator("{0} ({2})"));
            JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT,plot, true);
            
            chart.setBackgroundPaint(java.awt.Color.white);//ͼƬıɫ
            
            Font font = new Font("",Font.CENTER_BASELINE,20);//ͼƬʹС            
            TextTitle _title = new TextTitle(title);
            _title.setFont(font);
            chart.setTitle(_title);            
            //ɵͼƬŵʱĿ¼
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            //500ͼƬȣ300ͼƬ߶
            filename = ServletUtilities.saveChartAsPNG(chart, 500, 300, info,session);
            ChartUtilities.writeImageMap(pw,filename,info,true);
            pw.flush();
        } catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }
    /** 3D״ͼ */
    public String generate3dPieChart(String title,HttpSession session,PrintWriter pw,String url) {
        String filename = null;
        try {
            //chart
            PiePlot plot = new PiePlot(piedata);
            //ͳͼƬϽ
            plot.setURLGenerator(new StandardPieURLGenerator(url,"category"));
            plot.setToolTipGenerator(new StandardPieToolTipGenerator());
            //JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT,plot, true);
            JFreeChart chart = ChartFactory.createPieChart3D("",piedata, true,false,false);
            PiePlot pie = (PiePlot)chart.getPlot();
            //趨ٷֱʾʽ
            pie.setBackgroundPaint(Color.white);
            //趨͸ȣ0-1.0֮䣩
            pie.setBackgroundAlpha(0.6f);
            //趨ǰ͸ȣ0-1.0֮䣩
            pie.setForegroundAlpha(0.90f);
            
            chart.setBackgroundPaint(java.awt.Color.white);//ͼƬıɫ
            
            Font font = new Font("",Font.CENTER_BASELINE,20);//ͼƬʹС
            TextTitle _title = new TextTitle(title);
            _title.setFont(font);
            chart.setTitle(_title);
            
            //ɵͼƬŵʱĿ¼
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            //500ͼƬȣ300ͼƬ߶
            filename = ServletUtilities.saveChartAsPNG(chart, 500, 300, info,session);
            ChartUtilities.writeImageMap(pw,filename,info,true);
            pw.flush();
        } catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }
    /**״ͼ */
    public String generateBarChart(String title,HttpSession session, PrintWriter pw,String url) {
        String filename = null;
        try {
            //  Create the chart object
            CategoryAxis categoryAxis = new CategoryAxis("");
            ValueAxis valueAxis = new NumberAxis("");
            BarRenderer renderer = new BarRenderer();
            //renderer.setItemURLGenerator(new StandardCategoryURLGenerator(url,"series","category"));
            renderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());
            //CategoryPlot plot =new CategoryPlot();
            CategoryPlot plot = new CategoryPlot(bardata,categoryAxis,valueAxis,renderer);
            JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
            chart.setBackgroundPaint(java.awt.Color.white);
            Font font = new Font("",Font.CENTER_BASELINE,20);//ͼƬʹС
            TextTitle _title = new TextTitle(title);
            _title.setFont(font);
            chart.setTitle(_title);
            //  Write the chart image to the temporary directory
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            filename = ServletUtilities.saveChartAsPNG(chart,bardata.getColumnCount()*100, 300, info, session);
            
            //  Write the image map to the PrintWriter
            ChartUtilities.writeImageMap(pw, filename, info,true);
            pw.flush();
            
        } catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }
    /* 3d ״ͼ */
    public String generate3dBarChart(String title,HttpSession session, PrintWriter pw,String url) {
        String filename = null;
        try {
            //  Create the chart object
            CategoryAxis categoryAxis = new CategoryAxis("");
            ValueAxis valueAxis = new NumberAxis("");
            BarRenderer renderer = new BarRenderer();           
            
            //////////////////////////////////////////////
            JFreeChart jfreechart = ChartFactory.createBarChart3D(title, "", "ֵ", bardata, PlotOrientation.HORIZONTAL, true, true, false);
            CategoryPlot categoryplot = jfreechart.getCategoryPlot();
            categoryplot.setForegroundAlpha(1.0F);
            //CategoryAxis categoryaxis = categoryplot.getDomainAxis();
            //CategoryLabelPositions categorylabelpositions = categoryaxis.getCategoryLabelPositions();
            //CategoryLabelPosition categorylabelposition = new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, 0.0D, CategoryLabelWidthType.RANGE, 0.3F);
            //categoryaxis.setCategoryLabelPositions(CategoryLabelPositions.replaceLeftPosition(categorylabelpositions, categorylabelposition));
            
            
            ////////////////////////////////////////////
            //  Write the chart image to the temporary directory
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            filename = ServletUtilities.saveChartAsPNG(jfreechart,700, 300, info, session);
            
            //  Write the image map to the PrintWriter
            ChartUtilities.writeImageMap(pw, filename, info,true);
            pw.flush();
            
        } catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }
}

