/*
 * EmailUtil.java
 *
 * Created on 2008323, 2:21
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.util;
import tot.exception.BadInputException;
import tot.global.Sysconfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.*;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.URL;
import java.util.*;
import javax.mail.*;
import javax.mail.Flags.Flag;
import javax.mail.internet.*;
import javax.naming.InitialContext;
import javax.naming.NamingException;
/**
 *
 * @author Administrator
 */
public class EmailUtil {
    private static Log log = LogFactory.getLog(EmailUtil.class);
    public static final int MAX_MESSAGES_PER_TRANSPORT = 100;
    /** Creates a new instance of EmailUtil */
    public EmailUtil() {
    }
    /**
     * Get the user name part of an email. Ex: input: test@yahoo.com => output: test
     * @param email String the email
     * @return String the user name part of an email
     */
    public static String getEmailUsername(String email) {
        if (email == null) return "";
        int atIndex = email.indexOf('@');
        if (atIndex == -1) {
            return "";
        }
        return email.substring(0, atIndex);
    }
    /**
     * Get the domain part of an email. Ex: input: test@yahoo.com => output: yahoo.com
     * @param email String the email
     * @return String the user name part of an email
     */
    public static String getEmailDomain(String email) {
        if (email == null) return "";
        int atIndex = email.indexOf('@');
        if (atIndex == -1) {
            return "";
        }
        return email.substring(atIndex + 1);
    }
    /**
     * Check if an email is good and safe or not.
     * This method should be use for all email input from user
     * @param input String
     * @throws BadInputException if email is not good
     */
    public static void checkGoodEmail(String input) throws BadInputException {
        if (input == null) throw new BadInputException("Sorry, null string is not a good email.");//@todo : localize me
        int atIndex = input.indexOf('@');
        int dotIndex = input.lastIndexOf('.');
        if ((atIndex == -1) || (dotIndex == -1) || (atIndex >= dotIndex)) {
            //@todo : localize me
            throw new BadInputException("Error: '" + input + "' is not a valid email value. Please try again.");
        }
        
        // now check for content of the string
        int length = input.length();
        char c = 0;
        
        for (int i = 0; i < length; i++) {
            c = input.charAt(i);
            if ((c >= 'a') && (c <= 'z')) {
                // lower char
            } else if ((c >= 'A') && (c <= 'Z')) {
                // upper char
            } else if ((c >= '0') && (c <= '9')/* && (i != 0)*/) {
                // as of 31 Jan 2004, i relax the email checking
                // so that the email can start with an numeric char
                // hopefully it does not introduce a security bug
                // because this value will be inserted into sql script
                
                // numeric char
            } else if ( ( (c=='_') || (c=='-') || (c=='.') || (c=='@') ) && (i != 0) ) {
                // _ char
            } else {
                // not good char, throw an BadInputException
                //@todo : localize me
                throw new BadInputException(input + " is not a valid email. Reason: character '" + c + "' is not accepted in an email.");
            }
        }// for
        
        // last check
        try {
            new javax.mail.internet.InternetAddress(input);
        } catch (Exception ex) {
            log.error("Error when running checkGoodEmail", ex);
            throw new BadInputException("Assertion: dont want to occur in Util.checkGoodEmail");
        }
    }
    /**
     * This method trim the email variable, so if it contains only spaces,
     * then it will be empty string, then we have 0 token :-)
     * The returned value is never null
     */
    public static String[] getEmails(String email) throws BadInputException {
        if (email == null) email = "";
        email = email.trim();// very important
        email = email.replace(',', ';');// replace all occurrence of ',' to ';'
        StringTokenizer t = new StringTokenizer(email, ";");
        String[] ret = new String[t.countTokens()];
        int index = 0;
        while(t.hasMoreTokens()) {
            String mail = t.nextToken().trim();
            checkGoodEmail(mail);
            ret[index] = mail;
            //log.debug(ret[index]);
            index++;
        }
        return ret;
    }
    /**
     * This method will return null if there is not any email
     *
     * @param email
     * @return
     * @throws BadInputException
     * @throws AddressException
     */
    private static InternetAddress[] getInternetAddressEmails(String email)
    throws BadInputException, AddressException {
        String[] mails = getEmails(email);
        if (mails.length == 0) return null;// must return null, not empty array
        
        //log.debug("to = " + mails);
        InternetAddress[] address = new InternetAddress[mails.length];
        for (int i = 0; i < mails.length; i++) {
            address[i] = new InternetAddress(mails[i]);
            //log.debug("to each element = " + mails[i]);
        }
        return address;
    }
    public static String send(String to,String cc,String bcc,String subject,String message) throws EmailException, IOException{
        String ret="";
        SimpleEmail email = new SimpleEmail();
        email.setHostName(Sysconfig.getMailServer());
        email.setAuthentication(Sysconfig.getMailUserName(),Sysconfig.getMailPassword());
        email.setCharset("UTF-8");
        email.addTo(to,getEmailUsername(to));
        if(cc!=null && cc.indexOf('@')!=-1 && cc.indexOf('.')!=-1){
            email.addCc(cc,getEmailUsername(cc));
        }
        if(bcc!=null && bcc.indexOf('@')!=-1 && bcc.indexOf('.')!=-1){
            email.addBcc(bcc,getEmailUsername(bcc));
        }
        email.setFrom(Sysconfig.getDefaultMailFrom(),Sysconfig.getSiteName());
        email.setSubject(subject);
        email.setMsg(message);
        //email.setContent(message, "text/plain;charset=UTF-8");
        ret=email.send();
        return ret;
    }
    public static String sendHtml(String to,String cc,String bcc,String subject,String message) throws EmailException, IOException{
        String ret="";
        HtmlEmail email = new HtmlEmail();
        email.setHostName(Sysconfig.getMailServer());
        email.setAuthentication(Sysconfig.getMailUserName(),Sysconfig.getMailPassword());
        email.setCharset("UTF-8");
        email.addTo(to,getEmailUsername(to));
        if(cc!=null && cc.indexOf('@')!=-1 && cc.indexOf('.')!=-1){
            email.addCc(cc,getEmailUsername(cc));
        }
        if(bcc!=null && bcc.indexOf('@')!=-1 && bcc.indexOf('.')!=-1){
            email.addBcc(bcc,getEmailUsername(bcc));
        }
        email.setFrom(Sysconfig.getDefaultMailFrom(),Sysconfig.getSiteName());  
        email.setSubject(subject);
        // embed the image and get the content id
        //URL url = new URL("http://www.apache.org/images/asf_logo_wide.gif");
        //String cid = email.embed(url, "Apache logo");        
        // set the html message
        //email.setHtmlMsg("<html>The apache logo - <img src=\"cid:"+cid+"\"></html>");      
        email.setHtmlMsg(message);
        // set the alternative message
        email.setTextMsg("Your email client does not support HTML messages");        
        // send the email
        email.send();        
        return ret;
    }
}
