﻿/*
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2006 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 * 		http://www.fckeditor.net/
 * 
 * "Support Open Source software. What about a donation today?"
 * 
 * File Name: fckplugin.js
 * 	Plugin to insert "CmsLabels" in the editor.
 * 
 * File Authors:
 * 		Frederico Caldeira Knabben (fredck@fckeditor.net)
 */

// Register the related command.
FCKCommands.RegisterCommand( 'CmsLabel', new FCKDialogCommand( 'CmsLabel', FCKLang.CmsLabelDlgTitle, FCKPlugins.Items['cmslabel'].Path + 'label.jsp', 400, 400 ) ) ;

// Create the "Plaholder" toolbar button.
var oCmsLabelItem = new FCKToolbarButton( 'CmsLabel', FCKLang.CmsLabelBtn ) ;
oCmsLabelItem.IconPath = FCKPlugins.Items['cmslabel'].Path + 'label.gif' ;

FCKToolbarItems.RegisterItem( 'CmsLabel', oCmsLabelItem ) ;


// The object used for all CmsLabel operations.
var FCKCmsLabels = new Object() ;

// Add a new cmslabel at the actual selection.
FCKCmsLabels.Add = function(val)
{
	var oSpan = FCK.CreateElement('span') ;
	//this.SetupSpan( oSpan, name ) ;
	this.InsertCmsLabel( oSpan,val) ;
}

FCKCmsLabels.InsertCmsLabel=function(obj,val)
{	
	//flv.text = str; 

	obj.innerHTML=val ;
}


FCKCmsLabels.SetupSpan = function( span, name )
{
	span.innerHTML = '[[ ' + name + ' ]]' ;

	span.style.backgroundColor = '#ffff00' ;
	span.style.color = '#000000' ;

	if ( FCKBrowserInfo.IsGecko )
		span.style.cursor = 'default' ;

	span._fckcmslabel = name ;
	span.contentEditable = false ;

	// To avoid it to be resized.
	span.onresizestart = function()
	{
		FCK.EditorWindow.event.returnValue = false ;
		return false ;
	}
}

// On Gecko we must do this trick so the user select all the SPAN when clicking on it.
FCKCmsLabels._SetupClickListener = function()
{
	FCKCmsLabels._ClickListener = function( e )
	{
		if ( e.target.tagName == 'SPAN' && e.target._fckcmslabel )
			FCKSelection.SelectNode( e.target ) ;
	}

	FCK.EditorDocument.addEventListener( 'click', FCKCmsLabels._ClickListener, true ) ;
}

// Open the CmsLabel dialog on double click.
FCKCmsLabels.OnDoubleClick = function( span )
{
	if ( span.tagName == 'SPAN' && span._fckcmslabel )
		FCKCommands.GetCommand( 'CmsLabel' ).Execute() ;
}

FCK.RegisterDoubleClickHandler( FCKCmsLabels.OnDoubleClick, 'SPAN' ) ;

// Check if a Placholder name is already in use.
FCKCmsLabels.Exist = function( name )
{
	var aSpans = FCK.EditorDocument.getElementsByTagName( 'SPAN' )

	for ( var i = 0 ; i < aSpans.length ; i++ )
	{
		if ( aSpans[i]._fckcmslabel == name )
			return true ;
	}
}

if ( FCKBrowserInfo.IsIE )
{
	FCKCmsLabels.Redraw = function()
	{
		var aPlaholders = FCK.EditorDocument.body.innerText.match( /\[\[[^\[\]]+\]\]/g ) ;
		if ( !aPlaholders )
			return ;

		var oRange = FCK.EditorDocument.body.createTextRange() ;

		for ( var i = 0 ; i < aPlaholders.length ; i++ )
		{
			if ( oRange.findText( aPlaholders[i] ) )
			{
				var sName = aPlaholders[i].match( /\[\[\s*([^\]]*?)\s*\]\]/ )[1] ;
				oRange.pasteHTML( '<span style="color: #000000; background-color: #ffff00" contenteditable="false" _fckcmslabel="' + sName + '">' + aPlaholders[i] + '</span>' ) ;
			}
		}
	}
}
else
{
	FCKCmsLabels.Redraw = function()
	{
		var oInteractor = FCK.EditorDocument.createTreeWalker( FCK.EditorDocument.body, NodeFilter.SHOW_TEXT, FCKCmsLabels._AcceptNode, true ) ;

		var	aNodes = new Array() ;

		while ( oNode = oInteractor.nextNode() )
		{
			aNodes[ aNodes.length ] = oNode ;
		}

		for ( var n = 0 ; n < aNodes.length ; n++ )
		{
			var aPieces = aNodes[n].nodeValue.split( /(\[\[[^\[\]]+\]\])/g ) ;

			for ( var i = 0 ; i < aPieces.length ; i++ )
			{
				if ( aPieces[i].length > 0 )
				{
					if ( aPieces[i].indexOf( '[[' ) == 0 )
					{
						var sName = aPieces[i].match( /\[\[\s*([^\]]*?)\s*\]\]/ )[1] ;

						var oSpan = FCK.EditorDocument.createElement( 'span' ) ;
						FCKCmsLabels.SetupSpan( oSpan, sName ) ;

						aNodes[n].parentNode.insertBefore( oSpan, aNodes[n] ) ;
					}
					else
						aNodes[n].parentNode.insertBefore( FCK.EditorDocument.createTextNode( aPieces[i] ) , aNodes[n] ) ;
				}
			}

			aNodes[n].parentNode.removeChild( aNodes[n] ) ;
		}
		
		FCKCmsLabels._SetupClickListener() ;
	}

	FCKCmsLabels._AcceptNode = function( node )
	{
		if ( /\[\[[^\[\]]+\]\]/.test( node.nodeValue ) )
			return NodeFilter.FILTER_ACCEPT ;
		else
			return NodeFilter.FILTER_SKIP ;
	}
}

FCK.Events.AttachEvent( 'OnAfterSetHTML', FCKCmsLabels.Redraw ) ;

// We must process the SPAN tags to replace then with the real resulting value of the cmslabel.
FCKXHtml.TagProcessors['span'] = function( node, htmlNode )
{
	if ( htmlNode._fckcmslabel )
		node = FCKXHtml.XML.createTextNode( '[[' + htmlNode._fckcmslabel + ']]' ) ;
	else
		FCKXHtml._AppendChildNodes( node, htmlNode, false ) ;

	return node ;
}