﻿/*
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2006 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 * 		http://www.fckeditor.net/
 * 
 * "Support Open Source software. What about a donation today?"
 * 
 * File Name: fckplugin.js
 * 	Plugin to insert "FlvBtns" in the editor.
 * 
 * File Authors:
 * 		Frederico Caldeira Knabben (fredck@fckeditor.net)
 */

// Register the related command.
FCKCommands.RegisterCommand( 'FlvBtn', new FCKDialogCommand( 'FlvBtn', FCKLang.FlvBtnDlgTitle, FCKPlugins.Items['flvbtn'].Path + 'flv.html', 340, 170 ) ) ;

// Create the "Plaholder" toolbar button.
var oFlvBtnItem = new FCKToolbarButton( 'FlvBtn', FCKLang.FlvBtnBtn ) ;
oFlvBtnItem.IconPath = FCKPlugins.Items['flvbtn'].Path + 'flv.gif' ;

FCKToolbarItems.RegisterItem( 'FlvBtn', oFlvBtnItem ) ;


// The object used for all FlvBtn operations.
var FCKFlvBtns = new Object() ;

// Add a new flvbtn at the actual selection.
FCKFlvBtns.Add = function( name,val)
{
	var oSpan = FCK.CreateElement( 'SCRIPT' ) ;
	//this.SetupSpan( oSpan, name ) ;
	this.InsertFlv( oSpan, name,val) ;
}

FCKFlvBtns.InsertFlv=function( flv, name,val)
{
	var str='<script type="text/javascript">';
	str+='var s1 = new SWFObject("http://www.jstv.com/v/flvplayer.swf","single","400","300","7");';
	str+='s1.addParam("allowfullscreen","true");';
	str+='s1.addVariable("file","'+name+'");';
	str+='s1.addVariable("id","glfhlrw");';
	str+='s1.addVariable("image","'+val+'");';
	str+='s1.write("player1");';
	str+='</script>';
	
	//flv.text = str; 

	//flv.innerHTML=str ;
}


FCKFlvBtns.SetupSpan = function( span, name )
{
	span.innerHTML = '[[ ' + name + ' ]]' ;

	span.style.backgroundColor = '#ffff00' ;
	span.style.color = '#000000' ;

	if ( FCKBrowserInfo.IsGecko )
		span.style.cursor = 'default' ;

	span._fckflvbtn = name ;
	span.contentEditable = false ;

	// To avoid it to be resized.
	span.onresizestart = function()
	{
		FCK.EditorWindow.event.returnValue = false ;
		return false ;
	}
}

// On Gecko we must do this trick so the user select all the SPAN when clicking on it.
FCKFlvBtns._SetupClickListener = function()
{
	FCKFlvBtns._ClickListener = function( e )
	{
		if ( e.target.tagName == 'SPAN' && e.target._fckflvbtn )
			FCKSelection.SelectNode( e.target ) ;
	}

	FCK.EditorDocument.addEventListener( 'click', FCKFlvBtns._ClickListener, true ) ;
}

// Open the FlvBtn dialog on double click.
FCKFlvBtns.OnDoubleClick = function( span )
{
	if ( span.tagName == 'SPAN' && span._fckflvbtn )
		FCKCommands.GetCommand( 'FlvBtn' ).Execute() ;
}

FCK.RegisterDoubleClickHandler( FCKFlvBtns.OnDoubleClick, 'SPAN' ) ;

// Check if a Placholder name is already in use.
FCKFlvBtns.Exist = function( name )
{
	var aSpans = FCK.EditorDocument.getElementsByTagName( 'SPAN' )

	for ( var i = 0 ; i < aSpans.length ; i++ )
	{
		if ( aSpans[i]._fckflvbtn == name )
			return true ;
	}
}

if ( FCKBrowserInfo.IsIE )
{
	FCKFlvBtns.Redraw = function()
	{
		var aPlaholders = FCK.EditorDocument.body.innerText.match( /\[\[[^\[\]]+\]\]/g ) ;
		if ( !aPlaholders )
			return ;

		var oRange = FCK.EditorDocument.body.createTextRange() ;

		for ( var i = 0 ; i < aPlaholders.length ; i++ )
		{
			if ( oRange.findText( aPlaholders[i] ) )
			{
				var sName = aPlaholders[i].match( /\[\[\s*([^\]]*?)\s*\]\]/ )[1] ;
				oRange.pasteHTML( '<span style="color: #000000; background-color: #ffff00" contenteditable="false" _fckflvbtn="' + sName + '">' + aPlaholders[i] + '</span>' ) ;
			}
		}
	}
}
else
{
	FCKFlvBtns.Redraw = function()
	{
		var oInteractor = FCK.EditorDocument.createTreeWalker( FCK.EditorDocument.body, NodeFilter.SHOW_TEXT, FCKFlvBtns._AcceptNode, true ) ;

		var	aNodes = new Array() ;

		while ( oNode = oInteractor.nextNode() )
		{
			aNodes[ aNodes.length ] = oNode ;
		}

		for ( var n = 0 ; n < aNodes.length ; n++ )
		{
			var aPieces = aNodes[n].nodeValue.split( /(\[\[[^\[\]]+\]\])/g ) ;

			for ( var i = 0 ; i < aPieces.length ; i++ )
			{
				if ( aPieces[i].length > 0 )
				{
					if ( aPieces[i].indexOf( '[[' ) == 0 )
					{
						var sName = aPieces[i].match( /\[\[\s*([^\]]*?)\s*\]\]/ )[1] ;

						var oSpan = FCK.EditorDocument.createElement( 'span' ) ;
						FCKFlvBtns.SetupSpan( oSpan, sName ) ;

						aNodes[n].parentNode.insertBefore( oSpan, aNodes[n] ) ;
					}
					else
						aNodes[n].parentNode.insertBefore( FCK.EditorDocument.createTextNode( aPieces[i] ) , aNodes[n] ) ;
				}
			}

			aNodes[n].parentNode.removeChild( aNodes[n] ) ;
		}
		
		FCKFlvBtns._SetupClickListener() ;
	}

	FCKFlvBtns._AcceptNode = function( node )
	{
		if ( /\[\[[^\[\]]+\]\]/.test( node.nodeValue ) )
			return NodeFilter.FILTER_ACCEPT ;
		else
			return NodeFilter.FILTER_SKIP ;
	}
}

FCK.Events.AttachEvent( 'OnAfterSetHTML', FCKFlvBtns.Redraw ) ;

// We must process the SPAN tags to replace then with the real resulting value of the flvbtn.
FCKXHtml.TagProcessors['span'] = function( node, htmlNode )
{
	if ( htmlNode._fckflvbtn )
		node = FCKXHtml.XML.createTextNode( '[[' + htmlNode._fckflvbtn + ']]' ) ;
	else
		FCKXHtml._AppendChildNodes( node, htmlNode, false ) ;

	return node ;
}