package zr.zrpower.queryengine;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import zr.zrpower.queryengine.service.QueryConfig;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_TABLE;
import zr.zrpower.web.bean.MessageBox;
import zr.zrpower.common.util.FunctionMessage;



public class QueryConfigSer
    extends MessageBox {
  private static final String CONTENT_TYPE = "text/html; charset=GBK";
  private QueryConfig queryConfig;
  private FunctionMessage fm;
  private QUERY_CONFIG_TABLE objConfigTable;
  private HttpServletRequest _request;

  //Initialize global variables
  public void init() throws ServletException {
  }

  //Process the HTTP Get request
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws
      ServletException, IOException {
    String strAction;
    String rtnPath = "";
    response.setContentType(CONTENT_TYPE);
    request.setCharacterEncoding("GBK");

      _request = request;
      fm = new FunctionMessage(1);
      fm.setResult(true);
      strAction = request.getParameter("Act1");
      objConfigTable = new QUERY_CONFIG_TABLE();
      objConfigTable.fullDataFromRequest(_request);
      if (objConfigTable.getID() == null) {
        objConfigTable.setID("");
      }

      try {
        queryConfig = new QueryConfig();
        if (objConfigTable.getID().trim().equals("")) {

          objConfigTable.setID(queryConfig.GetMaxFieldNo("QUERY_CONFIG_TABLE",
              "ID", 8));
        }

        if (strAction.equals("Save")) {

          SaveBaseProperty(); //

          SaveRelationProperty(); //

          SaveInitWhereProperty(); //ʼ

          SaveQueryFieldProperty(); //ѯ

          SaveResultFieldProperty(); //

          SaveDetailParameterProperty(); //ť

          SaveSortProperty();           //

          rtnPath = "ZrQueryEngine/Config/ManageConfig.jsp?SelectedItems=" +
              objConfigTable.getID();

        }

        if (strAction.equals("Delete")) {
          queryConfig.DeleteConfigByID(objConfigTable.getID());
          rtnPath = "ZrQueryEngine/Config/List.jsp";
        }

      }
      catch (Exception ex2) {
        fm.setResult(false);
        this.Msg = "ӿͻļмʧܣ<br>ϸϢ<br>   " + ex2.toString();
        this.returnPath = "javascript:history.back(-1);";
      }

      if (fm.getResult()) {
        response.sendRedirect(rtnPath);
      }

      this.out = response.getWriter();
      //this.GetBox();

  }

  //Process the HTTP Post request
  public void doPost(HttpServletRequest request, HttpServletResponse response) throws
      ServletException, IOException {
    doGet(request, response);
  }

  //Clean up resources
  public void destroy() {
  }

  /**
   * 
   * @return boolean
   */
  private boolean SaveBaseProperty() {
    try {
      return queryConfig.SaveBaseProperty(objConfigTable);
    }
    catch (Exception ex) {
      return false;
    }
  }

//
  private boolean SaveRelationProperty() {
    try {
      return queryConfig.SaveRelationProperty(objConfigTable.getID(),
                                              _request.getParameter(
                                                  "RelationInfoStr"));
    }
    catch (Exception ex) {
      return false;
    }
  }

  //ʼ
  private boolean SaveInitWhereProperty() {
    try {
      return queryConfig.SaveInitWhereProperty(objConfigTable.getID(),
                                               _request.getParameter(
          "WhereInfoStr"));
    }
    catch (Exception ex) {
      return false;
    }
  }

  //ѯ
  private boolean SaveQueryFieldProperty() {
    try {
      return queryConfig.SaveQueryFieldProperty(objConfigTable.getID(),
                                                _request.getParameter(
          "QueryFieldInfoStr"));
    }
    catch (Exception ex) {
      return false;
    }
  }

  //
  private boolean SaveResultFieldProperty() {
    try {
      return queryConfig.SaveResultFieldProperty(objConfigTable.getID(),
                                                 _request.getParameter(
          "ResultDisFieldInfoStr"), _request.getParameter(
              "ResultHidFieldInfoStr"));

    }
    catch (Exception ex) {
      return false;
    }
  }

  //ť
  private boolean SaveDetailParameterProperty() {
    try {
      return queryConfig.SaveDetailParameterProperty(objConfigTable.getID(),
          _request.getParameter(
              "DetailParameterInfoStr"),
          _request.getParameter("BRelationInfoStr"));

    }
    catch (Exception ex) {
      return false;
    }
  }

  //
  private boolean SaveSortProperty() {
    try {
     return queryConfig.SaveSortProperty(objConfigTable.getID(),
                                             _request.getParameter(
                                                 "SortInfoStr"));
   }
   catch (Exception ex) {
     return false;
   }

  }

}
