/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.lang.reflect.Method;
import net.jdiy.core.ActionMapping;
import net.jdiy.core.JDiyInterceptor;
import net.jdiy.core.ex.JDiyActionException;
import net.jdiy.core.res.Locale;

public class ActionEntity {
    private ActionMapping am;
    private Object action;
    private JDiyInterceptor[] inters;
    private int index;

    ActionEntity(ActionMapping am) {
        this.am = am;
        try {
            this.action = am.className.newInstance();
        }
        catch (Exception e) {
            throw new JDiyActionException(e.getCause(), Locale.DBG.getString("action.newInstanceErr"), "Action", am.className.getName());
        }
        this.inters = new JDiyInterceptor[am.inters.size()];
        int i = 0;
        for (Class<JDiyInterceptor> c : am.inters) {
            try {
                this.inters[i++] = c.newInstance();
            }
            catch (Exception e) {
                throw new JDiyActionException(e.getCause(), Locale.DBG.getString("action.newInstanceErr"), "Interceptor", c.getName());
            }
        }
    }

    public void invoke() throws Exception {
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept(this);
        } else {
            this.invokeAction();
        }
    }

    public Class getActionClass() {
        return this.am.className;
    }

    public Method getMethod() {
        return this.am.methodName;
    }

    public String getUrl() {
        return this.am.url;
    }

    private void invokeAction() {
        try {
            this.getMethod().invoke(this.action, new Object[0]);
        }
        catch (Exception ie) {
            throw new JDiyActionException(ie.getCause(), Locale.DBG.getString("action.invokeError"), this.getActionClass().toString(), this.getMethod().toString(), ie.getCause().getMessage());
        }
    }
}

