/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jdiy.core.ActionMapping;
import net.jdiy.core.JDiyAction;
import net.jdiy.core.JDiyInterceptor;
import net.jdiy.core.aop.Before;
import net.jdiy.core.ex.JDiyActionException;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Txt;

class ActionMatcher {
    private String urlRegex;
    private String classRegex;
    private String methodRegex;
    private String urlConf;
    private String classConf;
    private String methodConf;
    private List<Class<JDiyInterceptor>> globalInters;
    private static Pattern classPattern = Pattern.compile("^[a-z_][a-z0-9_]*(\\.[a-z_][a-z0-9_]*)*$", 2);
    private static Pattern methodPattern = Pattern.compile("^[a-z_][a-z0-9_]*$", 2);

    public ActionMatcher(String urlConf, String classConf, String methodConf, List<Class<JDiyInterceptor>> globalInters) {
        this.urlConf = urlConf;
        this.classConf = classConf;
        this.methodConf = methodConf;
        this.globalInters = globalInters;
        this.urlRegex = urlConf.replaceAll("\\.", "\\\\.").replaceAll("\\*", "(.+)");
        this.classRegex = classConf.replaceAll("\\{([1-9])\\}", "\\$$1");
        this.methodRegex = methodConf.replaceAll("\\{([1-9])\\}", "\\$$1");
    }

    public ActionMapping match(String uri) {
        Class<?> c;
        String mhd;
        String cls;
        try {
            Matcher mh = Pattern.compile("^" + this.urlRegex + "$").matcher(uri);
            cls = mh.replaceAll(this.classRegex);
            if (!classPattern.matcher(cls).find()) {
                return null;
            }
            mhd = mh.replaceAll(this.methodRegex);
            if (!methodPattern.matcher(mhd).find()) {
                return null;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new JDiyActionException(Locale.DBG.getString("action.matchError"), this.urlConf, this.classConf, this.methodConf, ex.getMessage());
        }
        ArrayList<Class<JDiyInterceptor>> inters = new ArrayList<Class<JDiyInterceptor>>();
        inters.addAll(this.globalInters);
        try {
            c = Class.forName(cls);
            this.annotation(c.getAnnotation(Before.class), inters);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JDiyActionException(Locale.DBG.getString("action.classNotFound"), cls, this.urlConf, this.classConf, this.methodConf, uri);
        }
        try {
            Method m = c.getMethod(mhd, new Class[0]);
            this.annotation(m.getAnnotation(Before.class), inters);
            JDiyAction.log.info(Txt.inject(Locale.DBG.getString("action.info.mappingOk"), uri, cls, mhd));
            return new ActionMapping(c, m, uri, inters);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JDiyActionException(Locale.DBG.getString("action.methodNotFound"), cls, mhd, this.urlConf, this.classConf, this.methodConf, uri);
        }
    }

    public void annotation(Annotation a, List<Class<JDiyInterceptor>> ls) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (a != null) {
            Method mm = a.getClass().getMethod("value", new Class[0]);
            Class[] values = (Class[])mm.invoke((Object)a, new Object[0]);
            Collections.addAll(ls, values);
        }
    }
}

