/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jdiy.core.Context;
import net.jdiy.core.Dao;
import net.jdiy.core.JDiyContext;
import net.jdiy.core.ex.JDiyUnSupportException;
import net.jdiy.core.res.Locale;
import net.jdiy.upload.JDiyRequest;
import net.jdiy.util.Sec;
import net.jdiy.util.Txt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
extends JDiyContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String contextPath;
    private Map<String, Dao> daoMap = new HashMap<String, Dao>();
    static ThreadLocal<App> localContext = new ThreadLocal();
    static Map<String, Context> contextMap = new HashMap<String, Context>();
    public static final String NAME = "JDiy";
    public static final String VERSION = "2.1";
    private static final Logger log = LoggerFactory.getLogger(JDiyContext.class);

    public static App get() {
        return localContext.get();
    }

    @Override
    public Dao getDao() {
        return this.getDao(null);
    }

    @Override
    public synchronized Dao getDao(String name) {
        return this.getContext().getDao(name);
    }

    public int getInt(String str) {
        return this.getInt(str, 0);
    }

    public int getInt(String str, int defNum) {
        return Txt.parseInt(this.getParameter(str), defNum);
    }

    public String get(String str) {
        return this.get(str, "");
    }

    public String get(String str, String defStr) {
        String s = this.getParameter(str);
        if (s == null || "".equals(s)) {
            return defStr;
        }
        return s;
    }

    public String[] getValues(String str) {
        return this.getParameterValues(str);
    }

    public File getFile(String name) {
        return this.getMultipartWrapper().getFile(name);
    }

    public Enumeration<String> getNames() {
        return this.request.getParameterNames();
    }

    public String[] getValues() {
        Enumeration<String> names = this.getNames();
        if (names == null) {
            return new String[0];
        }
        ArrayList<String> al = new ArrayList<String>();
        while (names.hasMoreElements()) {
            al.add(this.get(names.nextElement()));
        }
        return al.toArray(new String[al.size()]);
    }

    public Enumeration<String> getFileNames() {
        return this.getMultipartWrapper().getFileNames();
    }

    public String getClientFileName(String name) {
        return this.getMultipartWrapper().getOriginalFileName(name);
    }

    public String getContentType(String name) {
        return this.getMultipartWrapper().getContentType(name);
    }

    public String var(String name) {
        String rtn = null;
        String varKeep = this.getJDiyProp("varKeep");
        varKeep = varKeep == null ? "session" : varKeep.toLowerCase();
        if ("session".equals(varKeep) || "both".equals(varKeep)) {
            rtn = (String)this.getRequest().getSession().getAttribute(name);
        }
        if (rtn != null) {
            return rtn;
        }
        if ("cookie".equals(varKeep) || "both".equals(varKeep)) {
            rtn = this.cookie(name);
        }
        return rtn == null ? "" : rtn;
    }

    public App var(String name, String value) {
        String varKeep = this.getJDiyProp("varKeep");
        varKeep = varKeep == null ? "session" : varKeep.toLowerCase();
        if (value != null) {
            if (varKeep.equals("session") || varKeep.equals("both")) {
                this.getRequest().getSession().setAttribute(name, (Object)value);
            }
            if (varKeep.equals("cookie") || varKeep.equals("both")) {
                this.cookie(name, value, Txt.parseInt(this.getJDiyProp("varExpires"), -1));
            }
        } else {
            if (varKeep.equals("session") || varKeep.equals("both")) {
                if (!name.contains(",")) {
                    this.getRequest().getSession().removeAttribute(name);
                } else {
                    for (String aNa : Txt.split(name.replaceAll(" ", ""), ",")) {
                        this.getRequest().getSession().removeAttribute(aNa);
                    }
                }
            }
            if (varKeep.equals("cookie") || varKeep.equals("both")) {
                if (!name.contains(",")) {
                    this.cookie(name, null);
                } else {
                    for (String aNa : Txt.split(name.replaceAll(" ", ""), ",")) {
                        this.cookie(aNa, null);
                    }
                }
            }
        }
        return this;
    }

    public String cookie(String name) {
        Cookie[] c = this.getRequest().getCookies();
        if (c != null) {
            for (Cookie aC : c) {
                if (!aC.getName().equals(name)) continue;
                try {
                    return aC.getValue() == null ? null : URLDecoder.decode(aC.getValue(), "utf-8");
                }
                catch (Exception ignored) {
                    return null;
                }
            }
        }
        return null;
    }

    public App cookie(String name, String value) {
        return this.cookie(name, value, -1);
    }

    public App cookie(String name, String value, int maxAge) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            Cookie[] c = this.getRequest().getCookies();
            if (c == null) {
                return this;
            }
            for (Cookie aC : c) {
                if (!name.equals(aC.getName())) continue;
                aC.setMaxAge(0);
                aC.setPath(this.contextPath + "/");
                this.getResponse().addCookie(aC);
                break;
            }
        } else {
            try {
                Cookie c = new Cookie(name, URLEncoder.encode(value, "utf-8"));
                c.setMaxAge(maxAge == 0 ? -1 : maxAge);
                c.setPath(this.contextPath + "/");
                this.getResponse().addCookie(c);
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public String getJDiyProp(String name) {
        return this.getContext().getJDiyProp(name);
    }

    @Override
    public String getProp(String name) {
        return this.getContext().getProp(name);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getRealPath(String path) {
        return this.request.getSession().getServletContext().getRealPath(path);
    }

    public String getSign(String str) {
        String s = (str + "@" + this.getRequest().getSession().getServletContext().getRealPath("")).toUpperCase();
        return Sec.MD5Encrypt(s, 32);
    }

    App(HttpServletRequest request, ServletResponse response, String contextPath) throws IOException {
        this.request = request;
        this.response = (HttpServletResponse)response;
        this.contextPath = contextPath;
        String type = request.getHeader("Content-Type");
        if (type != null && type.toLowerCase().startsWith("multipart/form-data")) {
            Context c = this.getContext();
            String tmp = c.getDataPath() + File.separator + "temp";
            String lm = c.getJDiyProp("globalUploadLimit");
            int limit = lm == null ? 20 : Integer.valueOf(lm) * 1024;
            boolean b = new File(tmp).mkdirs();
            request.getSession().setAttribute("JD_uploadTotal", (Object)String.valueOf(request.getContentLength()));
            request.getSession().setAttribute("JD_uploadTime", (Object)String.valueOf(System.currentTimeMillis()));
            this.request = new JDiyRequest(request, tmp, limit, "utf-8", "true".equals(c.getJDiyProp("renameUploadFile")));
        } else {
            this.request = new JDiyRequest(request, "utf-8");
        }
    }

    private JDiyRequest getMultipartWrapper() {
        JDiyRequest mr = (JDiyRequest)this.request;
        if (!mr.isMultipart()) {
            throw new JDiyUnSupportException(Locale.DBG.getString("err.app.notMultipart"));
        }
        return mr;
    }

    private String getParameter(String str) {
        return this.request.getParameter(str);
    }

    private String[] getParameterValues(String str) {
        return this.request.getParameterValues(str);
    }

    Context getContext() {
        return contextMap.get(this.request.getSession().getServletContext().getRealPath(""));
    }
}

