/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jdiy.core.ActionEntity;
import net.jdiy.core.ActionMapping;
import net.jdiy.core.ActionMatcher;
import net.jdiy.core.Context;
import net.jdiy.core.Dao;
import net.jdiy.core.DaoImpl;
import net.jdiy.core.JDiyContext;
import net.jdiy.core.JDiyInterceptor;
import net.jdiy.core.db.ConnPool;
import net.jdiy.core.db.DbEngine;
import net.jdiy.core.ex.JDiyConfigException;
import net.jdiy.core.ex.JDiyConnectionException;
import net.jdiy.core.ex.JDiyException;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Txt;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.util.XMLErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;

final class ContextImpl
extends JDiyContext
implements Context {
    private long visitTime;
    private String rootPath;
    private boolean showSql = false;
    private DbEngine defaultEngine;
    private Map<String, Dao> daoMap = new HashMap<String, Dao>();
    private Map<String, ConnPool> connPools = new HashMap<String, ConnPool>();
    private Map<String, String> jdProp = new HashMap<String, String>();
    private Map<String, String> userProp = new HashMap<String, String>();
    private Map<String, ActionMapping> actionMap = new HashMap<String, ActionMapping>();
    List<ActionMatcher> actions = new ArrayList<ActionMatcher>();
    List<Class<JDiyInterceptor>> inters = new ArrayList<Class<JDiyInterceptor>>();
    static final Logger log = LoggerFactory.getLogger(JDiyContext.class);

    ContextImpl(URL xmlLocation, String rootPath) throws JDiyException {
        Document doc = this.loadXml(xmlLocation);
        this.processDatabase(doc);
        this.processJDiyProperties(doc);
        this.processInterceptorAndAction(doc);
        this.processUserProperties(doc);
        log.info(Locale.DBG.getString("log.ContextImpl.coreLoadOk"));
        this.rootPath = rootPath;
        this.visit();
    }

    @Override
    public Dao getDao(String connName) {
        Dao dao;
        if (null == connName) {
            connName = this.defaultEngine.getName();
        }
        if (null == (dao = this.daoMap.get(connName))) {
            ConnPool cp = this.connPools.get(connName);
            if (cp == null) {
                String s = Locale.DBG.getString("err.dbpools.connNameErr");
                DaoImpl.log.error(s, (Object)connName);
                throw new JDiyConnectionException(s, connName);
            }
            dao = new DaoImpl(this, cp);
            this.daoMap.put(connName, dao);
        }
        return dao;
    }

    @Override
    public Dao getDao() {
        return this.getDao(null);
    }

    @Override
    public Map<String, ConnPool> getConnPools() {
        return this.connPools;
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public String getDataPath() {
        String saeWrapper = this.getJDiyProp("saeWrapper");
        if (saeWrapper == null || "".equals(saeWrapper)) {
            return this.getRootPath() + "/JDiy_data";
        }
        return "saestor://" + saeWrapper + "/JDiy_data";
    }

    @Override
    public boolean isShowSql() {
        return this.showSql;
    }

    @Override
    public String getJDiyProp(String name) {
        return this.jdProp.get(name);
    }

    @Override
    public String getProp(String name) {
        return this.userProp.get(name);
    }

    @Override
    public void visit() {
        this.visitTime = System.currentTimeMillis();
    }

    @Override
    public long getFreeTime() {
        return System.currentTimeMillis() - this.visitTime;
    }

    ActionEntity getActionEntity(String uri) {
        ActionMapping a = this.actionMap.get(uri);
        if (a == null) {
            for (ActionMatcher am : this.actions) {
                a = am.match(uri);
                if (a == null) continue;
                this.actionMap.put(uri, a);
                break;
            }
        }
        return a == null ? null : a.newActionEntity();
    }

    private Document loadXml(URL xmlLocation) {
        Document doc;
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        String schema = ContextImpl.class.getResource("").toString().replace("net/jdiy/core/", "jdiy.xsd");
        HashMap<String, String> nameSpaceMap = new HashMap<String, String>();
        nameSpaceMap.put("jdiy", "http://www.jdiy.net");
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        try {
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", (Object)"http://www.w3.org/2001/XMLSchema");
            reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", (Object)schema);
            reader.setErrorHandler((ErrorHandler)errorHandler);
            reader.getDocumentFactory().setXPathNamespaceURIs(nameSpaceMap);
            doc = reader.read(xmlLocation.openStream());
            log.info(Locale.DBG.getString("log.ContextImpl.loadingXml"));
        }
        catch (Exception ex) {
            throw new JDiyConfigException(Locale.DBG.getString("log.ContextImpl.errorConfLoad"), ex.toString());
        }
        if (errorHandler.getErrors().hasContent()) {
            throw new JDiyConfigException(Locale.DBG.getString("log.ContextImpl.validateError"), errorHandler.getErrors().asXML());
        }
        log.info(Locale.DBG.getString("log.ContextImpl.loadingConf"));
        return doc;
    }

    private void processDatabase(Document doc) {
        Node sql = doc.selectSingleNode("//jdiy:jdiy-config/jdiy:databases/@showSql");
        this.showSql = sql != null && "true".equals(sql.getText());
        log.info(Locale.DBG.getString(this.showSql ? "log.ContextImpl.showSqlOn" : "log.ContextImpl.showSqlOff"));
        Node def = doc.selectSingleNode("//jdiy:jdiy-config/jdiy:databases/@default");
        if (def == null) {
            log.info(Locale.DBG.getString("log.ContextImpl.noDefDatabase"));
        } else {
            log.info(Locale.DBG.getString("log.ContextImpl.defDatabase"), (Object)def.getText());
        }
        List<Node> dbs = this.getNodeList(doc, "databases/jdiy:database");
        log.info(Locale.DBG.getString("log.ContextImpl.readDatabases"), (Object)dbs.size());
        for (int i = 0; i < dbs.size(); ++i) {
            Node n;
            Node node = dbs.get(i);
            String connName = this.getNodeString(node, "@name", "");
            String dbType = this.getNodeString(node, "jdiy:type", "");
            String dbDriver = this.getNodeString(node, "jdiy:driver", "");
            String dbUrl = this.getNodeString(node, "jdiy:url", "");
            String dbUid = this.getNodeString(node, "jdiy:uid", "");
            String dbPwd = this.getNodeString(node, "jdiy:pwd", "");
            String maxed = this.getNodeString(node, "jdiy:maxed", "ERROR");
            String dbHost = "127.0.0.1";
            String dbName = null;
            int dbPort = 0;
            if ("".equals(dbUrl)) {
                dbHost = this.getNodeString(node, "jdiy:host", "");
                dbName = this.getNodeString(node, "jdiy:name", "");
                Node nPort = node.selectSingleNode("jdiy:port");
                dbPort = nPort == null ? 0 : Integer.valueOf(nPort.getText().trim());
            }
            int maxPools = (n = node.selectSingleNode("jdiy:maxPools")) == null ? 16 : Txt.parseInt(n.getText().trim(), 16);
            DbEngine de = DbEngine.getInstance(connName, dbType, dbDriver, dbUrl, dbUid, dbPwd, dbHost, dbPort, dbName, maxPools, maxed);
            if (this.defaultEngine == null && (i == 0 && def == null || def != null && connName.equals(def.getText()))) {
                this.defaultEngine = de;
            }
            this.connPools.put(connName, new ConnPool(de));
        }
    }

    private void processJDiyProperties(Document doc) {
        List<Node> jdProps = this.getNodeList(doc, "jdiy-properties/*");
        for (Node p : jdProps) {
            this.jdProp.put(p.getName(), p.getText().trim());
        }
        if (this.jdProp.get("loginPath") == null || "".equals(this.jdProp.get("loginPath"))) {
            this.jdProp.put("loginPath", "/jdiy-admin/");
        }
        if (this.jdProp.get("loginPage") == null || "".equals(this.jdProp.get("loginPage"))) {
            this.jdProp.put("loginPage", this.jdProp.get("loginPath"));
        }
    }

    private void processUserProperties(Document doc) {
        List<Node> uProps = this.getNodeList(doc, "user-properties/*");
        for (Node p : uProps) {
            this.userProp.put(p.selectSingleNode("@name").getText().trim(), p.getText().trim());
        }
    }

    private void processInterceptorAndAction(Document doc) {
        List<Node> ai = this.getNodeList(doc, "jdiy-interceptors/*");
        for (Node p : ai) {
            Class<?> c;
            String cls = p.getText().trim();
            try {
                c = Class.forName(cls);
            }
            catch (ClassNotFoundException e) {
                throw new JDiyConfigException(Locale.DBG.getString("interceptor.classNotFound"), cls);
            }
            if (!JDiyInterceptor.class.isAssignableFrom(c)) {
                throw new JDiyConfigException(Locale.DBG.getString("interceptor.invalid"), cls);
            }
            this.inters.add(c);
        }
        List<Node> ac = this.getNodeList(doc, "jdiy-actions/*");
        for (Node p : ac) {
            String url = p.selectSingleNode("@url").getText();
            String cls = p.selectSingleNode("@class").getText();
            String mod = p.selectSingleNode("@method").getText();
            this.actions.add(new ActionMatcher(url, cls, mod, this.inters));
        }
    }

    private String getNodeString(Node node, String name, String def) {
        Node n = node.selectSingleNode(name);
        return n == null ? def : n.getText().trim();
    }

    private List<Node> getNodeList(Document doc, String nodeStr) {
        return doc.selectNodes("//jdiy:jdiy-config/jdiy:" + nodeStr);
    }
}

