/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.jdiy.core.Args;
import net.jdiy.core.Context;
import net.jdiy.core.Dao;
import net.jdiy.core.Ls;
import net.jdiy.core.LsImpl;
import net.jdiy.core.Rs;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.db.ConnPool;
import net.jdiy.core.ex.JDiyException;
import net.jdiy.core.ex.JDiyFieldException;
import net.jdiy.core.ex.JDiySqlException;
import net.jdiy.core.ex.JDiyTransException;
import net.jdiy.core.field.DbField;
import net.jdiy.core.field.FileField;
import net.jdiy.core.field.XmlField;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Fs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DaoImpl
implements Dao {
    private Context context;
    private ConnPool connPool;
    private Map<String, Rs> tbPkCache = new HashMap<String, Rs>();
    private Connection Conn = null;
    static final Logger log = LoggerFactory.getLogger(Dao.class);

    DaoImpl(Context context, ConnPool connPool) {
        this.context = context;
        this.connPool = connPool;
    }

    @Override
    public String getDbType() {
        return this.connPool.getEngine().getDbType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int len(Args args) {
        int count = 0;
        StringBuilder sql = new StringBuilder("SELECT COUNT(0) AS cnt FROM ").append(args.getTable());
        String f1 = args.getFilter();
        if (f1 != null && !(f1 = f1.trim()).equals("")) {
            String lower = f1.toLowerCase();
            int odb = lower.lastIndexOf("order by");
            if (odb != -1) {
                f1 = f1.substring(0, odb);
            }
            if ("".equals(f1) || lower.startsWith("group ")) {
                sql.append(f1);
            } else {
                sql.append(" WHERE ").append(f1);
            }
        }
        boolean hasErr = false;
        Connection cn = this.Conn == null ? this.connPool.getConnection() : this.Conn;
        ResultSet rs = null;
        Statement smt = null;
        try {
            String sqlQuery = sql.toString();
            if (this.context.isShowSql()) {
                log.info(sqlQuery);
            }
            if ((rs = (smt = cn.createStatement()).executeQuery(sqlQuery)).next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            hasErr = true;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (smt != null) {
                    smt.close();
                }
            }
            catch (SQLException ignore) {}
            if (this.Conn == null) {
                this.connPool.releaseConnection(cn);
            }
        }
        if (hasErr) {
            int pmsize = args.getPageSize();
            args.setPageSize(0);
            count = this.ls(args).getItems().length;
            args.setPageSize(pmsize);
        }
        return count;
    }

    @Override
    public Rs rs(Args pm) {
        int pageSize = pm.getPageSize();
        int absPage = pm.getAbsPage();
        pm.setPageSize(1);
        pm.setAbsPage(1);
        Rs d = ((LsImpl)this.ls(pm, true)).getOne();
        pm.setPageSize(pageSize);
        pm.setAbsPage(absPage);
        return d;
    }

    @Override
    public Rs rs(String sql) {
        return ((LsImpl)this.ls(sql, 1, 1)).getOne();
    }

    @Override
    public int del(Rs d) {
        if (d.isNull()) {
            log.warn(Locale.DBG.getString("warn.Rs.tempDel"));
            return 0;
        }
        String[] pks = d.getPK();
        if (pks == null) {
            throw new JDiySqlException(Locale.DBG.getString("err.Rs.noPK"));
        }
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(d.getTable()).append(" WHERE ");
        String dataRoot = this.context.getDataPath();
        boolean notOne = false;
        for (String pk : pks) {
            if (notOne) {
                sql.append(" AND ");
            }
            sql.append(pk).append("='").append(d.get(pk)).append("'");
            notOne = true;
        }
        if (pks.length == 1) {
            String pk = pks[0];
            String pkv = d.get(pk);
            String aPath = dataRoot + File.separator + "entity";
            String bPath = aPath + File.separator + pkv.substring(pkv.length() - 1);
            Fs.delAll(bPath + File.separator + pkv);
            Fs.delEmpty(bPath);
            Fs.delEmpty(aPath);
        }
        d.isNull = true;
        d.fdFmap = null;
        d.fdXmap = null;
        for (DbField dbf : d.fdDmap.values()) {
            if (dbf.isReadOnly()) continue;
            dbf.setChanged(true);
        }
        return this.exec(sql.toString());
    }

    @Override
    public int del(Args args) {
        int cnt = 0;
        for (Rs d : this.ls(args).getItems()) {
            cnt += this.del(d);
        }
        return cnt;
    }

    @Override
    public int exec(String sql) {
        Connection cn = this.Conn == null ? this.connPool.getConnection() : this.Conn;
        Statement smt = null;
        try {
            smt = cn.createStatement();
            if (this.context.isShowSql()) {
                log.info(sql);
            }
            int rtn = smt.executeUpdate(sql);
            if (this.context.isShowSql()) {
                log.info(Locale.DBG.getString("log.DaoImpl.execed"), (Object)rtn);
            }
            int n = rtn;
            return n;
        }
        catch (SQLException e) {
            this.transRollBack();
            throw new JDiySqlException(e.getMessage(), e.getCause());
        }
        finally {
            try {
                if (smt != null) {
                    smt.close();
                }
            }
            catch (SQLException ignore) {}
            if (this.Conn == null) {
                this.connPool.releaseConnection(cn);
            }
        }
    }

    @Override
    public Ls ls(String sql, int pageSize, int absPage) {
        Connection cn = this.Conn == null ? this.connPool.getConnection() : this.Conn;
        Statement smt = null;
        ResultSet rs = null;
        try {
            int b;
            int rowCount = 0;
            if ("sqlite".equalsIgnoreCase(this.getDbType())) {
                smt = cn.createStatement();
                rs = smt.executeQuery(sql);
                while (rs.next()) {
                    ++rowCount;
                }
                rs.close();
                smt.close();
                smt = cn.createStatement();
                rs = smt.executeQuery(sql);
                if (this.context.isShowSql()) {
                    log.info(sql);
                }
                int begin = pageSize * (absPage - 1);
                int i = 0;
                while (rs.next() && ++i < begin) {
                }
            } else {
                smt = cn.createStatement(1004, 1007);
                if (this.context.isShowSql()) {
                    log.info(sql);
                }
                rs = smt.executeQuery(sql);
                rs.last();
                rowCount = rs.getRow();
                if (pageSize <= 0 || absPage <= 1) {
                    rs.beforeFirst();
                } else if (absPage <= (rowCount + pageSize - 1) / pageSize) {
                    rs.absolute((absPage - 1) * pageSize);
                }
            }
            String tableName = this.connPool.getEngine().getTableName(rs.getMetaData());
            if ("".equals(tableName) && (b = sql.toUpperCase().indexOf(" FROM ")) != -1 && sql.length() > 6 && (b = (tableName = sql.substring(b + 6)).indexOf(" ")) != -1) {
                tableName = tableName.substring(0, b);
            }
            String[] tbpk = this.getTableInfo(cn, tableName).getPK();
            Ls ls = this.initLs(tableName, rs, rowCount, pageSize, absPage, tbpk);
            return ls;
        }
        catch (SQLException e) {
            this.transRollBack();
            throw new JDiySqlException(e.getMessage(), e.getCause());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (smt != null) {
                    smt.close();
                }
            }
            catch (SQLException ignore) {}
            if (this.Conn == null) {
                this.connPool.releaseConnection(cn);
            }
        }
    }

    private Rs getTableInfo(Connection cn, String tableName) throws SQLException {
        Rs rs = null;
        if (!"".equals(tableName) && (rs = this.tbPkCache.get(tableName)) == null) {
            String[] tableNames;
            DatabaseMetaData m_DBMetaData = cn.getMetaData();
            ResultSet colRet = null;
            ResultSetMetaData rsmd = null;
            ResultSet rss = null;
            for (String tbname : tableNames = new String[]{tableName, tableName.toUpperCase(), tableName.toLowerCase()}) {
                rs = this.tbPkCache.get(tbname);
                if (rs != null) {
                    return rs;
                }
                colRet = m_DBMetaData.getColumns(null, "%", tbname, "%");
                if (!colRet.next()) continue;
                rs = new Rs(tbname);
                rsmd = colRet.getMetaData();
                rss = cn.getMetaData().getPrimaryKeys(null, null, tbname);
                break;
            }
            if (rsmd == null) {
                throw new JDiySqlException(Locale.DBG.getString("err.Rs.tableNotExists"), tableName);
            }
            do {
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    rs.set(rsmd.getColumnName(i + 1), colRet.getString(rsmd.getColumnName(i + 1)));
                }
            } while (colRet.next());
            ArrayList<String> pks = new ArrayList<String>();
            while (rss.next()) {
                pks.add(rss.getString(4));
            }
            rs.setPK(pks.toArray(new String[pks.size()]));
            this.tbPkCache.put(rs.getTable(), rs);
        }
        return rs;
    }

    private Ls ls(Args args, boolean isGetOne) {
        int rowCount = 0;
        if (args.getPageSize() > 0) {
            rowCount = isGetOne ? 1 : this.len(args.clone());
        }
        String filter = args.getFilter() != null && !args.getFilter().trim().equals("") ? args.getFilter() : null;
        int pageStart = Math.max((args.getAbsPage() - 1) * args.getPageSize(), 0);
        if (args.getAbsPage() > 1 && "mssql".equalsIgnoreCase(this.getDbType())) {
            Args a = new Args(args.getTable(), filter, args.getCols());
            return this.ls(this.connPool.getEngine().getPageBreakSql(a, filter, 0), args.getPageSize(), args.getAbsPage());
        }
        String sql = this.connPool.getEngine().getPageBreakSql(args, filter, pageStart);
        Connection cn = this.Conn == null ? this.connPool.getConnection() : this.Conn;
        Statement smt = null;
        ResultSet rs = null;
        if (this.context.isShowSql()) {
            log.info(sql);
        }
        try {
            smt = cn.createStatement();
            rs = smt.executeQuery(sql);
            String tableName = this.connPool.getEngine().getTableName(rs.getMetaData());
            if ("".equals(tableName)) {
                tableName = args.getTable().trim();
                int pos = tableName.indexOf(",");
                if (pos != -1) {
                    tableName = tableName.substring(0, pos);
                }
                if ((pos = tableName.indexOf(" ")) != -1) {
                    tableName = tableName.substring(0, pos);
                }
                if ("oracle".equalsIgnoreCase(this.getDbType())) {
                    tableName = tableName.toUpperCase();
                }
            }
            String[] tbpk = this.getTableInfo(cn, tableName).getPK();
            Ls ls = this.initLs(tableName, rs, rowCount, args.getPageSize(), args.getAbsPage(), tbpk);
            return ls;
        }
        catch (SQLException e) {
            this.transRollBack();
            throw new JDiySqlException(e.getMessage(), e.getCause());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (smt != null) {
                    smt.close();
                }
            }
            catch (SQLException ignore) {}
            if (this.Conn == null) {
                this.connPool.releaseConnection(cn);
            }
        }
    }

    @Override
    public Ls ls(Args args) {
        return this.ls(args, false);
    }

    private Ls initLs(String tableName, ResultSet rs, int rowCount, int pageSize, int absPage, String[] primaryKeys) throws SQLException {
        ArrayList<Rs> al = new ArrayList<Rs>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int c = 0;
        while (rs.next() && (c++ < pageSize || pageSize == 0)) {
            al.add(this.connPool.getEngine().convertRs(rsmd, rs, tableName, primaryKeys, this.context.getDataPath()));
        }
        Rs[] datas = new Rs[al.size()];
        al.toArray(datas);
        if (pageSize == 0) {
            rowCount = datas.length;
        }
        Rs one = datas.length > 0 ? datas[0] : this.connPool.getEngine().convertRs(rsmd, null, tableName, primaryKeys, null);
        return new LsImpl(rowCount, pageSize, absPage, datas, one);
    }

    @Override
    public void save(Rs[] dats) {
        Object[] lastNeedPersist = null;
        String lastTable = null;
        String[] pk = null;
        String fds = null;
        String filter = null;
        ResultSet rs = null;
        Statement psSelect = null;
        Statement psInsert = null;
        Statement psUpdate = null;
        int upCount = 0;
        String connName = this.connPool.getEngine().getName();
        Connection cn = this.Conn == null ? this.connPool.getConnection() : this.Conn;
        try {
            for (Rs d : dats) {
                int i;
                int i2;
                boolean notSameLast;
                ArrayList<String> sD = new ArrayList<String>();
                HashMap<String, DbField> field = new HashMap<String, DbField>();
                for (DbField fd : d.fdDmap.values()) {
                    if (!fd.isChanged() && connName.equals(d.connName)) continue;
                    sD.add(fd.getRealName());
                    field.put(fd.getRealName(), fd);
                }
                int needPersistSize = sD.size();
                if (needPersistSize <= 0) continue;
                Object[] needPersist = new String[needPersistSize];
                sD.toArray(needPersist);
                boolean bl = notSameLast = !Arrays.equals(needPersist, lastNeedPersist);
                if (notSameLast || !d.getTable().equals(lastTable)) {
                    if (d.getPK() == null) {
                        Rs tableInfo = this.getTableInfo(cn, d.getTable());
                        d.PK = tableInfo.getPK();
                        d.table = tableInfo.getTable();
                    }
                    if (d.getPK() == null) {
                        throw new JDiySqlException(Locale.DBG.getString("err.Rs.noPK"));
                    }
                    pk = d.getPK();
                    lastNeedPersist = needPersist;
                    lastTable = d.getTable();
                    fds = Arrays.toString(needPersist);
                    fds = fds.substring(1, fds.length() - 1);
                    StringBuilder sb = new StringBuilder("SELECT ").append(fds).append(" FROM ").append(d.getTable());
                    StringBuilder sb1 = new StringBuilder(" WHERE ");
                    for (i2 = 0; i2 < pk.length; ++i2) {
                        if (i2 > 0) {
                            sb1.append(" AND ");
                        }
                        sb1.append(pk[i2]).append("=?");
                    }
                    filter = sb1.toString();
                    psSelect = cn.prepareStatement(sb.append(filter).toString());
                    if (this.context.isShowSql()) {
                        log.info(sb.toString());
                    }
                }
                for (int i3 = 0; i3 < pk.length; ++i3) {
                    psSelect.setObject(i3 + 1, d.isTemporary ? d.getDataField(pk[i3]).getObject() : d.getDataField(pk[i3]).getInitObject());
                }
                rs = psSelect.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int[] colTypes = new int[rsmd.getColumnCount()];
                for (i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                    colTypes[i2] = rsmd.getColumnType(i2 + 1);
                }
                boolean isAdd = true;
                if (rs.next()) {
                    isAdd = false;
                    if (rs.next()) {
                        throw new JDiyFieldException(Locale.DBG.getString("err.DaoImpl.pkNotUnique"));
                    }
                }
                if (isAdd) {
                    DbField fd;
                    if (notSameLast) {
                        if (upCount > 0 && this.context.isShowSql()) {
                            log.info(Locale.DBG.getString("log.DaoImpl.saved"), (Object)upCount);
                        }
                        char[] sa = new char[needPersistSize];
                        Arrays.fill(sa, '?');
                        String s = Arrays.toString(sa);
                        s = s.substring(1, s.length() - 1);
                        String sql = "INSERT INTO " + d.getTable() + " (" + fds + ") VALUES (" + s + ")";
                        if (this.context.isShowSql()) {
                            log.info(sql);
                        }
                        upCount = 0;
                        psInsert = "sqlite".equalsIgnoreCase(this.getDbType()) ? cn.prepareStatement(sql) : cn.prepareStatement(sql, pk);
                    }
                    this.saveField(colTypes, (PreparedStatement)psInsert, field, (String[])needPersist);
                    upCount += psInsert.executeUpdate();
                    if ("sqlite".equalsIgnoreCase(this.getDbType())) {
                        ResultSet rsgk;
                        String psql = "SELECT LAST_INSERT_ROWID()";
                        if (this.context.isShowSql()) {
                            log.info(psql);
                        }
                        if ((rsgk = cn.prepareStatement(psql).executeQuery()) != null && rsgk.next()) {
                            fd = new DbField(pk[0], pk[0], rs.getType(), rsgk.getObject(1), null, false, false);
                            String lowerName = pk[0].toLowerCase();
                            d.fdDmap.put(lowerName, fd);
                        }
                    } else {
                        ResultSet rsgk = psInsert.getGeneratedKeys();
                        if (rsgk != null && rsgk.next()) {
                            for (int i4 = 0; i4 < pk.length; ++i4) {
                                fd = new DbField(pk[i4], pk[i4], rs.getType(), rsgk.getObject(i4 + 1), null, false, false);
                                d.fdDmap.put(pk[0].toLowerCase(), fd);
                            }
                        }
                    }
                    for (i = 0; i < needPersistSize; ++i) {
                        ((DbField)field.get(needPersist[i])).toPersist();
                    }
                } else {
                    if (notSameLast) {
                        if (upCount > 0 && this.context.isShowSql()) {
                            log.info(Locale.DBG.getString("log.DaoImpl.saved"), (Object)upCount);
                        }
                        StringBuilder sb = new StringBuilder("UPDATE ").append(d.getTable()).append(" SET ");
                        for (int i5 = 0; i5 < needPersistSize; ++i5) {
                            if (i5 > 0) {
                                sb.append(", ");
                            }
                            sb.append((String)needPersist[i5]).append("=?");
                        }
                        String sql = sb.append(filter).toString();
                        if (this.context.isShowSql()) {
                            log.info(sql);
                        }
                        upCount = 0;
                        psUpdate = cn.prepareStatement(sql);
                    }
                    this.saveField(colTypes, (PreparedStatement)psUpdate, field, (String[])needPersist);
                    for (i = 0; i < pk.length; ++i) {
                        psUpdate.setObject(needPersistSize + i + 1, d.isTemporary ? d.getDataField(pk[i]).getObject() : d.getDataField(pk[i]).getInitObject());
                    }
                    upCount += psUpdate.executeUpdate();
                    for (i = 0; i < needPersistSize; ++i) {
                        ((DbField)field.get(needPersist[i])).toPersist();
                    }
                }
                d.isTemporary = false;
                d.isNull = false;
                d.dataPath = this.context.getDataPath();
            }
            if (upCount > 0 && this.context.isShowSql()) {
                log.info(Locale.DBG.getString("log.DaoImpl.saved"), (Object)upCount);
            }
        }
        catch (SQLException e) {
            this.transRollBack();
            e.printStackTrace();
            throw new JDiySqlException(e.getMessage(), e.getCause());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (psInsert != null) {
                    psInsert.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (psUpdate != null) {
                    psUpdate.close();
                }
            }
            catch (SQLException ignore) {}
            if (this.Conn == null) {
                this.connPool.releaseConnection(cn);
            }
        }
        for (Rs d : dats) {
            String id;
            if (d.getPK().length != 1) continue;
            StringBuilder sb = new StringBuilder(this.context.getDataPath());
            sb.append(File.separator).append("entity");
            String path1 = sb.toString();
            try {
                id = d.get(d.getPK()[0]);
            }
            catch (JDiyException ignore) {
                continue;
            }
            if (id == null || "".equals(id)) continue;
            sb.append(File.separator).append(id.substring(id.length() - 1));
            String path2 = sb.toString();
            sb.append(File.separator).append(id).append(File.separator);
            String idPath = sb.toString();
            if (d.isChangedXml) {
                XmlField.toPersist(d, this.context.getDataPath(), d.fdXmap);
                d.isChangedXml = false;
            }
            if (d.fdFmap != null) {
                for (FileField f : d.fdFmap.values()) {
                    f.setId(id);
                    f.setDataPath(this.context.getDataPath());
                    f.toPersist();
                }
                d.fdFmap = null;
            }
            Fs.delEmpty(idPath);
            Fs.delEmpty(path2);
            Fs.delEmpty(path1);
        }
    }

    @Override
    public void save(Rs d) {
        this.save(new Rs[]{d});
    }

    private void saveField(int[] colTypes, PreparedStatement ps, Map<String, DbField> field, String[] needPersist) {
        try {
            int s = needPersist.length;
            block17: for (int i = 0; i < s; ++i) {
                DbField df = field.get(needPersist[i]);
                Converter c = Converter.newInstance(df.getObject());
                int colType = colTypes[i];
                if ("sqlite".equalsIgnoreCase(this.getDbType())) {
                    ps.setString(i + 1, c.convertToString());
                    continue;
                }
                switch (colType) {
                    case -7: 
                    case 16: {
                        int ic;
                        if (!"mysql".equalsIgnoreCase(this.getDbType()) || df.getObject() == null || (ic = c.convertToInt().intValue()) == 0 || ic == 1) {
                            Boolean b = c.convertToBoolean();
                            if (b == null) {
                                ps.setNull(i + 1, colType);
                                continue block17;
                            }
                            ps.setBoolean(i + 1, b);
                            continue block17;
                        }
                    }
                    case -6: {
                        Byte b1 = c.convertToByte();
                        if (b1 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setByte(i + 1, b1);
                        continue block17;
                    }
                    case 5: {
                        Short s1 = c.convertToShort();
                        if (s1 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setShort(i + 1, s1);
                        continue block17;
                    }
                    case 4: {
                        Integer i1 = c.convertToInt();
                        if (i1 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setInt(i + 1, i1);
                        continue block17;
                    }
                    case -5: {
                        Long l1 = c.convertToLong();
                        if (l1 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setLong(i + 1, l1);
                        continue block17;
                    }
                    case 6: 
                    case 7: {
                        Float f1 = c.convertToFloat();
                        if (f1 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setFloat(i + 1, f1.floatValue());
                        continue block17;
                    }
                    case 8: {
                        Double d1 = c.convertToDouble();
                        if (d1 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setDouble(i + 1, d1);
                        continue block17;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bd = c.convertToDecimal();
                        if (bd == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setBigDecimal(i + 1, bd);
                        continue block17;
                    }
                    case 2005: {
                        String s3 = c.convertToString();
                        if (s3 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setCharacterStream(i + 1, (Reader)new StringReader(s3), s3.length() + 1);
                        continue block17;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        String s2 = c.convertToString();
                        if (s2 == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setString(i + 1, s2);
                        continue block17;
                    }
                    case 93: {
                        java.util.Date dt = c.convertToDate();
                        if (dt == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setTimestamp(i + 1, new Timestamp(dt.getTime()));
                        continue block17;
                    }
                    case 91: {
                        java.util.Date dt = c.convertToDate();
                        if (dt == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setDate(i + 1, new Date(dt.getTime()));
                        continue block17;
                    }
                    case 92: {
                        java.util.Date dt = c.convertToDate();
                        if (dt == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setTime(i + 1, new Time(dt.getTime()));
                        continue block17;
                    }
                    default: {
                        Object o = df.getObject();
                        if (o == null) {
                            ps.setNull(i + 1, colType);
                            continue block17;
                        }
                        ps.setObject(i + 1, o);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new JDiySqlException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void transBegin() {
        this.transBegin(2);
    }

    @Override
    public void transBegin(int level) {
        if (this.transExists()) {
            this.transRollBack();
            throw new JDiyTransException(Locale.DBG.getString("err.DaoImpl.transIsExists"));
        }
        this.Conn = this.connPool.getConnection();
        try {
            this.Conn.setTransactionIsolation(level);
            this.Conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.connPool.releaseConnection(this.Conn);
            this.Conn = null;
            throw new JDiySqlException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void transCommit() {
        if (this.transExists()) {
            try {
                this.Conn.commit();
                this.Conn.setAutoCommit(true);
                this.Conn.setTransactionIsolation(2);
            }
            catch (SQLException e) {
                throw new JDiyTransException(e.getMessage(), e.getCause());
            }
            this.connPool.releaseConnection(this.Conn);
            this.Conn = null;
        }
    }

    @Override
    public boolean transExists() {
        return this.Conn != null;
    }

    @Override
    public void transRollBack() {
        if (this.transExists()) {
            try {
                this.Conn.rollback();
                this.Conn.setAutoCommit(true);
                this.Conn.setTransactionIsolation(2);
            }
            catch (SQLException e) {
                throw new JDiyTransException(e.getMessage(), e.getCause());
            }
            this.connPool.releaseConnection(this.Conn);
            this.Conn = null;
        }
    }

    @Override
    public void transRollBack(Savepoint sp) {
        try {
            if (sp == null) {
                this.transRollBack();
            } else if (this.transExists()) {
                this.Conn.rollback(sp);
            }
        }
        catch (SQLException e) {
            throw new JDiyTransException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Savepoint transSave() {
        try {
            return this.Conn.setSavepoint();
        }
        catch (SQLException e) {
            throw new JDiyTransException(e.getMessage(), e.getCause());
        }
    }
}

