/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.io.IOException;
import java.util.Enumeration;
import net.jdiy.core.ActionEntity;
import net.jdiy.core.ActionInvoker;
import net.jdiy.core.App;
import net.jdiy.core.ContextImpl;
import net.jdiy.core.Rs;
import net.jdiy.core.ex.JDiyActionException;
import net.jdiy.core.ex.JDiyIOException;
import net.jdiy.core.ex.JDiyParamException;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Txt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JDiyAction {
    protected static final Logger log = LoggerFactory.getLogger(JDiyAction.class);

    public static Rs getRs(String tableName, String prefix) {
        return JDiyAction.getRs(tableName, prefix, "xml");
    }

    public static Rs getRs(String tableName, String prefix, String xml) {
        Object s1;
        String s;
        if (tableName == null || "".equals(tableName)) {
            throw new JDiyParamException(Locale.DBG.getString("err.Args.tableNull"));
        }
        if (prefix == null) {
            prefix = "";
        }
        if (!"".equals(prefix) && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (xml == null || "".equals(xml)) {
            xml = "xml";
        }
        App app = App.get();
        Rs rs = new Rs(tableName);
        Enumeration<String> qs = app.getNames();
        Enumeration<String> qf = app.getFileNames();
        if (qs != null) {
            while (qs.hasMoreElements()) {
                s = qs.nextElement();
                if (!s.startsWith(prefix) || s.length() <= prefix.length()) continue;
                s1 = s.substring(prefix.length()).split("\\.");
                if (((String[])s1).length == 1) {
                    rs.set(s1[0], Txt.join(app.getValues(s), ", "));
                    continue;
                }
                if (((String[])s1).length != 2 || !s1[1].equals(xml)) continue;
                rs.setX(s1[0], Txt.join(app.getValues(s), ", "));
            }
        }
        if (qf != null) {
            while (qf.hasMoreElements()) {
                s = qf.nextElement();
                if (!s.startsWith(prefix) || s.length() <= prefix.length()) continue;
                s1 = s.substring(prefix.length());
                rs.setF((String)s1, app.getFile(s));
            }
        }
        return rs;
    }

    public static void setAttr(String name, Object object) {
        App app = App.get();
        app.getRequest().setAttribute(name, object);
    }

    public static void forward(String view) {
        ActionInvoker.getJspInvoker().invoke(view);
    }

    public static void forwardAction(String actionUrl) throws Exception {
        String uri;
        if (actionUrl.startsWith("/")) {
            uri = actionUrl;
        } else {
            if (actionUrl.startsWith("./")) {
                actionUrl = actionUrl.substring(2);
            }
            int count = Txt.containSum(actionUrl, "../");
            String[] sa = (JDiyAction.getUrl() + "ss").split("/");
            if (sa.length - 2 < count) {
                throw new JDiyActionException(Locale.DBG.getString("action.invalid"), actionUrl);
            }
            uri = "";
            for (int i = 0; i < sa.length - count - 1; ++i) {
                uri = uri + sa[i] + "/";
            }
            uri = uri + actionUrl.replaceAll("\\.\\./", "");
        }
        ActionEntity ae = ((ContextImpl)App.get().getContext()).getActionEntity(uri);
        if (ae != null) {
            ae.invoke();
        } else {
            App.get().getResponse().sendError(404, Txt.inject(Locale.DBG.getString("action.invalid"), uri));
        }
    }

    public static void redirect(String url) {
        try {
            App.get().getResponse().sendRedirect(url);
        }
        catch (IOException e) {
            throw new JDiyIOException(e.getCause());
        }
    }

    public static String getUrl() {
        String contextPath;
        String uri = App.get().getRequest().getRequestURI();
        if (!uri.startsWith(contextPath = App.get().getRequest().getContextPath())) {
            contextPath = "";
        }
        if (contextPath != null) {
            uri = uri.substring(contextPath.length());
        }
        return uri;
    }
}

