/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jdiy.core.ActionEntity;
import net.jdiy.core.App;
import net.jdiy.core.Context;
import net.jdiy.core.ContextImpl;
import net.jdiy.core.db.ConnPool;
import net.jdiy.core.ex.JDiyConfigException;
import net.jdiy.core.ex.JDiyException;
import net.jdiy.core.ex.JDiySecurityException;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Txt;
import net.jdiy.web.WebHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDiyLoadFilter
implements Filter {
    private static final Map<String, String[]> secChk = new HashMap<String, String[]>();
    private String appRoot;
    private Map<String, String[]> chkMap;
    private String xmlLocation;
    private Integer keepActiveInSeconds = 0;
    private Timer timer = null;
    private static final Logger log;

    private synchronized Context initContext() {
        URL configXml;
        Context context = App.contextMap.get(this.appRoot);
        if (context != null) {
            return context;
        }
        log.info(Locale.DBG.getString("log.webloader.init"));
        try {
            if (this.xmlLocation.contains("://")) {
                configXml = new URL(this.xmlLocation);
            } else if (this.xmlLocation.startsWith("/")) {
                File f = new File(this.xmlLocation);
                if (!f.exists()) {
                    f = new File(this.appRoot + this.xmlLocation);
                }
                configXml = f.toURI().toURL();
            } else {
                configXml = new File(this.appRoot + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + this.xmlLocation).toURI().toURL();
            }
        }
        catch (Exception ex) {
            throw new JDiyConfigException(ex.getMessage(), ex.getCause());
        }
        context = new ContextImpl(configXml, this.appRoot);
        App.contextMap.put(this.appRoot, context);
        if (this.chkMap == null) {
            String[] ss;
            this.chkMap = new HashMap<String, String[]>();
            String[] arr$ = ss = new String[]{"inject-check", "inject-uncheck", "rss-check", "rss-uncheck"};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String s;
                String prop = context.getJDiyProp(s = arr$[i$]);
                this.chkMap.put(s, null != prop && !"".equals(prop) ? Txt.split(prop, ":") : new String[]{});
            }
            this.keepActiveInSeconds = 60 * Txt.parseInt(context.getJDiyProp("keepActive"), 10);
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Context c = App.contextMap.get(JDiyLoadFilter.this.appRoot);
                    if (c != null && c.getFreeTime() > (long)(1000 * JDiyLoadFilter.this.keepActiveInSeconds)) {
                        log.info(Locale.DBG.getString("log.webloader.longfree"), (Object)JDiyLoadFilter.this.appRoot, (Object)(JDiyLoadFilter.this.keepActiveInSeconds / 60));
                        JDiyLoadFilter.this.destroy();
                    }
                }
            }, new Date(), 1000L);
            log.info(Locale.DBG.getString("log.webloader.timerInfo"), (Object)this.appRoot, (Object)(this.keepActiveInSeconds / 60));
        }
        return context;
    }

    public void destroy() {
        log.info(Locale.DBG.getString("log.webloader.destroy"));
        Context cx = App.contextMap.get(this.appRoot);
        if (cx != null) {
            for (Map.Entry<String, ConnPool> e : cx.getConnPools().entrySet()) {
                e.getValue().destroy();
            }
            log.info(Locale.DBG.getString("log.webloader.destroyDb"));
            App.contextMap.remove(this.appRoot);
            this.chkMap = null;
            this.keepActiveInSeconds = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        log.info(Locale.DBG.getString("log.webloader.destroied"), (Object)this.appRoot);
    }

    public void init(FilterConfig conf) throws ServletException {
        try {
            log.info(Locale.DBG.getString("log.webloader.javaeeWelcome"));
            this.appRoot = conf.getServletContext().getRealPath("");
            this.xmlLocation = conf.getInitParameter("xmlLocation");
            if (this.xmlLocation == null) {
                log.info(Locale.DBG.getString("log.webloader.defConfLoc"));
                this.xmlLocation = "jdiy.xml";
            }
            this.initContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        HttpServletRequest req = (HttpServletRequest)request;
        try {
            ActionEntity ae;
            String queryString;
            if (req.getCharacterEncoding() == null) {
                req.setCharacterEncoding("utf-8");
            }
            res.setCharacterEncoding("UTF-8");
            res.setHeader("JDiy-Version", "JDiy-2.1");
            res.setHeader("JDiy-Support", "http://jdiy.net");
            res.setHeader("JDiy-Author", "Folier ( QQ:39886616 )");
            Context context = App.contextMap.get(this.appRoot);
            if (context == null) {
                context = this.initContext();
            }
            context.visit();
            String uri = req.getRequestURI();
            String contextPath = req.getContextPath();
            if (!uri.startsWith(contextPath)) {
                contextPath = "";
            }
            if (contextPath != null) {
                uri = uri.substring(contextPath.length());
            }
            App app = new App(req, (ServletResponse)res, contextPath);
            req = app.getRequest();
            App.localContext.set(app);
            String loginPath = context.getJDiyProp("loginPath");
            if (uri.startsWith(loginPath)) {
                if (!(WebHelper.isLogin() || uri.equals(context.getJDiyProp("loginPage")) || app.get("~").endsWith("@Public") || app.get("~").endsWith("@Jde"))) {
                    res.sendRedirect(contextPath + context.getJDiyProp("loginPage") + "?s=timeout");
                    return;
                }
                if (uri.equals(loginPath)) {
                    Class<?> c = Class.forName("net.jdiy.web.console.ViewIndex");
                    c.getMethod(WebHelper.isLogin() ? "index" : "login", new Class[0]).invoke(c.newInstance(), new Object[0]);
                    return;
                }
                if (uri.equals(loginPath + "~.jd")) {
                    String[] cf = app.get("~").split("@");
                    Class<?> c = Class.forName("net.jdiy.web.console.View" + cf[1]);
                    c.getMethod("".equals(cf[0]) ? "service" : cf[0], new Class[0]).invoke(c.newInstance(), new Object[0]);
                    return;
                }
            }
            if ((queryString = req.getQueryString()) != null && !queryString.equals("")) {
                String ss = new Txt(queryString.toLowerCase()).replace("[a-z0-9/\\._]*=[a-z0-9/\\._]*", "=").toString();
                for (String key : new String[]{"rss", "inject"}) {
                    String[] val;
                    if (!this.contain(uri, this.chkMap.get(key + "-check")) && this.contain(uri, this.chkMap.get(key + "-uncheck"))) continue;
                    for (String cs : val = secChk.get(key)) {
                        if (!ss.contains(cs)) continue;
                        String tips = context.getJDiyProp(key + "-tips");
                        if (tips == null) {
                            String s = Locale.DBG.getString("err.webloader." + key + "Checked");
                            log.error(Locale.DBG.getString("log.webloader." + key + "Checked"), (Object)uri, (Object)s);
                            throw new JDiySecurityException(s);
                        }
                        if (tips.startsWith("TEXT:")) {
                            res.getWriter().print(tips.substring(5));
                        } else if (tips.startsWith("FILE:")) {
                            req.getRequestDispatcher(tips.substring(5)).forward((ServletRequest)req, (ServletResponse)res);
                        } else {
                            throw new JDiySecurityException(tips.substring(6));
                        }
                        return;
                    }
                }
            }
            if ((ae = ((ContextImpl)context).getActionEntity(uri)) != null) {
                ae.invoke();
                return;
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        catch (JDiyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RuntimeException se = new RuntimeException(ex.getMessage(), ex.getCause());
            se.setStackTrace(ex.getStackTrace());
            throw se;
        }
        finally {
            App.localContext.remove();
        }
    }

    private boolean contain(String requestURI, String[] arr) {
        for (String s : arr) {
            if (s == null || (!(s = s.trim()).endsWith("/") || !requestURI.startsWith(s)) && !requestURI.equals(s)) continue;
            return true;
        }
        return false;
    }

    static {
        secChk.put("inject", new String[]{"and", "or", "exec", "insert", "select", "delete", "update", "count", "truncate", "chr", "mid", "master", "char"});
        secChk.put("rss", new String[]{"onmouseover", "onmouseout", "onmousedown", "onmouseup", "onmousemove", "onclick", "ondblclick", "onkeypress", "onkeydown", "onkeyup", "ondragstart", "onerrorupdate", "onhelp", "onreadystatechange", "onrowenter", "onrowexit", "onselectstart", "onload", "onunload", "onbeforeunload", "onblur", "onerror", "onfocus", "onresize", "onscroll", "oncontextmenu", "expression", "lowsrc", "cookie", "javascript", "vbscript", "firefoxurl", "livescript", "ms-its", "mhtml", "firefoxurl", "mocha", "<", "%3c", ">", "%3e", "\"", "%22", "\\", "%5c", "'", "%27", "%25", "%3d", "%00"});
        log = LoggerFactory.getLogger(JDiyLoadFilter.class);
    }
}

