/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConfigException;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.ex.JDiyFieldException;
import net.jdiy.core.field.DbField;
import net.jdiy.core.field.FileField;
import net.jdiy.core.field.XmlField;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Fn;
import net.jdiy.util.Txt;

public class Rs
implements Serializable {
    public static final long serialVersionUID = 1902885770180894882L;
    private static long L = System.currentTimeMillis();
    protected boolean isNull;
    protected String dataPath;
    protected String table;
    protected String connName;
    protected Map<String, DbField> fdDmap;
    boolean isTemporary;
    Map<String, XmlField> fdXmap;
    Map<String, FileField> fdFmap;
    boolean isChangedXml = false;
    String[] PK;

    public Rs(String table) {
        this.setPK(new String[0]);
        this.table = table;
        this.fdDmap = new HashMap<String, DbField>();
        this.isTemporary = true;
        this.isNull = true;
    }

    public String get(String field) {
        String s = this.getString(field);
        return s == null ? "" : s;
    }

    public String getText(String field) {
        String txt = this.getString(field);
        return null == txt ? "" : Txt.htmlToText(txt);
    }

    public String get(String field, int size) {
        String txt = this.getText(field);
        return null == txt || "".equals(txt) ? "" : Txt.cut(txt, size);
    }

    public boolean getBoolean(String field) {
        return this.getDataField(field).getBoolean();
    }

    public Byte getByte(String field) {
        return this.getDataField(field).getByte();
    }

    public byte getByte(String field, byte defV) {
        Byte b;
        try {
            b = this.getByte(field);
        }
        catch (Exception ex) {
            b = null;
        }
        return b == null ? defV : b;
    }

    public java.util.Date getDate(String field) {
        return this.getDataField(field).getDate();
    }

    public String getDate(String field, String pattern) {
        java.util.Date date;
        if (null == pattern) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        return null == (date = this.getDate(field)) ? "" : new SimpleDateFormat(pattern).format(date);
    }

    public Double getDouble(String field) {
        return this.getDataField(field).getDouble();
    }

    public double getDouble(String field, double defV) {
        Double d;
        try {
            d = this.getDouble(field);
        }
        catch (Exception ex) {
            d = null;
        }
        return null == d ? defV : d;
    }

    public BigDecimal getDecimal(String field) {
        return this.getDataField(field).getDecimal();
    }

    public Float getFloat(String field) {
        return this.getDataField(field).getFloat();
    }

    public float getFloat(String field, float defV) {
        Float f;
        try {
            f = this.getFloat(field);
        }
        catch (Exception ex) {
            f = null;
        }
        return null == f ? defV : f.floatValue();
    }

    public Integer getInt(String field) {
        return this.getDataField(field).getInt();
    }

    public int getInt(String field, int defV) {
        Integer i;
        try {
            i = this.getInt(field);
        }
        catch (Exception ex) {
            i = null;
        }
        return null == i ? defV : i;
    }

    public String getJson() {
        return this.getJson(":all", null, null);
    }

    public String getJson(String cols, String xCols, String fCols) {
        String[] aFCols;
        ArrayList<String> pp = new ArrayList<String>();
        String[] aCols = cols == null || "".equals(cols = cols.trim()) ? new String[]{} : (cols.equalsIgnoreCase(":all") ? this.getCols() : Txt.split(cols.replaceAll("\\s", ""), ","));
        for (String s : aCols) {
            pp.add("\t\"" + s + "\": " + this.getDataField(s).getJson());
        }
        String[] aXCols = xCols == null || "".equals(xCols = xCols.trim()) ? new String[]{} : (xCols.equalsIgnoreCase(":all") ? this.getXCols() : Txt.split(xCols.replaceAll("\\s", ""), ","));
        int len = aXCols.length;
        if (len > 0) {
            if (this.fdXmap.get("xml") != null) {
                throw new JDiyConvertException(Txt.inject(Locale.DBG.getString("err.Rs.xfConflict"), "xml", "xml"));
            }
            StringBuilder sb1 = new StringBuilder("\t\"xml\": {\r\n");
            for (int i = 0; i < len; ++i) {
                sb1.append("\t\t\"").append(aXCols[i]).append("\": ").append(Converter.newInstance(this.getX(aXCols[i])).convertToJsonString());
                if (i < len - 1) {
                    sb1.append(",");
                }
                sb1.append("\r\n");
            }
            sb1.append("\t}");
            pp.add(sb1.toString());
        }
        if ((len = (aFCols = fCols == null || "".equals(fCols = fCols.trim()) ? new String[]{} : (fCols.equalsIgnoreCase(":all") ? this.getFCols() : Txt.split(fCols.replaceAll("\\s", ""), ","))).length) > 0) {
            if (this.fdFmap.get("file") != null) {
                throw new JDiyConvertException(Txt.inject(Locale.DBG.getString("err.Rs.xfConflict"), "file", "file"));
            }
            StringBuilder sb1 = new StringBuilder("\t\"file\": {\r\n");
            for (int i = 0; i < len; ++i) {
                String ff;
                String[] fs = this.getFs(aFCols[i]);
                int len1 = fs.length;
                if (fs == null || len1 == 0) {
                    ff = "null";
                } else if (len1 == 1) {
                    ff = Converter.newInstance(fs[0]).convertToJsonString();
                } else {
                    StringBuilder fsb = new StringBuilder("[");
                    for (int j = 0; j < len1; ++j) {
                        fsb.append(Converter.newInstance(fs[j]).convertToJsonString());
                        if (j >= len1 - 1) continue;
                        fsb.append(", ");
                    }
                    fsb.append("]");
                    ff = fsb.toString();
                }
                sb1.append("\t\t\"").append(aFCols[i]).append("\": ").append(ff);
                if (i < len - 1) {
                    sb1.append(",");
                }
                sb1.append("\r\n");
            }
            sb1.append("\t}");
            pp.add(sb1.toString());
        }
        StringBuilder sb = new StringBuilder("{\r\n");
        int size = pp.size();
        for (int i = 0; i < size; ++i) {
            sb.append((String)pp.get(i));
            if (i < size - 1) {
                sb.append(",");
            }
            sb.append("\r\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public Long getLong(String field) {
        return this.getDataField(field).getLong();
    }

    public long getLong(String field, long defV) {
        Long r;
        try {
            r = this.getLong(field);
        }
        catch (Exception ex) {
            r = null;
        }
        return null == r ? defV : r;
    }

    public String getString(String field) {
        return this.getDataField(field).getString();
    }

    public Short getShort(String field) {
        return this.getDataField(field).getShort();
    }

    public short getShort(String field, short defV) {
        Short s;
        try {
            s = this.getShort(field);
        }
        catch (Exception ex) {
            s = null;
        }
        return null == s ? defV : s;
    }

    public Integer getType(String field) {
        return this.getDataField(field).getType();
    }

    public String getTypeName(String field) {
        return DbField.typeOf(this.getType(field));
    }

    public String getF(String field) {
        this.lazyLoadFile();
        FileField ff = this.fdFmap.get(field.toLowerCase());
        return ff == null ? null : ff.getF();
    }

    public String[] getFs(String field) {
        this.lazyLoadFile();
        FileField ff = this.fdFmap.get(field.toLowerCase());
        return ff == null ? null : ff.getFs();
    }

    public File getFile(String field) {
        this.lazyLoadFile();
        FileField ff = this.fdFmap.get(field.toLowerCase());
        return ff == null ? null : ff.getFile();
    }

    public File[] getFiles(String field) {
        this.lazyLoadFile();
        FileField ff = this.fdFmap.get(field.toLowerCase());
        return ff == null ? null : ff.getFiles();
    }

    public String getX(String field) {
        this.lazyLoadXml();
        XmlField fx = this.fdXmap.get(field.toLowerCase());
        String rtn = fx != null ? fx.toString() : "";
        return rtn == null ? "" : rtn;
    }

    public String getX(String field, int size) {
        String txt = this.getX(field);
        txt = null == txt ? "" : new Txt(txt).replace("<(.|\n|\r)+?>", "").replace("\\s{2,}", " ").toString();
        return size > 0 ? Txt.cut(txt, size) : txt;
    }

    public String[] getCols() {
        int i = 0;
        Set<Map.Entry<String, DbField>> set = this.fdDmap.entrySet();
        String[] r = new String[set.size()];
        for (Map.Entry<String, DbField> me : set) {
            r[i++] = me.getValue().getName();
        }
        return r;
    }

    public String[] getXCols() {
        this.lazyLoadXml();
        int i = 0;
        Set<Map.Entry<String, XmlField>> set = this.fdXmap.entrySet();
        String[] r = new String[set.size()];
        for (Map.Entry<String, XmlField> me : set) {
            r[i++] = me.getValue().getName();
        }
        return r;
    }

    public String[] getFCols() {
        this.lazyLoadFile();
        int i = 0;
        Set<Map.Entry<String, FileField>> set = this.fdFmap.entrySet();
        String[] r = new String[set.size()];
        for (Map.Entry<String, FileField> me : set) {
            r[i++] = me.getValue().getName();
        }
        return r;
    }

    public String[] getPK() {
        return this.PK == null ? null : (String[])this.PK.clone();
    }

    public Object getObject(String field) {
        return this.getDataField(field).getObject();
    }

    public Rs setPK(String ... PK) {
        if (Arrays.equals(this.PK, PK)) {
            return this;
        }
        String[] oldPk = this.PK;
        String[] stringArray = this.PK = PK.length == 0 ? null : PK;
        if (oldPk != null) {
            this.fdXmap = null;
            this.fdFmap = null;
        }
        return this;
    }

    public Rs set(String field, boolean value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, Byte value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, java.util.Date value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, Double value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, BigDecimal value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, Float value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, Integer value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, Long value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, Short value) {
        return this.setFieldValue(field, value);
    }

    public Rs set(String field, String value) {
        return this.setFieldValue(field, value);
    }

    public Rs setF(String field, File file) {
        if (file != null && file.isDirectory()) {
            throw new JDiyFieldException(Txt.inject(Locale.DBG.getString("err.Rs.notFile"), file.getAbsolutePath()));
        }
        this.lazyLoadFile();
        field = field.toLowerCase();
        if (!this.fdFmap.containsKey(field)) {
            this.fdFmap.put(field, new FileField(field).setNewFile(file));
        } else if (!Fn.contains(this.getFiles(field), file)) {
            this.fdFmap.get(field).setNewFile(file);
        }
        return this;
    }

    public Rs addF(String field, File file) {
        if (null == file) {
            return this;
        }
        if (file.isDirectory()) {
            throw new JDiyFieldException(Txt.inject(Locale.DBG.getString("err.Rs.notFile"), file.getAbsolutePath()));
        }
        this.lazyLoadFile();
        field = field.toLowerCase();
        if (!this.fdFmap.containsKey(field)) {
            this.fdFmap.put(field, new FileField(field).addFile(file));
        } else if (!Fn.contains(this.getFiles(field), file)) {
            this.fdFmap.get(field).addFile(file);
        }
        return this;
    }

    public Rs setX(String field, String value) {
        this.lazyLoadXml();
        String nml = field.toLowerCase();
        if (this.fdXmap.containsKey(nml)) {
            XmlField xf = this.fdXmap.get(nml);
            if (xf.toString() != null && xf.toString().equals(value) || xf.toString() == null && value == null) {
                return this;
            }
            xf.setName(field);
            xf.setValue(value);
        } else {
            this.fdXmap.put(nml, new XmlField(field, value));
        }
        this.isChangedXml = true;
        return this;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public Rs fillBy(Object bean, String skipFields, String xmlFields) {
        Method[] ms;
        if (bean == null) {
            return this;
        }
        Object[] aSkipFields = skipFields == null || "".equals(skipFields = skipFields.trim()) ? new String[]{} : Txt.split(skipFields.toLowerCase().replaceAll("\\s", ""), ",");
        Object[] aXmlFields = xmlFields == null || "".equals(xmlFields = xmlFields.trim()) ? new String[]{} : Txt.split(xmlFields.toLowerCase().replaceAll("\\s", ""), ",");
        for (Method m : ms = bean.getClass().getMethods()) {
            Class<?> rtnT;
            String name = m.getName();
            if (name.length() < 4 || (rtnT = m.getReturnType()) == Void.TYPE || "getClass".equals(name) || m.getParameterTypes().length != 0 || !name.startsWith("get")) continue;
            String field = m.getName().substring(3);
            String string = field = field.length() == 1 ? field.toLowerCase() : field.substring(0, 1).toLowerCase() + field.substring(1);
            if (Fn.contains(aSkipFields, field)) continue;
            int t = 0;
            try {
                String s;
                if (rtnT == File.class) {
                    t = 1;
                    File f = (File)m.invoke(bean, new Object[0]);
                    if (f == null) continue;
                    this.setF(field, f);
                    continue;
                }
                if (Fn.contains(aXmlFields, field)) {
                    t = 2;
                    s = Converter.newInstance(m.invoke(bean, new Object[0])).convertToString();
                    if (s == null) continue;
                    this.setX(field, s);
                    continue;
                }
                t = 3;
                s = Converter.newInstance(m.invoke(bean, new Object[0])).convertToString();
                if (s == null) continue;
                this.set(field, s);
            }
            catch (Exception e) {
                String tos;
                switch (t) {
                    case 1: {
                        tos = " -> Rs.setF(String, File). ";
                        break;
                    }
                    case 2: {
                        tos = " -> Rs.setX(String, " + rtnT.getName() + "). ";
                        break;
                    }
                    case 3: {
                        tos = " -> Rs.set(String, " + rtnT.getName() + "). ";
                        break;
                    }
                    default: {
                        tos = ". ";
                    }
                }
                throw new JDiyConvertException(String.format("invoke error: %s.%s()%s%s", bean.getClass().getName(), m.getName(), tos, e.getMessage()), e.getCause());
            }
        }
        return this;
    }

    public Rs fillTo(Object bean, boolean requiedX, boolean requiedF) {
        Method[] ms;
        if (bean == null) {
            return this;
        }
        if (requiedX) {
            this.lazyLoadXml();
        }
        if (requiedF) {
            this.lazyLoadFile();
        }
        for (Method m : ms = bean.getClass().getMethods()) {
            String name = m.getName();
            Class<?>[] pt = m.getParameterTypes();
            if (name.length() < 4 || pt.length != 1 || !name.startsWith("set")) continue;
            String field = name.substring(3);
            String fieldL = field.toLowerCase();
            Object val = null;
            boolean isDX = false;
            if (this.fdDmap.containsKey(fieldL)) {
                val = this.fdDmap.get(fieldL).getObject();
                isDX = true;
            } else if (requiedX && this.fdXmap.containsKey(fieldL)) {
                val = this.fdXmap.get(fieldL).toString();
                isDX = true;
            }
            try {
                if (isDX) {
                    Object v;
                    Converter c = Converter.newInstance(val);
                    if (String.class == pt[0]) {
                        v = c.convertToString();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (Integer.TYPE == pt[0] || Integer.class == pt[0]) {
                        v = c.convertToInt();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (Long.TYPE == pt[0] || Long.class == pt[0]) {
                        v = c.convertToLong();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (Double.TYPE == pt[0] || Double.class == pt[0]) {
                        v = c.convertToDouble();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (pt[0] == java.util.Date.class || pt[0] == Date.class || pt[0] == Time.class || pt[0] == Timestamp.class) {
                        v = c.convertToDate();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (Boolean.TYPE == pt[0] || Boolean.class == pt[0]) {
                        v = c.convertToBoolean();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (Short.TYPE == pt[0] || Short.class == pt[0]) {
                        v = c.convertToShort();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (Float.TYPE == pt[0] || Float.class == pt[0]) {
                        v = c.convertToFloat();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    if (Byte.TYPE == pt[0] || Byte.class == pt[0]) {
                        v = c.convertToByte();
                        if (v != null) {
                            m.invoke(bean, v);
                        }
                        continue;
                    }
                    throw new JDiyConvertException(Txt.inject(Locale.DBG.getString("err.Rs.invokeWrongMethod"), bean.getClass().getName(), m.getName(), m.getParameterTypes()[0].getName(), m.getName(), val.getClass().getName()));
                }
                if (!requiedF || !this.fdFmap.containsKey(fieldL)) continue;
                if (File.class == pt[0]) {
                    m.invoke(bean, this.getFile(fieldL));
                    continue;
                }
                if (String.class == pt[0]) {
                    m.invoke(bean, this.getF(field));
                    continue;
                }
                throw new JDiyConvertException(Txt.inject(Locale.DBG.getString("err.Rs.invokeWrongMethod"), bean.getClass().getName(), m.getName(), m.getParameterTypes()[0].getName(), m.getName(), "java.io.File"));
            }
            catch (Exception ex) {
                throw new JDiyConvertException(Txt.inject(Locale.DBG.getString("err.Rs.invokeForFillTo"), bean.getClass().getName(), m.getName(), m.getParameterTypes()[0].getName(), ex.toString()));
            }
        }
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public static synchronized String newId() {
        long l = System.currentTimeMillis();
        while (l == L) {
            l = System.currentTimeMillis();
        }
        L = l;
        String ident = Rs.Encoding("0123456789abcdefghijklmnopqrstuvwxyz".toCharArray(), L);
        switch (ident.length()) {
            case 9: {
                return "y" + ident;
            }
            case 8: {
                return "y0" + ident;
            }
            case 7: {
                return "y00" + ident;
            }
            case 6: {
                return "y000" + ident;
            }
        }
        throw new JDiyConfigException(Locale.DBG.getString("err.Rs.serverTimeInvalid"));
    }

    public String toString() {
        String[] p = this.getPK();
        for (int i = 0; i < p.length; ++i) {
            try {
                p[i] = this.get(p[i]);
                continue;
            }
            catch (JDiyConvertException e) {
                e.printStackTrace();
                continue;
            }
            catch (JDiyFieldException e) {
                e.printStackTrace();
            }
        }
        return Txt.join(p, ":") + "@" + this.getTable();
    }

    DbField getDataField(String field) {
        DbField fd = this.fdDmap.get(field.toLowerCase());
        if (fd == null) {
            if (this.isTemporary) {
                return new DbField(field, field, null, null, null, false, false);
            }
            throw new JDiyFieldException(Locale.DBG.getString("err.Rs.fieldInvalid"), field);
        }
        return fd;
    }

    private void lazyLoadXml() {
        if (this.fdXmap != null) {
            return;
        }
        this.fdXmap = XmlField.xmlLoad(this, this.dataPath);
    }

    private void lazyLoadFile() {
        if (this.fdFmap != null) {
            return;
        }
        this.fdFmap = FileField.fileLoad(this, this.dataPath);
    }

    private Rs setFieldValue(String field, Object value) {
        String fl = field.toLowerCase();
        if (this.fdDmap.containsKey(fl)) {
            this.fdDmap.get(fl).setObject(value);
        } else {
            DbField fd = new DbField(field, field, null, value, null, true, false);
            this.fdDmap.put(fl, fd);
        }
        return this;
    }

    private static String Encoding(char[] jz, long n) {
        long s = n / 36L;
        long y = n % 36L;
        int sInt = (int)s;
        int yInt = (int)y;
        if (s < 36L) {
            return (sInt == 0 ? "" : String.valueOf(jz[sInt])) + jz[yInt];
        }
        return Rs.Encoding(jz, s) + jz[yInt];
    }

    protected Rs() {
    }
}

