/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class BooleanConverter
extends Converter {
    Boolean source;

    public BooleanConverter(Boolean source) {
        this.source = source != null && source != false;
    }

    @Override
    public boolean convertToBoolean() {
        return this.source;
    }

    @Override
    public Byte convertToByte() {
        return (byte)(this.source != false ? 1 : 0);
    }

    @Override
    public Short convertToShort() {
        return (short)(this.source != false ? 1 : 0);
    }

    @Override
    public Integer convertToInt() {
        return this.source != false ? 1 : 0;
    }

    @Override
    public Long convertToLong() {
        return this.source != false ? 1L : 0L;
    }

    @Override
    public Float convertToFloat() {
        return Float.valueOf(this.source != false ? 1.0f : 0.0f);
    }

    @Override
    public Double convertToDouble() {
        return this.source != false ? 1.0 : 0.0;
    }

    @Override
    public String convertToString() {
        return this.source != false ? "1" : "0";
    }

    @Override
    public Date convertToDate() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Boolean", "java.Util.Date", this.convertToString());
    }

    @Override
    public BigDecimal convertToDecimal() {
        return this.source != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public String convertToJsonString() {
        return this.source != false ? "true" : "false";
    }
}

