/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class ByteConverter
extends Converter {
    private Byte source;

    public ByteConverter(Byte source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() {
        return this.source != 0;
    }

    @Override
    public Byte convertToByte() throws JDiyConvertException {
        return this.source;
    }

    @Override
    public Short convertToShort() throws JDiyConvertException {
        return this.source.shortValue();
    }

    @Override
    public Integer convertToInt() {
        return this.source.intValue();
    }

    @Override
    public Long convertToLong() {
        return this.source.longValue();
    }

    @Override
    public Float convertToFloat() {
        return Float.valueOf(this.source.floatValue());
    }

    @Override
    public Double convertToDouble() {
        return this.source.doubleValue();
    }

    @Override
    public String convertToString() {
        return this.source.toString();
    }

    @Override
    public Date convertToDate() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Byte", "java.util.Date", this.source.toString());
    }

    @Override
    public BigDecimal convertToDecimal() {
        return BigDecimal.valueOf(this.source.byteValue());
    }

    @Override
    public String convertToJsonString() {
        return this.source.toString();
    }
}

