/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.BooleanConverter;
import net.jdiy.core.convert.ByteConverter;
import net.jdiy.core.convert.DateConverter;
import net.jdiy.core.convert.DecimalConverter;
import net.jdiy.core.convert.DoubleConverter;
import net.jdiy.core.convert.FloatConverter;
import net.jdiy.core.convert.IntegerConverter;
import net.jdiy.core.convert.LongConverter;
import net.jdiy.core.convert.NullConverter;
import net.jdiy.core.convert.ShortConverter;
import net.jdiy.core.convert.StringConverter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

public abstract class Converter {
    public static Converter newInstance(Object o) {
        Converter c;
        if (o == null) {
            c = new NullConverter();
        } else if (o instanceof String) {
            c = new StringConverter((String)o);
        } else if (o instanceof Integer) {
            c = new IntegerConverter((Integer)o);
        } else if (o instanceof Double) {
            c = new DoubleConverter((Double)o);
        } else if (o instanceof Date) {
            c = new DateConverter((Date)o);
        } else if (o instanceof Long) {
            c = new LongConverter((Long)o);
        } else if (o instanceof Byte) {
            c = new ByteConverter((Byte)o);
        } else if (o instanceof Short) {
            c = new ShortConverter((Short)o);
        } else if (o instanceof Float) {
            c = new FloatConverter((Float)o);
        } else if (o instanceof Boolean) {
            c = new BooleanConverter((Boolean)o);
        } else if (o instanceof BigDecimal) {
            c = new DecimalConverter((BigDecimal)o);
        } else {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.notSupport"), o.getClass().getName());
        }
        return c;
    }

    public abstract Byte convertToByte();

    public abstract boolean convertToBoolean();

    public abstract Short convertToShort();

    public abstract Integer convertToInt();

    public abstract Long convertToLong();

    public abstract Float convertToFloat();

    public abstract Double convertToDouble();

    public abstract String convertToString();

    public abstract Date convertToDate();

    public abstract BigDecimal convertToDecimal();

    public abstract String convertToJsonString();
}

